/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameReferenceIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    public OCRenameReferenceIntentionAction(@NotNull PsiElement element) {
        super(element);
    }

    @Override
    protected String getTextInternal() {
        return "Rename Reference";
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.rename.reference", new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement element) {
        return !ApplicationManager.getApplication().isUnitTestMode() && (element instanceof OCReferenceElement || element instanceof OCQualifiedExpression);
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiReference reference;
        PsiElement element = this.myElementPtr.getElement();
        PsiReference psiReference = reference = element != null ? element.getReference() : null;
        if (reference != null) {
            OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, editor, file2, project2, reference, null, reference.getCanonicalText());
            renamer.performInplaceRename();
        }
    }
}

