/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCQuickFix
implements IntentionAction,
LocalQuickFix {
    protected abstract String getTextInternal();

    public abstract boolean isAvailable();

    protected void invoke(PsiFile file2, @NotNull Project project2) {
    }

    @NotNull
    public String getText() {
        if (!this.isAvailable()) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return this.getTextInternal();
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.isAvailable();
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (FileModificationService.getInstance().prepareFileForWrite(file2)) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            this.invoke(file2, project2);
        }
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (this.isAvailable()) {
            PsiFile file2 = descriptor.getPsiElement().getContainingFile();
            this.invoke(file2.getProject(), null, file2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isSupportedInBatchMode() {
        return true;
    }
}

