/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import org.jetbrains.annotations.NotNull;

public class OCMacroReferenceElementImpl
extends OCReferenceElementImpl {
    public OCMacroReferenceElementImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    public OCSymbol resolveToSymbol() {
        OCSymbol symbol = super.resolveToSymbol();
        if (symbol != null) {
            return symbol;
        }
        String name = this.getCanonicalText();
        OCFile file2 = this.getContainingOCFile();
        if (file2 == null) {
            return null;
        }
        OCMacroSymbol macro = OCInclusionContextUtil.headerContext(file2).getDefinition(name);
        if (macro != null) {
            return new OCMacroSymbol(OCInclusionContextUtil.getVirtualFile(file2), OCSymbolOffsetUtil.getComplexOffset(this), name, macro.getParameterNames(), macro.getSubstitution());
        }
        return null;
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Override
    public PsiElement resolve() {
        OCSymbol symbol = super.resolveToSymbol();
        if (symbol != null) {
            return symbol.locateDefinition(this.getProject());
        }
        return this;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        return element instanceof OCDefineDirective && this.getTextWithMacros().equals(((OCDefineDirective)element).getName());
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitMacroReferenceElement(this);
    }
}

