/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParsingNameScope
implements DeepEqual.Equality<OCParsingNameScope> {
    private static final String LOCAL_SCOPE_NAME = "$LOCAL_SCOPE$";
    public static final String GLOBAL_SCOPE_NAME = "";
    private static final int LAST_COMPONENT_INDEX = 0x3FFFFFFF;
    @NotNull
    private final String myName;
    @Nullable
    private Set<String> myProtocolNames;
    @Nullable
    private Map<String, Kind> myNameKinds;
    @Nullable
    private Map<String, OCParsingNameScope> myInnerScopes;
    @Nullable
    private List<OCParsingNameScope> myNamespaceUsings;
    @Nullable
    private final OCParsingNameScope myParent;
    @Nullable
    private OCParsingNameScope myDelegate;
    @Nullable
    private List<TemplateTypeParameter> myTemplateTypeParameters;
    @Nullable
    private List<String> myTemplateValueParameters;
    public static final TObjectHashingStrategy<OCParsingNameScope> HASHING_STRATEGY = new TObjectHashingStrategy<OCParsingNameScope>(){

        public boolean equals(OCParsingNameScope o1, OCParsingNameScope o2) {
            return DeepEqual.equalObjects(o1, o2);
        }

        public int computeHashCode(OCParsingNameScope scope) {
            int result2 = scope.myName.hashCode();
            result2 = 31 * result2 + (scope.myNameKinds != null ? scope.myNameKinds.size() : 0);
            result2 = 31 * result2 + (scope.myProtocolNames != null ? scope.myProtocolNames.size() : 0);
            result2 = 31 * result2 + (scope.myNamespaceUsings != null ? scope.myNamespaceUsings.size() : 0);
            result2 = 31 * result2 + (scope.myParent != null ? scope.myParent.myName.hashCode() : 0);
            result2 = 31 * result2 + (scope.myInnerScopes != null ? scope.myInnerScopes.size() : 0);
            return result2;
        }
    };

    @Nullable
    public OCParsingNameScope getDelegate() {
        return this.myDelegate;
    }

    public OCParsingNameScope() {
        this(GLOBAL_SCOPE_NAME, null);
    }

    @NotNull
    public OCParsingNameScope copy() {
        return this.delegatingCopy();
    }

    @NotNull
    public OCParsingNameScope delegatingCopy() {
        OCParsingNameScope parent = this.getParent();
        OCParsingNameScope result2 = this.newScope(this.getName(), parent == null ? null : parent.delegatingCopy());
        result2.myDelegate = this;
        return result2;
    }

    @NotNull
    protected OCParsingNameScope newScope(@NotNull String name, @Nullable OCParsingNameScope parentCopy) {
        return new OCParsingNameScope(name, parentCopy);
    }

    @NotNull
    public OCParsingNameScope mergeToDelegate() {
        if (this.myDelegate == null) {
            return this;
        }
        this.myDelegate.addProtocolNames(this.myProtocolNames);
        this.myDelegate.addNameKinds(this.myNameKinds);
        if (this.myInnerScopes != null) {
            for (Map.Entry<String, OCParsingNameScope> entry : this.myInnerScopes.entrySet()) {
                String name = entry.getKey();
                OCParsingNameScope scope = entry.getValue();
                OCParsingNameScope delegateScope = this.myDelegate.getInnerScope(name);
                if (delegateScope != null) {
                    delegateScope.merge(scope);
                    continue;
                }
                this.myDelegate.addInnerScope(name, scope);
            }
        }
        this.myDelegate.addNamespaceUsings(this.myNamespaceUsings);
        return this.myDelegate;
    }

    private OCParsingNameScope getInnerScope(@Nullable String name) {
        return this.myInnerScopes == null || name == null ? null : this.myInnerScopes.get(name);
    }

    private void addInnerScope(@NotNull String name, @NotNull OCParsingNameScope scope) {
        if (this.myInnerScopes == null) {
            this.myInnerScopes = new Object2ObjectOpenHashMap();
        }
        this.myInnerScopes.put(name, scope);
    }

    private void merge(@NotNull OCParsingNameScope scope) {
        this.addProtocolNames(scope.myProtocolNames);
        this.addNameKinds(scope.myNameKinds);
        this.addInnerScopes(scope.myInnerScopes);
        this.addNamespaceUsings(scope.myNamespaceUsings);
    }

    private void addNameKinds(@Nullable Map<String, Kind> nameKinds) {
        if (nameKinds == null) {
            return;
        }
        if (this.myNameKinds == null) {
            this.myNameKinds = new HashMap<String, Kind>(nameKinds);
        } else {
            this.myNameKinds.putAll(nameKinds);
        }
    }

    private void addInnerScopes(@Nullable Map<String, OCParsingNameScope> scopes) {
        if (scopes == null) {
            return;
        }
        if (this.myInnerScopes == null) {
            this.myInnerScopes = new HashMap<String, OCParsingNameScope>(scopes);
        } else {
            this.myInnerScopes.putAll(scopes);
        }
    }

    private void addProtocolNames(@Nullable Set<String> protocolNames) {
        if (protocolNames == null) {
            return;
        }
        if (this.myProtocolNames == null) {
            this.myProtocolNames = new HashSet<String>(protocolNames);
        } else {
            this.myProtocolNames.addAll(protocolNames);
        }
    }

    private void addNamespaceUsings(@Nullable List<OCParsingNameScope> namespaceUsings) {
        if (namespaceUsings == null) {
            return;
        }
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>(namespaceUsings);
        } else {
            this.myNamespaceUsings.addAll(namespaceUsings);
        }
    }

    @NotNull
    private String getNiceName() {
        if (this.getName() == GLOBAL_SCOPE_NAME) {
            return "::";
        }
        if (this.getName() == LOCAL_SCOPE_NAME) {
            return "<local>";
        }
        return this.getName();
    }

    protected OCParsingNameScope(@NotNull String name, @Nullable OCParsingNameScope parent) {
        this.myName = name;
        this.myParent = parent;
        if (parent != null) {
            OCParsingNameScope delegate;
            parent.addInnerScope(name, this);
            if (parent.myDelegate != null && (delegate = parent.myDelegate.getInnerScope(name)) != null) {
                this.myDelegate = delegate;
            }
        }
    }

    public static Kind getTypeKind(boolean isTemplate) {
        return isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
    }

    public static boolean isTemplate(@Nullable Kind kind) {
        return kind == Kind.CPP_CONCEPT || kind == Kind.TEMPLATE_TYPE || kind == Kind.TEMPLATE_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.OBJC_INTERFACE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isCppType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isValue(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_VALUE || kind == Kind.TEMPLATE_VALUE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    @Nullable
    public OCParsingNameScope getParent() {
        return this.myParent;
    }

    public OCParsingNameScope dropAndGetParent() {
        if (this.myParent != null && this.myParent.myInnerScopes != null) {
            this.myParent.myInnerScopes.remove(this.myName);
        }
        return this.myParent;
    }

    @NotNull
    public Collection<OCParsingNameScope> getInnerScopes() {
        return this.myInnerScopes == null ? Collections.emptyList() : this.myInnerScopes.values();
    }

    @NotNull
    public Collection<String> getDefinedNames() {
        return this.myNameKinds == null ? Collections.emptyList() : this.myNameKinds.keySet();
    }

    @Nullable
    public Kind getKind(String qualifiedName) {
        return this.getKind(Collections.singletonList(qualifiedName));
    }

    @Nullable
    public Kind getKind(List<String> qualifiedName) {
        ResolveContext context2 = new ResolveContext();
        if (qualifiedName.size() > 1 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            return this.getKindInGlobal(qualifiedName, context2);
        }
        return this.getKindWithParents(qualifiedName, 0, context2);
    }

    @Nullable
    private Kind getKindTerminal(@NotNull String qualifiedName, @Nullable ResolveContext context2) {
        Kind result2 = null;
        OCParsingNameScope scope = this;
        while (result2 == null && scope != null) {
            Kind kind = result2 = scope.myNameKinds == null ? null : scope.myNameKinds.get(qualifiedName);
            if (result2 == null && scope.myNamespaceUsings != null) {
                if (context2 == null) {
                    context2 = new ResolveContext();
                }
                if (context2.shouldCheckAtOffset(scope, 0x3FFFFFFF)) {
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        Kind r = using.getKindTerminal(qualifiedName, context2);
                        if (!OCParsingNameScope.isType(r) && !OCParsingNameScope.isValue(r)) continue;
                        result2 = r;
                        break;
                    }
                }
            }
            scope = scope.myDelegate;
        }
        return result2;
    }

    public boolean isProtocol(@Nullable String name) {
        return this.isProtocol(name, true);
    }

    protected boolean isProtocol(@Nullable String name, boolean shouldCheckDelegates) {
        return this.myProtocolNames != null && this.myProtocolNames.contains(name) || shouldCheckDelegates && this.myDelegate != null && this.myDelegate.isProtocol(name, true) || this.myParent != null && this.myParent.isProtocol(name, this.myDelegate == null);
    }

    @Nullable
    protected Kind getKind(List<String> qualifiedName, int offset, ResolveContext context2) {
        String namePart;
        Kind result2 = OCParsingNameScope.getKindIfDecltype(qualifiedName, offset, context2);
        if (result2 != null) {
            return result2;
        }
        if (qualifiedName.size() == 1) {
            if (this.myTemplateValueParameters != null && this.myTemplateValueParameters.contains(qualifiedName.get(0))) {
                return Kind.SIMPLE_VALUE;
            }
            if (this.myTemplateTypeParameters != null) {
                for (TemplateTypeParameter pair : this.myTemplateTypeParameters) {
                    if (!pair.name.equals(qualifiedName.get(0))) continue;
                    return pair.isTemplateTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
                }
            }
        }
        if ((namePart = qualifiedName.get(offset)) != null && qualifiedName.size() == offset + 1) {
            result2 = this.getKindTerminal(namePart, context2);
        } else {
            OCParsingNameScope scope = this;
            while (result2 == null && scope != null) {
                OCParsingNameScope child = scope.getInnerScope(namePart);
                if (child != null && (result2 = child.getKind(qualifiedName, offset + 1, context2)) == null) {
                    result2 = Kind.UNKNOWN;
                }
                if (result2 == null && scope.myNamespaceUsings != null && context2.shouldCheckAtOffset(scope, offset)) {
                    boolean foundNonType = false;
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        result2 = using.getKindWithParents(qualifiedName, offset, context2);
                        if (result2 == Kind.NON_TYPE) {
                            foundNonType = true;
                            continue;
                        }
                        if (result2 == null) continue;
                        break;
                    }
                    if (result2 == null && foundNonType) {
                        result2 = Kind.NON_TYPE;
                    }
                }
                scope = scope.myDelegate;
            }
        }
        return result2;
    }

    @Nullable
    private Kind getKindWithParents(List<String> qualifiedName, int offset, ResolveContext context2) {
        Kind result2 = this.getKind(qualifiedName, offset, context2);
        if (this.myParent != null) {
            if (result2 == null) {
                return this.myParent.getKindWithParents(qualifiedName, offset, context2);
            }
            if (result2 == Kind.NON_TYPE) {
                Kind parentResult = this.myParent.getKindWithParents(qualifiedName, offset, context2);
                return parentResult != null ? parentResult : Kind.NON_TYPE;
            }
        }
        return result2;
    }

    @Nullable
    private Kind getKindInGlobal(List<String> qualifiedName, ResolveContext context2) {
        if (this.myParent != null) {
            return this.myParent.getKindInGlobal(qualifiedName, context2);
        }
        if (qualifiedName.size() > 1) {
            return this.getKind(qualifiedName, 1, context2);
        }
        return Kind.TEMPLATE_TYPE;
    }

    private static Kind getKindIfDecltype(List<String> qualifiedName, int offset, ResolveContext context2) {
        assert (offset >= 0 && offset < qualifiedName.size());
        String namePart = qualifiedName.get(offset);
        if (namePart != null && OCTokenTypes.DECLTYPE_CPP_KEYWORD.getName().contentEquals(namePart)) {
            return Kind.SIMPLE_TYPE;
        }
        return null;
    }

    public void defineConcept(@NotNull String qualifiedName) {
        Kind kind = Kind.CPP_CONCEPT;
        if (this.getKind(qualifiedName) != null) {
            return;
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate) {
        this.defineType(qualifiedName, isTemplate, false);
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate, boolean isFriend) {
        Kind kind = isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isValue(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else {
            if (existing == Kind.TEMPLATE_TYPE) {
                return;
            }
            if (isFriend && this.getKind(qualifiedName) != null) {
                this.getKind(qualifiedName);
                return;
            }
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineInterface(String qualifiedName) {
        Kind kind = Kind.OBJC_INTERFACE;
        if (OCParsingNameScope.isValue(this.getKindTerminal(qualifiedName, null))) {
            kind = Kind.TYPE_AND_VALUE;
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineProtocol(String name) {
        if (this.myProtocolNames == null) {
            this.myProtocolNames = new THashSet();
        }
        this.myProtocolNames.add(name);
    }

    public void defineValue(String qualifiedName, boolean isTemplate) {
        Kind kind = isTemplate ? Kind.TEMPLATE_VALUE : Kind.SIMPLE_VALUE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isType(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else if (existing == Kind.TEMPLATE_VALUE) {
            return;
        }
        this.registerKind(qualifiedName, kind);
    }

    private void registerKind(String name, Kind kind) {
        if (this.myNameKinds == null) {
            this.myNameKinds = new Object2ObjectOpenHashMap();
        }
        this.myNameKinds.put(name, kind);
    }

    public OCParsingNameScope defineNamespace(@NotNull String name) {
        OCParsingNameScope scope = this.getInnerScope(name);
        if (scope == null || scope.getParent() != this) {
            scope = this.newScope(name, this);
        }
        return scope;
    }

    public OCParsingNameScope defineLocalScope() {
        return this.newScope(LOCAL_SCOPE_NAME, this);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "OCParsingNameScope{" + this.getNiceName() + "}";
    }

    public void defineNamespaceAlias(String alias, String namespaceName) {
        this.defineNamespaceAlias(alias, Collections.singletonList(namespaceName));
    }

    public void defineNamespaceAlias(String alias, List<String> namespaceName) {
        OCParsingNameScope scope = this.resolveNamespace(namespaceName);
        if (scope != null) {
            this.addInnerScope(alias, scope);
        }
    }

    public void defineNamespaceUsing(@NotNull List<String> qualifiedName) {
        OCParsingNameScope scope;
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>();
        }
        if ((scope = this.resolveNamespace(qualifiedName)) != null && scope != this && !this.myNamespaceUsings.contains(scope)) {
            this.myNamespaceUsings.add(scope);
        }
    }

    public void defineNamespaceUsing(@NotNull String name) {
        this.defineNamespaceUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull String name) {
        this.defineSymbolUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull List<String> qualifiedName) {
        Kind kind = this.getKind(qualifiedName);
        boolean isType = OCParsingNameScope.isType(kind);
        if (!isType && !OCParsingNameScope.isValue(kind)) {
            return;
        }
        String alias = qualifiedName.get(qualifiedName.size() - 1);
        this.registerKind(alias, kind);
        if (isType) {
            this.defineNamespaceAlias(alias, qualifiedName);
        }
    }

    @NotNull
    public List<String> getTemplateValueParameters() {
        return this.myTemplateValueParameters != null ? this.myTemplateValueParameters : Collections.emptyList();
    }

    @NotNull
    public List<TemplateTypeParameter> getTemplateTypeParameters() {
        return this.myTemplateTypeParameters != null ? this.myTemplateTypeParameters : Collections.emptyList();
    }

    public void addTemplateValueParameter(@NotNull String qualifiedName) {
        if (this.myTemplateValueParameters == null) {
            this.myTemplateValueParameters = new ArrayList<String>();
        }
        this.myTemplateValueParameters.add(qualifiedName);
    }

    public void addTemplateTypeParameter(@NotNull String qualifiedName, boolean isTemplateTemplate) {
        if (this.myTemplateTypeParameters == null) {
            this.myTemplateTypeParameters = new ArrayList<TemplateTypeParameter>();
        }
        this.myTemplateTypeParameters.add(new TemplateTypeParameter(qualifiedName, isTemplateTemplate));
    }

    public void clearTemplateParameters() {
        this.myTemplateValueParameters = null;
        this.myTemplateTypeParameters = null;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(@NotNull List<String> qualifiedName) {
        OCParsingNameScope result2;
        ResolveContext context2 = new ResolveContext();
        if (qualifiedName.size() > 0 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            OCParsingNameScope global = this;
            while (global.myParent != null) {
                global = global.myParent;
            }
            result2 = global.resolveNamespace(qualifiedName, 1, context2);
        } else {
            result2 = this.resolveNamespace(qualifiedName, 0, context2);
        }
        return result2;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(List<String> qualifiedName, int offset, ResolveContext context2) {
        if (offset == qualifiedName.size()) {
            return this;
        }
        OCParsingNameScope result2 = null;
        String name = qualifiedName.get(offset);
        OCParsingNameScope scope = this;
        while (result2 == null && scope != null) {
            OCParsingNameScope child = scope.getInnerScope(name);
            if (child != null) {
                result2 = child.resolveNamespace(qualifiedName, offset + 1, context2);
            }
            if (result2 == null && scope.myNamespaceUsings != null && context2.shouldCheckAtOffset(scope, offset)) {
                OCParsingNameScope using;
                Iterator<OCParsingNameScope> iterator2 = scope.myNamespaceUsings.iterator();
                while (iterator2.hasNext() && (result2 = (using = iterator2.next()).resolveNamespace(qualifiedName, offset, context2)) == null) {
                }
            }
            scope = scope.myDelegate;
        }
        if (result2 == null && this.myParent != null) {
            result2 = this.myParent.resolveNamespace(qualifiedName, offset, context2);
        }
        return result2;
    }

    @Override
    public final boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCParsingNameScope first, @NotNull OCParsingNameScope second) {
        if (!first.myName.equals(second.myName)) {
            return false;
        }
        if (!Objects.equals(first.myNameKinds, second.myNameKinds)) {
            return false;
        }
        if (!Objects.equals(first.myProtocolNames, second.myProtocolNames)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateTypeParameters, second.myTemplateTypeParameters)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateValueParameters, second.myTemplateValueParameters)) {
            return false;
        }
        if (!c.equalLists(first.myNamespaceUsings, second.myNamespaceUsings)) {
            return false;
        }
        if (!c.equalObjects(first.myParent, second.myParent)) {
            return false;
        }
        return c.equalMaps(first.myInnerScopes, second.myInnerScopes);
    }

    private static class ResolveContext {
        private Map<OCParsingNameScope, List<Integer>> myCurrentOffsets;

        private ResolveContext() {
        }

        public boolean shouldCheckAtOffset(@NotNull OCParsingNameScope scope, int positionInName) {
            SmartList checkedPositions;
            if (this.myCurrentOffsets == null) {
                this.myCurrentOffsets = new Object2ObjectOpenHashMap();
                checkedPositions = null;
            } else {
                checkedPositions = this.myCurrentOffsets.get(scope);
            }
            if (checkedPositions == null) {
                checkedPositions = new SmartList((Object)positionInName);
                this.myCurrentOffsets.put(scope, (List<Integer>)checkedPositions);
            } else if (!checkedPositions.contains(positionInName)) {
                checkedPositions.add(positionInName);
            } else {
                return false;
            }
            return true;
        }
    }

    public static final class TemplateTypeParameter {
        @NotNull
        public final String name;
        public final boolean isTemplateTemplate;

        private TemplateTypeParameter(@NotNull String name, boolean isTemplateTemplate) {
            this.name = name;
            this.isTemplateTemplate = isTemplateTemplate;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateTypeParameter)) {
                return false;
            }
            TemplateTypeParameter parameter = (TemplateTypeParameter)o;
            return this.isTemplateTemplate == parameter.isTemplateTemplate && this.name.equals(parameter.name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + Boolean.hashCode(this.isTemplateTemplate);
        }
    }

    public static enum Kind {
        UNKNOWN,
        SIMPLE_TYPE,
        TEMPLATE_TYPE,
        SIMPLE_VALUE,
        TEMPLATE_VALUE,
        OBJC_INTERFACE,
        TYPE_AND_VALUE,
        CPP_CONCEPT,
        NON_TYPE;

    }
}

