/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCInclusionContext
extends OCImmutableInclusionContext {
    @Override
    @NotNull
    public OCLanguageKind getLanguageKind();

    public OCInclusionContext setRootFile(@Nullable PsiFile var1);

    public void setInheritProcessedFiles(boolean var1);

    public void addProcessedFile(@NotNull VirtualFile var1);

    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable var1);

    public void setProcessingListener(@Nullable Processor<OCSymbol> var1);

    public void setResolvePathListener(@Nullable ResolvePathListener var1);

    public void setChangeBuilder(@Nullable OCContextChangeBuilder var1);

    public void setPrecompiledHeaders(@NotNull List<VirtualFile> var1);

    @NotNull
    public OCParsingNameScope getNameScope();

    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean var1);

    @NotNull
    public OCInclusionContext deriveWithLanguageKind(@NotNull OCLanguageKind var1);

    public void define(@NotNull OCMacroSymbol var1);

    public void define(String var1, String var2);

    public void undef(String var1);

    public void hideDefinition(@NotNull String var1);

    public void revealDefinition(@NotNull String var1);

    public void setSignatureBuilder(@Nullable SignatureBuilder var1);

    public void enterNamespace(@NotNull String var1);

    public void exitNamespace();

    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull VirtualFile var2, boolean var3);

    public boolean reserveInclude(@NotNull VirtualFile var1, boolean var2);

    public void preprocessContextOf(@Nullable PsiFile var1, @Nullable VirtualFile var2);

    public void preprocessInclude(@Nullable PsiFile var1, boolean var2);

    public boolean preprocessInclude(@Nullable PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4);

    @Contract(value="_, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable VirtualFile var1, @Nullable VirtualFile var2, int var3, int var4, int var5, @NotNull List<OCSymbol> var6, @Nullable OCContextChangeSet var7);

    public boolean preprocessInclude(@NotNull VirtualFile var1, boolean var2, @Nullable VirtualFile var3, int var4, int var5, @Nullable OCContextChangeSet var6);

    public void markAsSurrogate();

    @Nullable
    public Runnable getImpatientRescheduling();

    public void setImpatientRescheduling(@Nullable Runnable var1);

    public void setAbortOnLanguageKindMismatch(boolean var1);

    public static int getMaxInclusionLevel() {
        Integer inTests = OCInclusionContextImpl.MAX_INCLUSION_LEVEL_IN_TESTS;
        return inTests != null ? inTests : OCInclusionContextImpl.DEFAULT_MAX_INCLUSION_LEVEL;
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file2, @NotNull OCResolveConfiguration configuration) {
        return OCInclusionContext.isPrecompiledHeader(file2, configuration.getProject());
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file2, @NotNull Project project2) {
        return OCInclusionContextImpl.getPCHCache(project2).isPCH(file2);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project2) {
        if (pchFile == null) {
            return Collections.emptyList();
        }
        return OCInclusionContextImpl.getPCHCache(project2).getConfigurations(pchFile);
    }

    public static void onPrecompiledContextChange(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY, null);
    }

    public static void clearSymbolTableConformanceCache(OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INCLUDE_RESOLVE_CACHE, null);
    }

    @NotNull
    public static OCInclusionContext empty(@NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return new OCInclusionContextImpl(null, file2.getProject(), kind, null).setRootFile(file2);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCFile file2) {
        OCResolveConfiguration configuration = OCInclusionContextUtil.getActiveConfiguration(file2);
        return configuration == null ? OCInclusionContextImpl.emptyWithBuiltinMacros(file2.getKind(), file2) : OCInclusionContext.beforePCHFileContext(configuration, file2.getKind(), file2);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContext.initialContextWithoutRoot(configuration, kind, file2).derive(file2);
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContext.sourceParsingContext(configuration, kind, file2, false);
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2, boolean isSurrogate) {
        OCInclusionContext result2 = OCInclusionContext.initialPCHContextWithoutRoot(configuration, kind, file2).derive(file2);
        if (isSurrogate) {
            result2.markAsSurrogate();
        }
        return result2;
    }

    @NotNull
    public static OCImmutableInclusionContext initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file2);
    }

    @NotNull
    public static OCImmutableInclusionContext initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContextImpl.initialPCHContextWithoutRoot(configuration, kind, file2);
    }

    @Nullable
    public static OCImmutableInclusionContext tryFindInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (OCInclusionContext.isPrecompiledHeader(pchCandidate, config) && OCImportGraph.getInstance(config.getProject()).getAllRootHeaders(config, pchCandidate, null, false).contains(header)) {
            return OCInclusionContextImpl.findInCachedPCHPrecompiledContexts(config, header);
        }
        return null;
    }

    @Nullable
    public static String extractFirstPathLiteralText(@NotNull CharSequence contentWithoutMacros) {
        IElementType tt;
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(contentWithoutMacros, 0, contentWithoutMacros.length(), 10);
        while (lexer.getState() == 10 && (tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.HEADER_PATH_LITERAL) {
                return lexer.getTokenText();
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static OCIncludeSymbol.IncludePath extractPath(@Nullable CharSequence rawPathLiteralContext, boolean unescapePath) {
        char maybeSuffixPunctuator;
        int length;
        if (rawPathLiteralContext == null || (length = rawPathLiteralContext.length()) < 2) {
            return OCIncludeSymbol.IncludePath.EMPTY;
        }
        int start = 0;
        char prefixPunctuator = rawPathLiteralContext.charAt(0);
        if (prefixPunctuator == '\"' || prefixPunctuator == '<') {
            start = 1;
        }
        if ((maybeSuffixPunctuator = rawPathLiteralContext.charAt(length - 1)) == '\"' && prefixPunctuator == '\"' || maybeSuffixPunctuator == '>' && prefixPunctuator == '<') {
            --length;
        }
        String path = rawPathLiteralContext.subSequence(start, length).toString();
        if (unescapePath) {
            path = path.replace("\\\n", "");
        }
        return new OCIncludeSymbol.IncludePath(path, prefixPunctuator != '\"');
    }

    @NotNull
    public static OCLanguageKind handleLanguageKindMismatch(@NotNull VirtualFile rootFile, @NotNull LanguageKindMismatchException e, boolean allowFallback) {
        boolean rootResponsible;
        if (!allowFallback) {
            AssertionError assertionError = new AssertionError("Unexpected language kind mismatch", e);
            OCInclusionContextImpl.LOG.error((Throwable)((Object)assertionError));
            throw assertionError;
        }
        OCInclusionContextImpl.LOG.trace((Throwable)e);
        VirtualFile responsibleFile = e.responsibleFile;
        boolean bl = rootResponsible = responsibleFile == null;
        if (rootResponsible) {
            responsibleFile = rootFile;
        }
        if (!e.attemptedLanguageKind.isObjC() && e.requiredLanguageKind.isObjC()) {
            OCLanguageKindCalculator.markAsObjC(responsibleFile);
        }
        if (rootResponsible && e.rootFile != null) {
            e.rootFile.clearCaches();
        }
        return e.requiredLanguageKind;
    }

    public static class LanguageKindMismatchException
    extends RuntimeException
    implements ControlFlowException {
        @NotNull
        final OCLanguageKind attemptedLanguageKind;
        @NotNull
        final OCLanguageKind requiredLanguageKind;
        @Nullable
        final PsiFile rootFile;
        @NotNull
        final VirtualFile includedFile;
        @Nullable
        VirtualFile responsibleFile;

        LanguageKindMismatchException(@NotNull OCLanguageKind attemptedLanguageKind, @NotNull OCLanguageKind requiredLanguageKind, @Nullable PsiFile rootFile, @NotNull VirtualFile includedFile) {
            this.attemptedLanguageKind = attemptedLanguageKind;
            this.requiredLanguageKind = requiredLanguageKind;
            this.rootFile = rootFile;
            this.includedFile = includedFile;
        }

        @Override
        public String getMessage() {
            VirtualFile responsibleFile = this.responsibleFile;
            return "Language Kind did not match.\nwas {" + this.attemptedLanguageKind.getShortDisplayName() + "}, but expected {" + this.requiredLanguageKind.getShortDisplayName() + "}\n" + (this.rootFile != null ? "for file {" + LanguageKindMismatchException.getPresentableUrl(this.rootFile) + "}\n" : "") + "due to including of file {" + this.includedFile.getPresentableUrl() + "}\n" + (responsibleFile != null ? "from file {" + responsibleFile.getPresentableUrl() + "}" : "");
        }

        @NotNull
        private static String getPresentableUrl(@NotNull PsiFile psiFile) {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
            return file2 != null ? file2.getPresentableUrl() : psiFile.getName();
        }
    }

    public static interface ResolvePathListener {
        public void resolve(@NotNull OCIncludeSymbol.IncludePath var1, boolean var2, @Nullable VirtualFile var3);
    }

    public static interface SignatureBuilder {
        public void setDefined(@NotNull String var1, boolean var2);

        public void setHeaderGuardDefined(@NotNull String var1, boolean var2);

        public void setDefinition(@NotNull String var1, @NotNull OCMacroSymbol var2);

        public void enterConformanceCheckMode();

        public void exitConformanceCheckMode(boolean var1);
    }
}

