/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.settings.OCGotoDefinitionSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        PsiFile file2;
        PsiFile psiFile = file2 = sourceElement != null ? sourceElement.getContainingFile() : null;
        if (!(file2 instanceof OCFile)) {
            return null;
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        Collection<? extends OCSymbol> symbols = OCGotoDeclarationHandler.getTargetSymbols(editor, sourceElement, offset);
        for (OCSymbol oCSymbol : symbols) {
            PsiElement element = oCSymbol.locateDefinition(file2.getProject());
            int adjustedOffset = TargetElementUtil.adjustOffset((PsiFile)file2, (Document)editor.getDocument(), (int)offset);
            if (element == null || OCGotoDeclarationHandler.isInsideElement(element, sourceElement, adjustedOffset)) continue;
            if (element instanceof OCCallable && OCElementUtil.getElementType(file2.findElementAt(offset)) != OCTokenTypes.IDENTIFIER) {
                return null;
            }
            elements.add(element);
        }
        return elements.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Contract(value="null,_,_ -> false; _,null,_ -> false")
    private static boolean isInsideElement(@Nullable PsiElement parent, @Nullable PsiElement child, int offset) {
        return parent != null && child != null && parent.getTextRange().contains(offset) && parent.getContainingFile() == child.getContainingFile();
    }

    private static Collection<? extends OCSymbol> getTargetSymbols(Editor editor, @NotNull PsiElement sourceElement, int offset) {
        OCSymbol symbol;
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags() | 0x1000, offset);
        Collection<OCSymbol> namespaces = null;
        if (source instanceof OCCppNamespaceQualifier) {
            namespaces = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source);
        } else {
            ASTNode node2 = sourceElement.getNode();
            if (node2 != null && node2.getElementType() == OCTokenTypes.IDENTIFIER && sourceElement.getParent() instanceof OCCppNamespaceQualifier) {
                namespaces = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)sourceElement.getParent());
            }
        }
        if (!ContainerUtil.isEmpty(namespaces)) {
            return namespaces;
        }
        OCSymbol oCSymbol = symbol = source instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)source).getSymbol() : null;
        if (symbol == null) {
            return Collections.emptyList();
        }
        if (symbol instanceof OCFunctionGroupSymbol) {
            return ((OCFunctionGroupSymbol)symbol).getOverloads();
        }
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        boolean insideElement = OCGotoDeclarationHandler.isInsideElement(source, sourceElement, offset);
        Project project2 = sourceElement.getProject();
        if (symbol.isCallable() || insideElement) {
            OCInterfaceSymbol mainInterface;
            OCSendMessageExpression sendMessageExpression;
            OCObjectTypeContext receiverContext;
            PsiReference reference;
            OCSymbol definitionSymbol = null;
            if (symbol instanceof OCMethodSymbol && (reference = TargetElementUtil.findReference((Editor)editor, (int)offset)) != null && reference.getElement() instanceof OCSendMessageExpression && (receiverContext = (sendMessageExpression = (OCSendMessageExpression)reference.getElement()).getReceiverContext()) != null) {
                definitionSymbol = receiverContext.getKnownResponder(sendMessageExpression.getMessageSelector(), false);
            }
            if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface(project2)) != null) {
                result2.add(mainInterface);
            }
            if (definitionSymbol == null) {
                definitionSymbol = symbol.getDefinitionSymbol(project2);
            }
            if (definitionSymbol == symbol && insideElement && OCGotoDefinitionSettings.getInstance().shouldJumpToAssociatedSymbol) {
                OCSymbol declSymbol;
                OCCppNamespaceQualifier namespaceQualifier = source instanceof OCDeclarator ? ((OCDeclarator)source).getNamespaceQualifier() : null;
                List<Object> parentSymbols = namespaceQualifier != null ? namespaceQualifier.resolveToSymbols() : Collections.emptyList();
                OCSymbol parentSymbol = parentSymbols.size() == 1 ? (OCSymbol)parentSymbols.get(0) : null;
                OCSymbol oCSymbol2 = declSymbol = parentSymbol instanceof OCStructSymbol ? ((OCStructSymbol)parentSymbol).findMember(symbol.getName()) : null;
                if (declSymbol == null || !declSymbol.isSameSymbol(symbol, project2)) {
                    declSymbol = symbol.getAssociatedSymbol(project2);
                }
                if (!(declSymbol == null || symbol instanceof OCClassSymbol && StringUtil.isEmpty((String)((OCClassSymbol)symbol).getCategoryName()) && !result2.isEmpty())) {
                    result2.add(declSymbol);
                }
                if (symbol instanceof OCMemberSymbol) {
                    OCSymbol relatedSymbol;
                    CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                        protected boolean accept(OCMemberSymbol memberSymbol) {
                            return !memberSymbol.isDefinition();
                        }
                    };
                    OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, true, false, project2);
                    if (finder.isFound()) {
                        result2.add(finder.getFoundValue());
                    }
                    if ((relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, project2)) != null) {
                        result2.add(relatedSymbol);
                    }
                }
            } else if (definitionSymbol != null) {
                result2.add(definitionSymbol);
            } else if (symbol instanceof OCMemberSymbol) {
                CommonProcessors.CollectProcessor<OCMemberSymbol> finder = new CommonProcessors.CollectProcessor<OCMemberSymbol>(){

                    protected boolean accept(OCMemberSymbol memberSymbol) {
                        return memberSymbol.isDefinition();
                    }
                };
                OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, false, true, project2);
                result2.addAll(finder.getResults());
            }
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                result2.add(symbol1);
                return true;
            }), project2);
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null) {
            PsiElement element = symbol.locateDefinition(project2);
            OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(project2);
            if (property != null && (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(project2) || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)element.getParent()).getPropertyRef() == element)) {
                symbol = property;
            }
        }
        if (result2.isEmpty()) {
            result2.add(symbol);
        }
        return result2;
    }

    private static Collection<OCSymbol> getAppropriateNamespaceDeclarations(OCCppNamespaceQualifier source) {
        Collection<OCSymbol> symbols;
        if (source.getParent() instanceof OCReferenceElement) {
            symbols = ((OCReferenceElement)source.getParent()).resolveToOverloadsSymbols();
        } else if (source.getParent() instanceof OCCppNamespaceQualifier) {
            symbols = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source.getParent());
        } else {
            return Collections.emptyList();
        }
        LinkedHashSet<OCSymbol> result2 = new LinkedHashSet<OCSymbol>();
        List<OCSymbol> ownSymbols = source.resolveToSymbols();
        for (OCSymbol ownSymbol : ownSymbols) {
            for (OCSymbol child : symbols) {
                if (!(child instanceof OCSymbolWithQualifiedName) || !ownSymbol.equals(((OCSymbolWithQualifiedName)child).getParent()) || !OCGotoDeclarationHandler.isNamespaceWithVisibleName(ownSymbol)) continue;
                result2.add(ownSymbol);
            }
        }
        return result2;
    }

    private static boolean isNamespaceWithVisibleName(@NotNull OCSymbol symbol) {
        return symbol instanceof OCNamespaceSymbol && !((OCNamespaceSymbol)symbol).isSyntheticNamespace();
    }
}

