/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCInfiniteRecursionFinder
extends OCDataFlowAlgorithm {
    private boolean myExitOrDeadEndReached;
    private List<PsiElement> myRecursiveCalls;

    protected OCInfiniteRecursionFinder(@NotNull OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myExitOrDeadEndReached = true;
        final PsiElement codeFragment = this.myCfg.getCodeFragment();
        if (!(codeFragment instanceof OCCallable)) {
            return;
        }
        final OCSymbol symbol = ((OCCallable)codeFragment).getSymbol();
        if (symbol == null) {
            return;
        }
        this.myRecursiveCalls = new ArrayList<PsiElement>();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitCallExpression(OCCallExpression expression) {
                OCQualifiedExpression qualifiedExpression;
                super.visitCallExpression(expression);
                OCExpression caller = expression.getFunctionReferenceExpression();
                if (!(symbol instanceof OCFunctionSymbol)) {
                    return;
                }
                OCSymbol functionSymbol = null;
                if (caller instanceof OCReferenceExpression) {
                    functionSymbol = ((OCReferenceExpression)caller).resolveToSymbol();
                } else if (caller instanceof OCQualifiedExpression && (qualifiedExpression = (OCQualifiedExpression)caller).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)qualifiedExpression.getQualifier()).isCppThis()) {
                    functionSymbol = qualifiedExpression.resolveToSymbol();
                }
                if ((symbol.equals(functionSymbol) || functionSymbol != null && symbol.equals(functionSymbol.getAssociatedSymbol(expression.getProject()))) && !OCCodeInsightUtil.isStaticallyEvaluated(expression)) {
                    OCInfiniteRecursionFinder.this.myRecursiveCalls.add(expression);
                }
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                OCMethodSymbol responder;
                super.visitSendMessageExpression(expression);
                OCExpression receiver = expression.getReceiverExpression();
                if (!(symbol instanceof OCMethodSymbol) || !expression.getMessageSelector().equals(symbol.getName())) {
                    return;
                }
                if ((((OCMethodSymbol)symbol).isStatic() || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) && (symbol.equals(responder = expression.getProbableResponders().getKnownResponder()) || responder != null && symbol.equals(responder.getAssociatedSymbol(expression.getProject()))) && !OCCodeInsightUtil.isStaticallyEvaluated(expression)) {
                    OCInfiniteRecursionFinder.this.myRecursiveCalls.add(expression);
                }
            }

            @Override
            public void visitQualifiedExpression(OCQualifiedExpression expression) {
                super.visitQualifiedExpression(expression);
                OCExpression qualifier = expression.getQualifier();
                if (symbol instanceof OCMethodSymbol) {
                    String field = expression.getSymbolName();
                    PsiReference reference = expression.getReference();
                    if ((field.equals(symbol.getName()) || OCNameSuggester.getObjCSetterFromGetter(field).equals(symbol.getName())) && (((OCMethodSymbol)symbol).isStatic() || qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) && reference != null && !expression.processTargets(field, (Processor<OCSymbol>)((Processor)curSymbol -> !symbol.equals(curSymbol) || !reference.isReferenceTo(codeFragment)), true, null, false, false, null, OCResolveContext.forPsi(expression)) && !OCCodeInsightUtil.isStaticallyEvaluated(expression)) {
                        OCInfiniteRecursionFinder.this.myRecursiveCalls.add(expression);
                    }
                }
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
            }
        });
        if (this.myRecursiveCalls.isEmpty()) {
            return;
        }
        this.myExitOrDeadEndReached = false;
        this.clearProcessedNodes();
        this.traverse(this.myCfg.getStartNode(), null, null, true);
    }

    @NotNull
    public List<PsiElement> getRecursiveCalls() {
        return this.myRecursiveCalls;
    }

    public boolean isExitOrDeadEndReached() {
        return this.myExitOrDeadEndReached;
    }

    @Override
    protected boolean processNode(@NotNull OCNode node2, @Nullable OCSymbol symbol, boolean isForward, @Nullable OCInstruction startInstruction, @Nullable OCInstruction endInstruction) {
        OCElementsRange range = node2.getRange();
        if (range != null) {
            for (PsiElement call : this.myRecursiveCalls) {
                if (!range.getTextRange().contains(call.getTextRange())) continue;
                return false;
            }
        }
        if (this.myCfg.getExitNodes().contains(node2)) {
            this.myExitOrDeadEndReached = true;
        }
        return true;
    }

    @Override
    protected void processDeadEnd(@NotNull OCNode node2) {
        this.myExitOrDeadEndReached = true;
    }
}

