/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.SimplifyInspectionKt;
import com.jetbrains.cidr.lang.legacy.dfa.OCContextSensitiveControlFlowBuilder;
import com.jetbrains.cidr.lang.legacy.dfa.OCDFAUtils;
import com.jetbrains.cidr.lang.legacy.inspections.OCSimplifyInspectionLegacy;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAInspectionRunner
implements OCDFAInspection.Runner {
    private static final Boolean ENABLE_RML_PROFILING = false;
    private static final Boolean ENABLE_BDD_PROFILING = false;
    private static final Boolean ENABLE_RELATIONS_PROFILING = false;
    public static final Key<Set<OCCallable>> DFA_CALLABLE_SET = Key.create((String)"DFA_CALLABLE_SET");
    public static final Key<ProblemsHolder> TEST_PROBLEMS_HOLDER = Key.create((String)"TEST_PROBLEMS_HOLDER");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder) {
        final PsiFile file2 = holder.getFile();
        file2.putUserData(DFA_CALLABLE_SET, new HashSet());
        return new OCVisitor(){

            @Override
            public void visitBlockStatement(OCBlockStatement stmt) {
                OCCallable callable;
                if (stmt instanceof OCLazyBlockStatementImpl && (callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCCallable.class)) != null) {
                    ((Set)Objects.requireNonNull(file2.getUserData(DFA_CALLABLE_SET))).add(callable);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull OCFile file2, @NotNull ProblemsHolder problemsHolder, @NotNull OCDFAInspection inspection) {
        ProblemsHolder testProblemsHolder;
        HashMap<Class<ProfileManager>, Boolean> options2 = new HashMap<Class<ProfileManager>, Boolean>();
        if (ENABLE_RML_PROFILING.booleanValue()) {
            options2.put(ProfileManager.class, true);
        }
        if ((testProblemsHolder = (ProblemsHolder)file2.getUserData(TEST_PROBLEMS_HOLDER)) != null) {
            problemsHolder = testProblemsHolder;
        }
        Class<com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAInspectionRunner> clazz = com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAInspectionRunner.class;
        synchronized (com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAInspectionRunner.class) {
            file2.pushAnnotationSession(new AnnotationSession((PsiFile)file2));
            try {
                Ref contextSensitiveResult = Ref.create();
                Ref contextInsensitiveResult = Ref.create();
                long timeLimit = OCDFAUtils.getTimeLimit(file2);
                OCDFAUtils.WorkingTimeMeasurer measurer = new OCDFAUtils.WorkingTimeMeasurer(timeLimit);
                try {
                    OCFile root;
                    Set callableSet = (Set)Objects.requireNonNull(file2.getUserData(DFA_CALLABLE_SET));
                    OCFile oCFile = root = callableSet.size() == 1 ? (PsiElement)callableSet.iterator().next() : file2;
                    if (root.getContainingFile() != file2) {
                        root = file2;
                    }
                    OCDFAInspectionRunner.runAnalysisInParallel(root, new HashMap<Object, Object>(options2), true, measurer, (Ref<Result>)contextSensitiveResult);
                    OCDFAInspectionRunner.runAnalysisInParallel(root, new HashMap<Object, Object>(options2), false, measurer, (Ref<Result>)contextInsensitiveResult);
                    try {
                        Class<Result> clazz2 = Result.class;
                        synchronized (Result.class) {
                            while (contextSensitiveResult.isNull() || contextInsensitiveResult.isNull()) {
                                Result.class.wait();
                            }
                            // ** MonitorExit[var14_13] (shouldn't be in output)
                        }
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        Disposer.dispose((Disposable)measurer);
                        file2.popAnnotationSession();
                        OCSourceGliderService.getInstance().clearVisitorRunners();
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return;
                    }
                }
                finally {
                    Disposer.dispose((Disposable)measurer);
                }
                {
                    OCContextSensitiveControlFlowBuilder flowBuilder;
                    ManagerInstancesProvider provider2;
                    if (((Result)contextSensitiveResult.get()).isFinishedSuccessfully()) {
                        provider2 = ((Result)contextSensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextSensitiveResult.get()).getFlowBuilder();
                    } else if (((Result)contextInsensitiveResult.get()).isFinishedSuccessfully()) {
                        provider2 = ((Result)contextInsensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextInsensitiveResult.get()).getFlowBuilder();
                        this.reportTimeOverWarning(problemsHolder, file2, "File is too complex to perform context-sensitive data-flow analysis");
                    } else {
                        this.reportTimeOverWarning(problemsHolder, file2, "File is too complex to perform data-flow analysis");
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return;
                    }
                    HashSet<PsiElement> elements = new HashSet<PsiElement>();
                    OCDFAInspectionRunner.getElements(elements, provider2, file2, "AlwaysTrueStatement");
                    OCDFAInspectionRunner.getElements(elements, provider2, file2, "AlwaysFalseStatement");
                    OCDFAInspectionRunner.getElements(elements, provider2, file2, "AlwaysTrueWhenReachedStatement");
                    OCDFAInspectionRunner.getElements(elements, provider2, file2, "AlwaysFalseWhenReachedStatement");
                    Set<PsiElement> parents = OCDFAInspectionRunner.getParents(elements);
                    this.registerWarnings(problemsHolder, provider2, file2, parents, OCInspections.ConstantConditionsOC.class, "AlwaysTrueStatement", "Condition is always true", OCDFAInspectionRunner.getSimplifyFixes(file2, true));
                    this.registerWarnings(problemsHolder, provider2, file2, parents, OCInspections.ConstantConditionsOC.class, "AlwaysFalseStatement", "Condition is always false", OCDFAInspectionRunner.getSimplifyFixes(file2, false));
                    this.registerWarnings(problemsHolder, provider2, file2, parents, OCInspections.ConstantConditionsOC.class, "AlwaysTrueWhenReachedStatement", "Condition is always true when reached", OCDFAInspectionRunner.getSimplifyFixes(file2, true));
                    this.registerWarnings(problemsHolder, provider2, file2, parents, OCInspections.ConstantConditionsOC.class, "AlwaysFalseWhenReachedStatement", "Condition is always false when reached", OCDFAInspectionRunner.getSimplifyFixes(file2, false));
                    this.registerWarnings(problemsHolder, provider2, file2, null, OCDFAInspection.class, "IllegalCastExpression", "Casting to probably incompatible type", null);
                    this.registerWarnings(problemsHolder, provider2, file2, null, OCInspections.NullDereferences.class, "NullDereference", "Reference may be " + (file2.getKind().isObjC() ? "nil" : "null"), OCDFAInspectionRunner.getInitializeFix(flowBuilder));
                    this.registerWarnings(problemsHolder, provider2, file2, null, OCDFAInspection.class, "NullReceiver", "Receiver is always " + (file2.getKind().isObjC() ? "nil" : "null"), OCDFAInspectionRunner.getInitializeFix(flowBuilder));
                    this.registerWarnings(problemsHolder, provider2, file2, null, OCDFAInspection.class, "NoResponder", "Statement may fail with \"unrecognized selector\"", null);
                    if (file2.getProject().getUserData(OCFile.DFA_UNREACHABLE_CODE) != Boolean.FALSE) {
                        this.registerUnreachableWarnings(problemsHolder, provider2, file2, flowBuilder, "UnreachableNode", "Unreachable code");
                    }
                    if (ENABLE_BDD_PROFILING.booleanValue()) {
                        provider2.getUIInstancesProvider().getConsoleCommandProcessor().run(8, new String[0], null);
                    }
                    if (ENABLE_RELATIONS_PROFILING.booleanValue()) {
                        provider2.getUIInstancesProvider().getConsoleCommandProcessor().run(9, new String[0], null);
                    }
                }
            }
            finally {
                file2.popAnnotationSession();
                OCSourceGliderService.getInstance().clearVisitorRunners();
            }
            {
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
            return;
        }
    }

    private static void runAnalysisInParallel(PsiElement root, Map<Object, Object> options2, boolean contextSensitive, OCDFAUtils.WorkingTimeMeasurer measurer, Ref<Result> result2) {
        PsiFile file2 = root.getContainingFile();
        OCSourceGliderService sourceGliderComponent = OCSourceGliderService.getInstance();
        ManagerInstancesProvider provider2 = sourceGliderComponent.getProvider(true, contextSensitive);
        final Ref flowBuilder = Ref.create();
        sourceGliderComponent.addVisitorRunner(true, contextSensitive, (options1, threadCallback) -> {
            flowBuilder.set((Object)new OCContextSensitiveControlFlowBuilder(provider2.getSymbolTable(), (signature, attributes) -> sourceGliderComponent.getVisitor(true, contextSensitive).addTuple(signature, attributes)));
            root.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitCallable(OCCallable callable) {
                    ((OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get())).processCallable(callable, options1, threadCallback);
                }
            });
        });
        provider2.init();
        options2.put("CONTEXT_SENSITIVITY", contextSensitive);
        List<Task> plan = provider2.getHypoteticRepository().getRelationBuildPlan("AlwaysTrueStatement", options2);
        if (plan != null) {
            for (Task task2 : plan) {
                if (task2.getName().startsWith("Running")) {
                    ProgressIndicator indicator = OCDFAInspectionRunner.createIndicator();
                    Runnable runnable = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                        boolean success = false;
                        try {
                            success = OCDFAInspectionRunner.runTask(file2, measurer, contextSensitive, task2);
                            if (contextSensitive) {
                                OCDFAInspection.printRelationsToLog(provider2);
                            }
                        }
                        finally {
                            Class<Result> clazz = Result.class;
                            synchronized (Result.class) {
                                result2.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)((Object)((Object)flowBuilder.get()))), success));
                                Result.class.notifyAll();
                                // ** MonitorExit[var8_8] (shouldn't be in output)
                            }
                        }
                    }, indicator);
                    if (contextSensitive) {
                        ApplicationManager.getApplication().executeOnPooledThread(runnable);
                    } else {
                        runnable.run();
                    }
                    return;
                }
                if (OCDFAInspectionRunner.runTask(file2, measurer, contextSensitive, task2)) continue;
                result2.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
                return;
            }
        }
        result2.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    private static boolean runTask(PsiFile file2, final OCDFAUtils.WorkingTimeMeasurer measurer, final boolean contextSensitive, Task task2) {
        try {
            task2.run(new DummyThreadCallback(){

                @Override
                public boolean checkCancelled() {
                    ProgressManager.checkCanceled();
                    if (measurer.isTimeOver()) {
                        throw new OCDFAUtils.DFAException("DFA time is over" + (contextSensitive ? " (context-sensitive)" : ""));
                    }
                    return false;
                }
            });
        }
        catch (BDDMemoryOverflowException e) {
            OCLog.LOG.warn(file2.getName() + ": " + e.getMessage());
            return false;
        }
        catch (OCDFAUtils.DFAException e) {
            String message = file2.getName() + ": " + e.getMessage();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isInternal()) {
                OCLog.LOG.warn(message);
            } else {
                OCLog.LOG.info(message);
            }
            return false;
        }
        return true;
    }

    private void reportTimeOverWarning(ProblemsHolder problemsHolder, OCFile file2, String message) {
        final Ref elementRef = new Ref();
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            @Override
            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), (PsiElement)elementRef.get(), message, "CIDR", ProblemHighlightType.WEAK_WARNING, OCDFAInspection.class, new IntentionAction[0]);
        }
    }

    private void registerWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file2, @Nullable Set<PsiElement> excludeElements, Class<? extends OCInspection> inspection, String relationName, String message, @Nullable ElementFix fixes) {
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        if (!OCDFAInspectionRunner.getElements(elements, provider2, file2, relationName)) {
            return;
        }
        if (excludeElements != null) {
            elements.removeAll(excludeElements);
        }
        for (PsiElement element : elements) {
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(element) : Collections.emptyList();
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), element, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, inspection, fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static boolean getElements(Set<PsiElement> elements, ManagerInstancesProvider provider2, PsiFile file2, String relationName) {
        if (!provider2.getRelationsRepository().containsRelation(relationName)) {
            return false;
        }
        IRelation relation = provider2.getRelationsRepository().getRelation(relationName);
        for (Attribute[] attributes : relation.getAttributes(provider2.getSymbolTable())) {
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCElement element = OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCElement.class, true);
            if (element == null) continue;
            elements.add(element);
        }
        return true;
    }

    private static Set<PsiElement> getParents(Set<PsiElement> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (PsiElement element : elements) {
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        return parents;
    }

    private void registerUnreachableWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file2, OCContextSensitiveControlFlowBuilder flowBuilder, String relationName, String message) {
        if (!provider2.getRelationsRepository().containsRelation(relationName)) {
            return;
        }
        IRelation relation = provider2.getRelationsRepository().getRelation(relationName);
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        for (OCControlFlowGraph graph : flowBuilder.getAllControlFlowGraphs()) {
            OCUnreachableCodeFinder finder = new OCUnreachableCodeFinder(graph);
            finder.process();
            ranges.addAll(finder.getUnreachableRanges(false));
        }
        for (Attribute[] attributes : relation.getAttributes(provider2.getSymbolTable())) {
            OCElementsRange range;
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCCallable callable = OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCCallable.class, true);
            if (callable == null || (range = flowBuilder.getRange(callable, Integer.decode(attributes[1].getKey()))) == null) continue;
            ranges.add(range);
        }
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges, true)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = endElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            OCInspection.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), range, message, "CIDR", ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCInspections.UnreachableCode.class, new IntentionAction[0]);
        }
    }

    private static ElementFix getSimplifyFixes(final OCFile file2, final boolean constantCondition) {
        return new ElementFix(){

            public List<IntentionAction> getFixes(@NotNull PsiElement element) {
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                String constant = OCIntType.getAppropriateBool(file2).getValue(constantCondition, OCResolveContext.forPsi(element));
                OCExpression newElement = OCElementFactory.expressionFromText(constant, element, false);
                fixes.add(new OCChangeElementIntentionAction(element, (PsiElement)newElement, "Simplify condition to '" + constant + "'"));
                OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class});
                OCElement simplified = null;
                if (parent instanceof OCStatement) {
                    simplified = SimplifyInspectionKt.simplifyStatementWithConstCondition(constantCondition, (OCStatement)parent);
                } else if (parent instanceof OCBinaryExpression) {
                    simplified = OCSimplifyInspectionLegacy.simplifyLogicExpression(constantCondition, (OCBinaryExpression)parent, element);
                }
                if (simplified != null && SimplifyInspectionKt.isSafeToSimplify(parent, simplified)) {
                    fixes.add(SimplifyInspectionKt.getSimplifyFix(parent, simplified));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getInitializeFix(final OCContextSensitiveControlFlowBuilder flowBuilder) {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                OCSymbol symbol;
                OCSymbol oCSymbol = symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
                if (symbol != null) {
                    OCControlFlowGraph graph;
                    OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
                    OCControlFlowGraph oCControlFlowGraph = graph = callable != null ? flowBuilder.getControlFlowGraph(callable) : null;
                    if (graph != null) {
                        OCInstruction instruction;
                        OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph, symbol, element.getParent(), false, true, true);
                        defSearcher.process();
                        Collection<OCInstruction> declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                        if (!declarators.isEmpty() && (instruction = declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                            return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                        }
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    private static interface ElementFix {
        public List<? extends IntentionAction> getFixes(PsiElement var1);
    }

    private static class Result {
        private ManagerInstancesProvider myProvider;
        private OCContextSensitiveControlFlowBuilder myFlowBuilder;
        private boolean myFinishedSuccessfully;

        Result(ManagerInstancesProvider myProvider, OCContextSensitiveControlFlowBuilder flowBuilder, boolean finishedSuccessfully) {
            this.myProvider = myProvider;
            this.myFlowBuilder = flowBuilder;
            this.myFinishedSuccessfully = finishedSuccessfully;
        }

        public ManagerInstancesProvider getProvider() {
            return this.myProvider;
        }

        public OCContextSensitiveControlFlowBuilder getFlowBuilder() {
            return this.myFlowBuilder;
        }

        public boolean isFinishedSuccessfully() {
            return this.myFinishedSuccessfully;
        }
    }
}

