/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCFlipComparisonIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCBinaryExpression binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            OCElementType operator = binaryExpression.getOperationSign();
            OCElementType flippedOperator = OCCodeInsightUtil.getFlippedOperator(operator);
            if (flippedOperator != null) {
                if (binaryExpression.getRight() == null) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getLeft())) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getRight())) {
                    return false;
                }
                String operatorText = binaryExpression.getOperationSignNode().getText();
                String flippedOperatorText = flippedOperator.getName();
                if (flippedOperatorText.equals(operatorText)) {
                    this.setText(OCBundle.message("intentions.flip.operator", operatorText));
                } else {
                    this.setText(OCBundle.message("intentions.flip.operator.to", operatorText, flippedOperatorText));
                }
                return true;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.flip.binary.operation", new Object[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCBinaryExpression binaryExpression = OCElementUtil.getAdjacentParentOfType(element, OCBinaryExpression.class);
        while (binaryExpression != null) {
            OCElementType sign = binaryExpression.getOperationSign();
            OCElementType flippedOperator = OCCodeInsightUtil.getFlippedOperator(sign);
            if (flippedOperator != null) {
                OCExpression right = binaryExpression.getRight();
                if (right == null) {
                    return;
                }
                String newSign = flippedOperator.getName();
                OCBinaryExpression newBinaryExpression = (OCBinaryExpression)OCElementFactory.expressionFromText("1" + newSign + "2", element);
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getLeft(), binaryExpression.getRight());
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getRight(), binaryExpression.getLeft());
                OCChangeUtil.replaceHandlingMacros(binaryExpression, newBinaryExpression);
                return;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
    }
}

