/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnusedIncludeDirectiveInspection
extends OCUnusedCppInspection {
    @NotNull
    public static final String CLANG_DIAG_ID = "clion_unused_include";
    private static final Logger LOG = Logger.getInstance((String)OCUnusedIncludeDirectiveInspection.class.getName());
    @NotNull
    public EliminateStrategy strategy = EliminateStrategy.RemoveNotDirectlyUsed;
    public boolean showInHeaders = false;

    @Override
    public boolean isEnabledByDefault() {
        return PlatformUtils.isCLion();
    }

    @Override
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String getStaticDescription() {
        return OCInspectionUtil.getStaticDescription(this);
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!OCInspectionUtil.isInspectionEnabled(holder.getFile(), this.getInspectionClass())) {
            return new OCVisitor();
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file2) {
                if (isOnTheFly) {
                    return;
                }
                if (!ClangUtils.isClangdOn(file2.getProject())) {
                    return;
                }
                if (!OCLanguageUtils.isSupported(file2)) {
                    return;
                }
                List unusedDiagnostics = OCUnusedIncludeDirectiveInspection.getUnusedDiagnostics(file2);
                if (!unusedDiagnostics.isEmpty()) {
                    Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
                    if (document2 == null) {
                        return;
                    }
                    HighlightInfoHolder highlightInfos = new HighlightInfoHolder(file2, new HighlightInfoFilter[0]);
                    for (ClangDiagnostic diag : unusedDiagnostics) {
                        HighlightInfo info = ClangErrorsAnnotatorPass.makeAnnotation(diag, file2, document2, highlightInfos);
                        ProblemDescriptor descriptor = info == null ? null : ProblemDescriptorUtil.toProblemDescriptor((PsiFile)file2, (HighlightInfo)info);
                        if (descriptor == null) continue;
                        OCInspection.registerProblem(holder, null, null, isOnTheFly, descriptor.getStartElement(), descriptor.getEndElement(), info.getDescription(), "CIDR", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(info.startOffset, info.endOffset), OCUnusedIncludeDirectiveInspection.this.getInspectionClass(), IntentionAction.EMPTY_ARRAY);
                    }
                }
            }
        };
    }

    @NotNull
    private static List<ClangDiagnostic> getUnusedDiagnostics(@NotNull PsiFile file2) {
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(file2.getProject());
        VirtualFile virtualFile = file2.getViewProvider().getVirtualFile();
        return service.computeWithOpenedAndParsed(virtualFile, response -> {
            if (response != null) {
                try {
                    Supplier<List<ClangDiagnostic>> diagsSupplier = ClangUtils.waitCancelAware(response.getDiagnostics(), Long.MAX_VALUE, "unused include diagnostics");
                    if (diagsSupplier != null) {
                        List<ClangDiagnostic> diagnostics2 = diagsSupplier.get();
                        return diagnostics2 != null ? ContainerUtil.filter(diagnostics2, diag -> CLANG_DIAG_ID.equals(diag.getCode())) : Collections.emptyList();
                    }
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error((Throwable)e);
                }
            }
            return Collections.emptyList();
        });
    }

    @Override
    public JComponent createOptionsPanel() {
        if (!PlatformUtils.isCLion()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        final ComboBox comboBox = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)ContainerUtil.map((Object[])EliminateStrategy.values(), opt -> opt.option)));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OCUnusedIncludeDirectiveInspection.this.strategy = EliminateStrategy.values()[comboBox.getSelectedIndex()];
            }
        });
        comboBox.setSelectedIndex(EliminateStrategy.indexOf(this.strategy));
        panel2.add((Component)comboBox, bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        panel2.add((Component)new CheckBox(OCInspectionsBundle.message("unused.inspection.run.in.headers", new Object[0]), (InspectionProfileEntry)this, "showInHeaders"), bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        return panel2;
    }

    public static enum EliminateStrategy {
        RemoveCompletelyUnused("Detect completely unused"),
        RemoveNotDirectlyUsed("Detect not directly used"),
        RemoveNotRequired("Detect not required");

        @NotNull
        public final String option;

        private EliminateStrategy(String option) {
            this.option = option;
        }

        static int indexOf(@NotNull EliminateStrategy opt) {
            int index = 0;
            for (EliminateStrategy strategy2 : EliminateStrategy.values()) {
                if (strategy2 == opt) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

