/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionQuickFix;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class NotImplementedFunctions
extends OCInspections.Functions {
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public boolean worksWithClangd() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!OCSearchScope.isInProjectSources((PsiElement)holder.getFile())) {
            return super.buildVisitor(holder, isOnTheFly);
        }
        return new OCVisitor(){

            @Override
            public void visitFunctionDeclaration(@NotNull OCFunctionDeclaration function) {
                if (function instanceof OCFunctionDefinition) {
                    return;
                }
                if (!function.isPossibleStructMember()) {
                    return;
                }
                OCDeclarator declarator = function.getDeclarator();
                if (declarator != null && declarator.getInitializer() != null) {
                    return;
                }
                OCFunctionSymbol symbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)function.getSymbol(), OCFunctionSymbol.class);
                if (symbol != null && symbol.isPredeclaration() && !symbol.isDefault() && !symbol.isDelete() && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true, holder.getProject()) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.REQUIRED) {
                    OCCompilationContext compilationContext = OCCompilationContext.create(function);
                    OCInspection.registerProblem(holder, null, null, isOnTheFly, function.getHeaderRange(), symbol.getNameWithKindUppercase(compilationContext) + " is not implemented", "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NotImplementedFunctions.class, new OCGenerateDefinitionQuickFix(symbol, true, compilationContext), new OCGenerateDefinitionQuickFix(symbol, false, compilationContext), new OCMakeFunctionVirtualFix(symbol, true, holder.getProject()));
                }
            }
        };
    }
}

