/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateInitWithHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    private static final OCBooleanOption RETAIN_OBJECTS = new OCBooleanOption("Retain object parameters");
    private static final OCBooleanOption USE_SETTERS = new OCBooleanOption("Use property setters");
    private static final OCBooleanOption GENERATE_CLASS_CONSTRUCTOR = new OCBooleanOption("Generate \"+objectWith...\"");

    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate -initWith";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members to be Initialized";
    }

    protected boolean defaultRetainObjects(@Nullable OCCodeStyleSettings settings) {
        return settings == null || settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
    }

    protected boolean defaultUseSetters(@Nullable OCCodeStyleSettings settings) {
        return settings != null && settings.USE_SETTERS_IN_CONSTRUCTOR;
    }

    protected boolean defaultGenerateClassConstructor(@Nullable OCCodeStyleSettings settings) {
        return settings != null && settings.GENERATE_CLASS_CONSTRUCTOR;
    }

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options2) {
        if (OCCompilerFeaturesHelper.isArcDisabled(file2)) {
            options2.add((Pair<OCOption, Object>)new Pair((Object)RETAIN_OBJECTS, (Object)this.defaultRetainObjects(settings)));
        }
        options2.add((Pair<OCOption, Object>)new Pair((Object)USE_SETTERS, (Object)this.defaultUseSetters(settings)));
        options2.add((Pair<OCOption, Object>)new Pair((Object)GENERATE_CLASS_CONSTRUCTOR, (Object)this.defaultGenerateClassConstructor(settings)));
        super.loadOptions(file2, editor, actionContext, settings, options2);
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (OCCompilerFeaturesHelper.isArcDisabled(file2)) {
            settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, RETAIN_OBJECTS);
        }
        settings.USE_SETTERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, USE_SETTERS);
        settings.GENERATE_CLASS_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, GENERATE_CLASS_CONSTRUCTOR);
        super.saveOptions(file2, settings, optionValues);
    }

    private static boolean useInstanceType(PsiFile file2) {
        return OCCompilerFeaturesHelper.supportsInstancetype(file2);
    }

    @Override
    @NotNull
    protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCObjectType type = parent.getResolvedType(OCResolveContext.forPsi(element), true);
        if (type != null) {
            type.processMembers("init", OCMethodSymbol.class, finder);
        }
        return new OCGenerateMethodActionContext(parent, Collections.singletonList(finder.getFoundValue()), type, element);
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateMethodActionContext context2, @NotNull List<OCInstanceVariableSymbol> ivars) {
        if (!ivars.isEmpty()) {
            OCClassSymbol classSymbol = ivars.get(0).getParent();
            StringBuilder signature = new StringBuilder();
            OCMethod method = OCElementFactory.methodFromSignature(OCGenerateInitWithHandler.getMethodSignature(context2.getBaseMethod(), ivars, this.getOption(context2, USE_SETTERS), file2), (PsiElement)file2, false, false);
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)method, classSymbol.getContainingOCFile(project2));
            handler.setChangeUsages(false);
            handler.getGeneratedInfo().setMethodParent(classSymbol);
            handler.getGeneratedInfo().runOnSuccess(() -> signature.append(handler.getNewSignature(false)));
            handler.setTitle(this.getActionTitle());
            handler.setRefactorButtonText("Generate");
            handler.invoke();
            context2.setMethodSignature(signature.length() > 0 ? signature.toString() : null);
            context2.setParameters(handler.getParameters());
        }
        super.performAction(project2, editor, file2, context2, ivars);
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context2) {
        return true;
    }

    private static String getMethodSignature(OCMethodSymbol baseMethod, List<OCInstanceVariableSymbol> ivars, boolean useSetters, @NotNull PsiFile file2) {
        StringBuilder signature = new StringBuilder();
        signature.append(baseMethod.isStatic() ? (char)'+' : '-');
        Project project2 = file2.getProject();
        if (OCGenerateInitWithHandler.useInstanceType(file2)) {
            signature.append("(instancetype)");
        } else {
            signature.append('(').append(baseMethod.getReturnType(project2).getBestNameInContext((PsiElement)file2)).append(')');
        }
        boolean first = true;
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(project2);
            if (property != null && property.isReadonly()) {
                property = property.getAssociatedPropertyInPrivateCategory(project2);
            }
            if (first) {
                signature.append("initWith").append(StringUtil.capitalize((String)OCNameSuggester.getNonCollidingName(ivar, true, project2)));
            } else {
                signature.append(' ').append(OCNameSuggester.getNonCollidingName(ivar, true, project2));
            }
            first = false;
            boolean useProperty = useSetters && property != null && !property.isReadonly();
            signature.append(":(").append(ivar.getType().getBestNameInContext((PsiElement)file2)).append(')').append(OCNameSuggester.getNonCollidingName(ivar, useProperty, project2));
        }
        return signature.toString();
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext context2) {
        String methodSignature = context2.getMethodSignature();
        if (ivars.isEmpty()) {
            if (element instanceof OCImplementation) {
                return OCCallableUtil.methodText(context2.getBaseMethod(), null, element);
            }
            return "";
        }
        if (methodSignature != null) {
            boolean useSetters = this.getOption(context2, USE_SETTERS);
            boolean retainObjects = OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile()) && this.getOption(context2, RETAIN_OBJECTS) != false;
            boolean generateClassConstructor = this.getOption(context2, GENERATE_CLASS_CONSTRUCTOR);
            String objectSignature = OCGenerateInitWithHandler.getObjectMethodSignature(methodSignature, true, context2.getType(), OCResolveContext.forPsi(element));
            if (element instanceof OCImplementation) {
                PsiFile file2 = element.getContainingFile();
                String initializerText = OCGenerateInitWithHandler.getInitializerText(ivars, context2.getParameters(), 0, file2, useSetters, retainObjects, context2.getNonReleasedIvars());
                StringBuilder result2 = new StringBuilder();
                result2.append(OCCallableUtil.methodWithSignature(context2.getBaseMethod(), methodSignature, initializerText, element));
                if (generateClassConstructor && objectSignature != null) {
                    String callText = OCGenerateInitWithHandler.getClassConstructorText((OCImplementation)element, context2);
                    result2.append(OCCallableUtil.methodText(objectSignature, callText, element));
                }
                return result2.toString();
            }
            StringBuilder result3 = new StringBuilder();
            result3.append(methodSignature).append(";\n");
            if (generateClassConstructor && objectSignature != null) {
                result3.append(objectSignature).append(";\n");
            }
            return result3.toString();
        }
        return "";
    }

    @Nullable
    public static String getObjectMethodSignature(String methodSignature, boolean appendReturnType, OCObjectType type, @NotNull OCResolveContext context2) {
        String prefixName;
        int pos = methodSignature.indexOf("initWith");
        pos = pos != -1 ? pos + "initWith".length() : methodSignature.indexOf(58);
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)type, null, "", context2);
        String string = prefixName = suggestions.isEmpty() ? "object" : suggestions.iterator().next();
        String returnType = appendReturnType ? (OCGenerateInitWithHandler.useInstanceType(context2.getFile()) ? "+(instancetype)" : "+(id)") : "";
        String objectSignature = pos != -1 ? returnType + prefixName + "With" + methodSignature.substring(pos) : null;
        return objectSignature;
    }

    private static String getClassConstructorText(OCImplementation element, OCGenerateMethodActionContext context2) {
        StringBuilder text = new StringBuilder("return ");
        if (OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile())) {
            text.append("[");
        }
        text.append("[[self alloc] ");
        for (OCParameterInfo param : context2.getParameters()) {
            text.append(param.getSelector()).append(":").append(param.getName()).append(' ');
        }
        if (OCCompilerFeaturesHelper.isArcDisabled(element.getContainingFile())) {
            text.append("] autorelease");
        }
        text.append("];");
        return text.toString();
    }

    public static String getInitializerText(List<OCInstanceVariableSymbol> ivars, List<OCParameterInfo> parameters, int atIndex, @NotNull PsiFile implementationFile, boolean useSetters, boolean retainObjects, List<OCInstanceVariableSymbol> nonReleasedIvars) {
        StringBuilder initialization = new StringBuilder();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(implementationFile);
        OCResolveContext context2 = OCResolveContext.forPsi((PsiElement)implementationFile);
        for (OCParameterInfo parameter : parameters) {
            int index = parameter.getOldIndex() - atIndex;
            if (index < 0 || index >= ivars.size()) continue;
            OCInstanceVariableSymbol ivar = ivars.get(index);
            Project project2 = implementationFile.getProject();
            OCPropertySymbol property = ivar.getAssociatedProperty(project2);
            OCType type = ivar.getResolvedType(context2);
            if (property != null && property.isReadonly()) {
                OCPropertySymbol associatedProperty = property.getAssociatedPropertyInPrivateCategory(project2);
                OCPropertySymbol oCPropertySymbol = property = associatedProperty != null ? associatedProperty : property;
            }
            if (initialization.length() > 0) {
                initialization.append("\n");
            }
            if (useSetters && property != null && !property.isReadonly()) {
                initialization.append("self.").append(property.getName()).append('=');
                initialization.append(parameter.getName()).append(";");
                continue;
            }
            if (retainObjects && type.isPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcDisabled(implementationFile)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName());
                if (type.isPointerToString()) {
                    initialization.append(" copy];");
                } else {
                    initialization.append(" retain];");
                }
                if (!OCCompilerFeaturesHelper.isArcDisabled(implementationFile) || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, implementationFile, ivarsInfo)) continue;
                nonReleasedIvars.add(ivar);
                continue;
            }
            if (property != null && property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName()).append(" copy];");
                continue;
            }
            initialization.append(ivar.getName()).append('=');
            initialization.append(parameter.getName()).append(";");
        }
        return initialization.toString();
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull PsiElement element, int caretPos, PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context2) {
        super.performAction(project2, element, caretPos, at, members, context2);
        if (element instanceof OCImplementation && !context2.getNonReleasedIvars().isEmpty()) {
            new OCReleaseVariablesIntentionAction(context2.getNonReleasedIvars(), context2.getProject()).invoke(project2, null, element.getContainingFile());
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (member.getParent().isSameCategory(context2.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, member.getParent(), false).fixBestItem(project2, element.getContainingFile());
            }
        }
    }

    @Override
    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> ivars, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InitMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }
}

