/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCExpressionSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import org.jetbrains.annotations.NotNull;

class OCaWithCastSurrounder
extends OCExpressionSurrounder {
    OCaWithCastSurrounder() {
    }

    @Override
    public boolean isApplicable(OCExpression expr) {
        return !expr.getResolvedType().isVoid();
    }

    @Override
    public TextRange surroundExpression(@NotNull Project project2, @NotNull Editor editor, @NotNull OCExpression expr) throws IncorrectOperationException {
        assert (expr.isValid());
        Template template = OCaWithCastSurrounder.generateTemplate(project2, expr);
        TextRange range = expr.getRangeWithMacros();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance((Project)project2).startTemplate(editor, template);
        return null;
    }

    private static Template generateTemplate(Project project2, OCExpression expression) {
        String exprText = expression.getTextWithMacros();
        TemplateManager templateManager = TemplateManager.getInstance((Project)project2);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("((");
        int refCount = 0;
        String typeName = expression.getResolvedType().getGuessedType().getCanonicalName(OCResolveContext.forPsi(expression));
        while (typeName.endsWith("*")) {
            ++refCount;
            typeName = typeName.substring(0, typeName.length() - 1).trim();
        }
        template.addVariable("type", (Expression)new ConstantNode(typeName), true);
        StringBuilder builder2 = new StringBuilder();
        while (refCount > 0) {
            builder2.append('*');
            --refCount;
        }
        builder2.append(")").append(exprText).append(")");
        template.addTextSegment(builder2.toString());
        template.addEndVariable();
        return template;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.cast.template", (Object[])new Object[0]);
    }
}

