/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCIfElseSurrounder
extends OCStatementSurrounder<OCIfStatement> {
    @Override
    protected String getStatementTemplate(Project project2, PsiElement context2) {
        return "if (a) {\n} else {\n}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCIfStatement statement2) {
        return statement2.getThenBranch();
    }

    @Override
    protected TextRange getSelectionRange(OCIfStatement statement2) {
        OCCondition condition = statement2.getCondition();
        int offset = condition.getRangeWithMacros().getStartOffset();
        OCChangeUtil.delete(condition);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "if / else";
    }
}

