/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCCondCompilationSurrounder
extends OCSurrounder {
    public String getTemplateDescription() {
        return "#ifdef";
    }

    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        int startOffset = elements[0].getTextRange().getStartOffset();
        int endOffset = elements[elements.length - 1].getTextRange().getEndOffset();
        PsiFile file2 = elements[0].getContainingFile();
        Document document2 = editor.getDocument();
        CharSequence chars = document2.getCharsSequence();
        startOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t") + 1;
        boolean needNewLineAfterEndIf = endOffset < chars.length() && chars.charAt(endOffset) != '\n';
        String endTag = needNewLineAfterEndIf ? "\n#endif\n" : "\n#endif";
        document2.insertString(endOffset, (CharSequence)endTag);
        RangeMarker endif = document2.createRangeMarker(TextRange.create((int)endOffset, (int)(endOffset + endTag.length())));
        RangeMarker afterEndif = null;
        if (needNewLineAfterEndIf) {
            int afterEndTag = endOffset + endTag.length();
            afterEndif = document2.createRangeMarker(TextRange.create((int)afterEndTag, (int)afterEndTag));
        }
        boolean needNewLineBeforeIfDef = startOffset > 0 && chars.charAt(startOffset - 1) != '\n';
        String startTag = needNewLineBeforeIfDef ? "\n#ifdef\n" : "#ifdef\n";
        document2.insertString(startOffset, (CharSequence)startTag);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        int caretOffset = startOffset + startTag.length() - 1;
        RangeMarker caret = document2.createRangeMarker(TextRange.create((int)caretOffset, (int)caretOffset));
        OCChangeUtil.reformatTextIfNotInjected(file2, startOffset, startOffset + startTag.length());
        OCChangeUtil.reformatTextIfNotInjected(file2, endif.getStartOffset(), endif.getEndOffset());
        endif.dispose();
        if (afterEndif != null) {
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(document2, afterEndif.getStartOffset());
            endif.dispose();
        }
        caretOffset = caret.getStartOffset();
        caret.dispose();
        document2.insertString(caretOffset, (CharSequence)" ");
        return TextRange.create((int)(++caretOffset), (int)caretOffset);
    }
}

