/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.PlainTextLineSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCSelectorWordSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return OCSelectorWordSelectioner.isCustomSelectionContext(e);
    }

    public static boolean isCustomSelectionContext(PsiElement e) {
        IElementType type = OCElementUtil.getElementType(e);
        return OCSelectorWordSelectioner.selector(e) != null || type == OCTokenTypes.HEADER_PATH_LITERAL || type == OCTokenTypes.EOL_ESCAPE || type == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT || OCSelectorWordSelectioner.isDirective(e);
    }

    private static boolean isDirective(PsiElement e) {
        return OCElementTypes.DIRECTIVES.contains(OCElementUtil.getElementType(e));
    }

    @Contract(value="null -> null")
    private static OCSelectorExpression selector(PsiElement e) {
        return (OCSelectorExpression)PsiTreeUtil.getParentOfType((PsiElement)e, OCSelectorExpression.class);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        OCSelectorExpression selector = OCSelectorWordSelectioner.selector(e);
        if (selector != null) {
            return Collections.singletonList(selector.getSelectorRange().shiftRight(selector.getTextRange().getStartOffset()));
        }
        if (OCElementUtil.getElementType(e) == OCTokenTypes.HEADER_PATH_LITERAL) {
            String text = e.getText();
            int nonws = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            text = text.substring(nonws);
            ArrayList<TextRange> answer = new ArrayList<TextRange>();
            TextRange baseRange = TextRange.from((int)(e.getTextRange().getStartOffset() + nonws), (int)(e.getTextLength() - nonws));
            answer.add(baseRange);
            SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, answer);
            if (baseRange.getLength() > 1 && text.startsWith("\"") && text.endsWith("\"") || text.startsWith("<") && text.endsWith(">")) {
                answer.add(baseRange.shiftRight(1).grown(-2));
            }
            return answer;
        }
        if (OCSelectorWordSelectioner.isDirective(e)) {
            PsiElement directive = e;
            PsiElement directiveId = null;
            OCMacroParameterList directiveParams = null;
            if (directive instanceof PsiNameIdentifierOwner) {
                directiveId = ((PsiNameIdentifierOwner)directive).getNameIdentifier();
            }
            if (directive instanceof OCDefineDirective) {
                directiveParams = ((OCDefineDirective)directive).getMacroParameters();
            }
            TextRange directiveRange = directive.getTextRange();
            List<TextRange> ranges = OCElementUtil.getElementType(e) != OCElementTypes.DEFINED_DIRECTIVE ? OCSelectorWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)directiveRange, (boolean)false) : new ArrayList();
            int start = directiveRange.getStartOffset();
            int end = CharArrayUtil.shiftForward((CharSequence)editorText, (int)directiveRange.getEndOffset(), (String)" \t");
            ranges.add(TextRange.create((int)start, (int)end));
            if (directiveId != null) {
                int startId = directiveId.getTextRange().getStartOffset();
                ranges.add(TextRange.create((int)startId, (int)directiveId.getTextRange().getEndOffset()));
                ranges.add(TextRange.create((int)startId, (int)end));
                if (directiveParams != null) {
                    ranges.add(TextRange.create((int)startId, (int)directiveParams.getTextRange().getEndOffset()));
                    int paramEnd = CharArrayUtil.shiftForward((CharSequence)editorText, (int)directiveParams.getTextRange().getEndOffset(), (String)" \t");
                    ranges.add(TextRange.create((int)paramEnd, (int)end));
                }
            }
            SelectWordUtil.addWordOrLexemeSelection((boolean)editor.getSettings().isCamelWords(), (Editor)editor, (int)cursorOffset, ranges);
            return ranges;
        }
        if (OCElementUtil.getElementType(e) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            return PlainTextLineSelectioner.selectPlainTextLine((PsiElement)e, (CharSequence)editorText, (int)cursorOffset);
        }
        return Collections.emptyList();
    }
}

