/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    @Nullable
    private PsiElement myContextExpression;
    private String myInsertion;

    FunctionInsertHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
    }

    public static void changeQualifyingTokenIfNeeded(InsertionContext context2, PsiElement contextExpression, LookupElement item) {
        if (contextExpression instanceof OCQualifiedExpression) {
            OCUsageTriggerCollector.logEvent("completion.qualified");
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)contextExpression;
            OCPunctuatorElementType actualToken = qualifiedExpression.getQualifyingTokenKind();
            OCPunctuatorElementType completionToken = (OCPunctuatorElementType)((Object)OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.get((UserDataHolder)item));
            if (!qualifiedExpression.canChangeQualifyingToken() || completionToken == null || completionToken == actualToken) {
                return;
            }
            Document document2 = context2.getDocument();
            OCElement qualifyingElement = qualifiedExpression.getQualifyingElement();
            TextRange range = OCElementUtil.getUserVisibleRangeInDocument(qualifyingElement);
            if (range != null) {
                String from = actualToken == OCTokenTypes.DOT ? "dot" : "dereference";
                OCUsageTriggerCollector.logEvent("completion.change.qualifying.token", new FeatureUsageData().addData("from", from));
                document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)completionToken.getName());
                PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(document2);
            }
        }
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (FunctionInsertHandler.isUsedAsAName(this.mySymbol, this.myContextExpression)) {
            return;
        }
        boolean hasParams = !this.mySymbol.getParameterSymbols().isEmpty();
        boolean isCudaKernel = this.mySymbol.isCudaKernel();
        if (isCudaKernel) {
            CallableInsertUtils.addKernel(context2);
        }
        CallableInsertUtils.addParensIfRequired(context2, item, hasParams);
        if (hasParams && CallableInsertUtils.shouldInsertPlaceholders(context2)) {
            assert (this.myInsertion != null);
            context2.getDocument().insertString(context2.getEditor().getCaretModel().getOffset(), (CharSequence)this.myInsertion);
            CallableInsertUtils.selectFirstPlaceholderIfPresent(context2);
        }
        FunctionInsertHandler.changeQualifyingTokenIfNeeded(context2, this.myContextExpression, item);
        if (hasParams) {
            AutoPopupController.getInstance((Project)context2.getProject()).autoPopupParameterInfo(context2.getEditor(), null);
        }
        if (isCudaKernel) {
            context2.getEditor().getCaretModel().moveToOffset(context2.getTailOffset() - 5);
        }
    }

    public void calculateInsertion(@NotNull OCResolveContext context2) {
        StringBuilder insertion = new StringBuilder();
        List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
        int paramCount = params.size();
        if (params.isEmpty()) {
            return;
        }
        boolean mergeLast = this.mySymbol.isVararg() && params.get(paramCount - 1).isUnnamed();
        int varargIdx = mergeLast ? paramCount - 1 : Integer.MAX_VALUE;
        int firstTemplateStart = -1;
        int firstTemplateEnd = -1;
        for (int i2 = 0; i2 < paramCount; ++i2) {
            OCDeclaratorSymbol param = params.get(i2);
            OCType type = param.getType();
            if (type instanceof OCVoidType) continue;
            if (i2 > 0) {
                insertion.append(", ");
            }
            if (i2 == 0 || i2 < varargIdx) {
                if (firstTemplateStart == -1) {
                    firstTemplateStart = insertion.length();
                }
                insertion.append("<#");
            }
            if (i2 == varargIdx) {
                insertion.append("...");
            } else {
                insertion.append(param.getType().getBestNameInContext(context2));
                if (!param.isUnnamed()) {
                    insertion.append(' ');
                    insertion.append(param.getName());
                }
            }
            if (i2 == varargIdx - 1) continue;
            insertion.append("#>");
            if (firstTemplateEnd != -1) continue;
            firstTemplateEnd = insertion.length();
        }
        this.myInsertion = insertion.toString();
    }

    private static boolean isUsedAsAName(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement context2) {
        if (context2 != null) {
            PsiElement parent = context2.getParent();
            if (parent instanceof OCExpression) {
                PsiElement superParent = parent.getParent();
                if (superParent instanceof OCUnaryExpression) {
                    return ((OCUnaryExpression)superParent).isGetAddress();
                }
                OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
                Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes((OCExpression)parent, false, resolveContext);
                for (OCType type : types) {
                    OCFunctionType ft;
                    if (!((type = type.resolve(resolveContext)) instanceof OCPointerType) || !(((OCPointerType)type).getRefType() instanceof OCFunctionType) || (ft = (OCFunctionType)((OCPointerType)type).getRefType()).checkCompatible(symbol.getResolvedType(resolveContext), null, context2, resolveContext).getState() != OCTypeCheckState.OK) continue;
                    return true;
                }
            } else if (parent instanceof OCCppUsingStatement) {
                return true;
            }
        }
        return false;
    }
}

