/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FunctionDeclarationInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    private String myInsertion;

    FunctionDeclarationInsertHandler(@NotNull OCFunctionSymbol symbol) {
        this.mySymbol = symbol;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Project project2 = context2.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        CaretModel caretModel = context2.getEditor().getCaretModel();
        String defaultInsertion = item.getLookupString();
        int caretOffset = caretModel.getOffset() - defaultInsertion.length();
        Document document2 = context2.getDocument();
        String insertion = this.getInsertion(context2, item);
        document2.replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)insertion);
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project2);
        pdm.commitDocument(document2);
        OCDeclaration method = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
        boolean hasType = false;
        if (method != null) {
            OCTypeElement typeElement = method.getTypeElement();
            if (typeElement != null && !OCElementUtil.isElementEmpty(typeElement) && method.getDeclarators().size() == 1) {
                OCDeclarator declarator = method.getDeclarators().get(0);
                hasType = this.mySymbol.getName().equals(declarator.getName());
            }
            if (!hasType && !this.mySymbol.getKind().isConstructorOrDestructor()) {
                OCElement before2 = typeElement != null ? typeElement : method;
                String returnType = this.mySymbol.getEffectiveType(project2).getBestNameInContext(method, OCElementUtil.getReturnTypeTextWithModifiers(this.mySymbol, project2));
                document2.insertString(before2.getTextRange().getStartOffset(), (CharSequence)(returnType + " "));
            }
        }
        CallableInsertUtils.moveCaretToCallableBody(context2);
        if (context2.getCompletionChar() == '{') {
            context2.setAddCompletionChar(false);
        }
        OCChangeUtil.reformatTextIfNotInjected(context2.getFile(), context2.getStartOffset(), context2.getStartOffset() + insertion.length());
    }

    private String getInsertion(InsertionContext context2, LookupElement item) {
        boolean addEmptyBody = true;
        if (CallableInsertUtils.isReplaceCompletion(context2)) {
            CaretModel caretModel = context2.getEditor().getCaretModel();
            String defaultInsertion = item.getLookupString();
            int caretOffset = caretModel.getOffset() - defaultInsertion.length();
            OCDeclaration func = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
            if (func instanceof OCFunctionDefinition) {
                context2.setTailOffset(((OCFunctionDefinition)func).getBody().getTextRange().getStartOffset());
                addEmptyBody = false;
            }
            if (CallableInsertUtils.isReplaceCompletionBeforeParen(context2)) {
                return this.mySymbol.getName();
            }
        }
        assert (this.myInsertion != null);
        return addEmptyBody ? this.myInsertion + "{ }" : this.myInsertion;
    }

    public void calculateInsertion(@NotNull OCResolveContext context2) {
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.mySymbol.getName());
        insertion.append('(');
        if (!this.mySymbol.getType().hasNoParameters()) {
            List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
            for (int i2 = 0; i2 < params.size(); ++i2) {
                OCDeclaratorSymbol param = params.get(i2);
                OCType type = param.getType();
                if (i2 > 0) {
                    insertion.append(", ");
                }
                String name = !param.isUnnamed() ? param.getName() : "";
                insertion.append(type.getBestNameInContext(context2)).append(" ").append(name);
            }
        }
        insertion.append(')');
        if (this.mySymbol.getType().isConst()) {
            insertion.append(" const ");
        }
        if (this.mySymbol.getType().isVolatile()) {
            insertion.append(" volatile ");
        }
        this.myInsertion = insertion.toString();
    }
}

