/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.NextPrevParameterAction;
import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSmartCompletionInPlaceholderEnterHandler
extends BaseEnterHandler {
    private final EditorActionHandler myOriginalHandler;

    public OCSmartCompletionInPlaceholderEnterHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    public void executeWriteAction(final Editor editor, Caret caret, DataContext dataContext) {
        final PsiFile contextPsiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (contextPsiFile != null && this.isFileSupported(contextPsiFile)) {
            final Project project2 = contextPsiFile.getProject();
            if (OCSmartCompletionInPlaceholderEnterHandler.onTemplate(editor)) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true){

                            private void onDone() {
                                if (!OCSmartCompletionInPlaceholderEnterHandler.onTemplate(editor) && OCSmartCompletionInPlaceholderEnterHandler.hasMoreTemplates(editor)) {
                                    new NextPrevParameterAction.Next().getHandler().invoke(project2, editor, contextPsiFile);
                                }
                            }

                            protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
                                super.lookupItemSelected(indicator, item, completionChar, items);
                                if (item.getUserData(SymbolLookupBuilderUtil.DONT_GO_NEXT_TEMPLATE) != Boolean.TRUE) {
                                    this.onDone();
                                }
                            }

                            protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                                super.completionFinished(indicator, hasModifiers);
                                this.onDone();
                            }
                        };
                        base.invokeCompletion(project2, editor, 1, true);
                    }
                }, ModalityState.stateForComponent((Component)editor.getComponent()));
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    protected boolean isFileSupported(@NotNull PsiFile file2) {
        return file2 instanceof OCFile;
    }

    private static boolean hasMoreTemplates(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence text = editor.getDocument().getCharsSequence();
        return CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"<#", (int)offset) > 0;
    }

    private static boolean onTemplate(Editor editor) {
        String selection = editor.getSelectionModel().getSelectedText();
        return selection != null && selection.startsWith("<#") && selection.endsWith("#>");
    }
}

