/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayMapping {
    @NotNull
    private final Map<File, File> myMapping = new HashMap<File, File>();

    public void addOverlay(@NotNull File sourceFile, @NotNull File overlayFile) {
        this.myMapping.put(overlayFile, sourceFile);
    }

    public boolean hasOverlayFile(@NotNull File sourceFile) {
        return this.getOverlayFile(sourceFile) != null;
    }

    @Nullable
    public File getOverlayFile(@NotNull File sourceFile) {
        for (Map.Entry<File, File> entry : this.myMapping.entrySet()) {
            if (!FileUtil.pathsEqual((String)entry.getValue().getPath(), (String)sourceFile.getPath())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasSourceFile(@NotNull File overlayFile) {
        return this.myMapping.containsKey(overlayFile);
    }

    @Nullable
    public File getSourceFile(@NotNull File overlayFile) {
        return this.myMapping.get(overlayFile);
    }

    @NotNull
    public Collection<File> getOverlayFiles() {
        return this.myMapping.keySet();
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        return this.myMapping.values();
    }
}

