/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ClangTidyStartupActivity.class);
    private QueueProcessor<ScanEvent> queueProcessor = null;

    public void runActivity(@NotNull Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.doRunActivity(project2);
    }

    public void doRunActivity(final @NotNull Project project2) {
        if (project2.isDefault() || project2.isDisposed()) {
            return;
        }
        this.queueProcessor = new QueueProcessor(e -> ClangTidyStartupActivity.doScan(e));
        this.queueProcessor.add((Object)new ScanEvent(null, project2));
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    ClangTidyStartupActivity.this.queueProcessor.add((Object)new ScanEvent(vFileEvent, project2));
                }
            }
        });
    }

    public void waitForQueueProcessor() {
        this.queueProcessor.waitFor();
    }

    private static void doScan(@NotNull ScanEvent scanEvent) {
        VFileEvent fileEvent = scanEvent.myEvent;
        Project project2 = scanEvent.myProject;
        ClangTidyFilesState state = (ClangTidyFilesState)project2.getService(ClangTidyFilesState.class);
        if (fileEvent == null) {
            String basePath = project2.getBasePath();
            if (StringUtil.isEmpty((String)basePath)) {
                LOG.info("Cannot run ClangTidyStartupActivity since basePath is empty");
                return;
            }
            List<File> clangTidyFiles = ClangTidyStartupActivity.findClangTidyFiles(new File(basePath));
            state.setClangTidyFiles(clangTidyFiles);
            return;
        }
        VirtualFile file2 = fileEvent.getFile();
        if (file2 == null) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is null");
            return;
        }
        if (fileEvent instanceof VFileDeleteEvent) {
            ClangTidyStartupActivity.removeFileOrDirectory(file2.getPath(), file2.isDirectory(), state);
        } else if (fileEvent instanceof VFileMoveEvent) {
            ClangTidyStartupActivity.removeFileOrDirectory(((VFileMoveEvent)fileEvent).getOldPath(), file2.isDirectory(), state);
            ClangTidyStartupActivity.addFileOrDirectory(file2, state);
        } else if (fileEvent instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)fileEvent;
            if (propertyChangeEvent.getPropertyName().equals("name")) {
                ClangTidyStartupActivity.removeFileOrDirectory(propertyChangeEvent.getOldPath(), file2.isDirectory(), state);
                ClangTidyStartupActivity.addFileOrDirectory(file2, state);
            }
        } else if (fileEvent instanceof VFileCreateEvent) {
            ClangTidyStartupActivity.addFileOrDirectory(file2, state);
        } else if (fileEvent instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)fileEvent;
            VirtualFile createdFile = copyEvent.findCreatedFile();
            if (createdFile == null) {
                LOG.debug("Cannot process VFileEvent: created file is null");
                return;
            }
            ClangTidyStartupActivity.addFileOrDirectory(createdFile, state);
        }
    }

    private static void addFileOrDirectory(@NotNull VirtualFile file2, @NotNull ClangTidyFilesState state) {
        if (!file2.isValid()) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is not valid");
        }
        if (file2.isDirectory()) {
            for (VirtualFile childFile : ClangTidyStartupActivity.findClangTidyFiles(file2)) {
                state.addClangTidyFile(new File(childFile.getPath()));
            }
        } else if (ClangTidyStartupActivity.isClangTidyFile(file2)) {
            state.addClangTidyFile(new File(file2.getPath()));
        }
    }

    private static void removeFileOrDirectory(@NotNull String filePath, boolean isDirectory, @NotNull ClangTidyFilesState state) {
        File file2 = new File(filePath);
        if (!isDirectory && ClangTidyStartupActivity.isClangTidyFile(file2)) {
            state.removeClangTidyFile(file2);
            return;
        }
        List<File> clangTidyFiles = state.getClangTidyFiles();
        for (File clangTidyFile : clangTidyFiles) {
            if (!FileUtil.isAncestor((File)file2, (File)clangTidyFile, (boolean)true)) continue;
            state.removeClangTidyFile(clangTidyFile);
        }
    }

    @NotNull
    private static List<VirtualFile> findClangTidyFiles(@NotNull VirtualFile rootFile) {
        final ArrayList<VirtualFile> clangTidyFiles = new ArrayList<VirtualFile>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (ClangTidyStartupActivity.isClangTidyFile(file2)) {
                    clangTidyFiles.add(file2);
                }
                return CONTINUE;
            }
        });
        return clangTidyFiles;
    }

    @NotNull
    private static List<File> findClangTidyFiles(@NotNull File baseDir) {
        ArrayList<File> clangTidyFiles = new ArrayList<File>();
        ClangTidyStartupActivity.visitFilesIgnoringSymlinks(baseDir, (Processor<? super File>)((Processor)file2 -> {
            if (ClangTidyStartupActivity.isClangTidyFile(file2)) {
                clangTidyFiles.add((File)file2);
            }
            return true;
        }));
        return clangTidyFiles;
    }

    private static boolean visitFilesIgnoringSymlinks(@NotNull File root, @NotNull Processor<? super File> processor2) {
        if (!processor2.process((Object)root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory() && Files.isSymbolicLink(child.toPath()) || ClangTidyStartupActivity.visitFilesIgnoringSymlinks(child, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isClangTidyFile(@NotNull VirtualFile file2) {
        return file2.getName().equals(".clang-tidy");
    }

    private static boolean isClangTidyFile(@NotNull File file2) {
        return file2.getName().equals(".clang-tidy");
    }

    private static class ScanEvent {
        VFileEvent myEvent;
        Project myProject;

        ScanEvent(@Nullable VFileEvent event, @NotNull Project project2) {
            this.myEvent = event;
            this.myProject = project2;
        }
    }
}

