/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClangTidyFilesStateImpl
implements ClangTidyFilesState {
    private final Map<Integer, File> clangTidyFilesMap = new HashMap<Integer, File>();

    @Override
    @NotNull
    public synchronized List<File> getClangTidyFiles() {
        return ContainerUtil.immutableList(new ArrayList<File>(this.clangTidyFilesMap.values()));
    }

    @Override
    public synchronized void setClangTidyFiles(@NotNull List<File> clangTidyFiles) {
        this.clangTidyFilesMap.clear();
        for (File clangTidyFile : clangTidyFiles) {
            this.processClangTidyFile(clangTidyFile);
        }
    }

    @Override
    public synchronized void addClangTidyFile(@NotNull File clangTidyFile) {
        this.processClangTidyFile(clangTidyFile);
    }

    @Override
    public synchronized void removeClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory = clangTidyFile.getParentFile();
        if (parentDirectory != null) {
            this.clangTidyFilesMap.remove(ClangTidyFilesStateImpl.getHashCode(parentDirectory));
        }
    }

    @Override
    public synchronized boolean hasClangTidyFilesInPath(@NotNull File file2) {
        File directory;
        File file3 = directory = file2.isDirectory() ? file2 : file2.getParentFile();
        while (directory != null) {
            if (this.clangTidyFilesMap.containsKey(ClangTidyFilesStateImpl.getHashCode(directory))) {
                return true;
            }
            directory = directory.getParentFile();
        }
        return false;
    }

    private void processClangTidyFile(@NotNull File clangTidyFile) {
        File parentDirectory = clangTidyFile.getParentFile();
        if (parentDirectory != null) {
            this.clangTidyFilesMap.put(ClangTidyFilesStateImpl.getHashCode(parentDirectory), clangTidyFile);
        }
    }

    private static int getHashCode(@NotNull File file2) {
        return FileUtil.fileHashCode((File)file2);
    }
}

