/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangRequestsHelper {
    @NotNull
    private static final String MACRO_PREDEFINES_BASE_PATH = "/clion_clangd_inmemory_directory/macros";

    private ClangRequestsHelper() {
        throw new AssertionError();
    }

    public static boolean isMacroFile(@NotNull ClangDaemonContext context2, @NotNull String url) {
        return ClangRequestsHelper.isMacroFile(context2.getUrlConverter(), url);
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NotNull String url) {
        return converter.fromUri(converter.toUri(url)).contains(MACRO_PREDEFINES_BASE_PATH);
    }

    public static boolean isAllowedByGuard(@NotNull ClangDaemonContext context2, @NotNull String url) {
        return !context2.getCrashHandler().isBanned(url);
    }

    static boolean isMacroLSPSymbolKind(@Nullable SymbolKind kind) {
        return kind == SymbolKind.Module;
    }

    public static String getMacrosFileUrl(@NotNull ClangDaemonContext context2, @NotNull String url) {
        return "file://" + ClangRequestsHelper.getMacrosFilePath(context2, url);
    }

    @NotNull
    public static String getMacrosFilePath(@NotNull ClangDaemonContext context2, @NotNull String url) {
        if (!context2.getUrlConverter().isAcceptable(url)) {
            return SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/macros/__wrong_url_" : "/clion_clangd_inmemory_directory/macros/__wrong_url_";
        }
        String path = context2.getUrlConverter().fromUri(context2.getUrlConverter().toUri(url));
        if (SystemInfo.isWindows && path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '/') {
            char driveLetter = path.charAt(0);
            path = path.replaceFirst(":", "");
            path = driveLetter + ":" + MACRO_PREDEFINES_BASE_PATH + (path.startsWith("/") ? path : "/" + path);
            return path;
        }
        return MACRO_PREDEFINES_BASE_PATH + (path.startsWith("/") ? path : "/" + path);
    }
}

