/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangInteractionPromiseImpl<I extends ClangInteraction>
implements ClangInteractionPromise<I> {
    @NotNull
    private final Class<I> myRequestClass;
    @NotNull
    private final CompletableFuture<I> myFutureRequest;
    @Nullable
    private final Runnable myRejectedHandler;
    @Nullable
    private final List<Pair<String, ClangProperty>> myReadAccessedProperties;
    @Nullable
    private final List<Pair<String, ClangProperty>> myWriteAccessedProperties;
    private final boolean myIsRearrangeable;
    private final boolean myIsImmediate;

    public ClangInteractionPromiseImpl(@NotNull Class<I> requestClass, @NotNull CompletableFuture<I> futureRequest, @Nullable Runnable rejectedHandler, @Nullable List<Pair<String, ClangProperty>> readAccessedProperties, @Nullable List<Pair<String, ClangProperty>> writeAccessedProperties, boolean isRearrangeable, boolean isImmediate) {
        this.myRequestClass = requestClass;
        this.myFutureRequest = futureRequest;
        this.myRejectedHandler = rejectedHandler;
        this.myReadAccessedProperties = readAccessedProperties;
        this.myWriteAccessedProperties = writeAccessedProperties;
        this.myIsRearrangeable = isRearrangeable;
        this.myIsImmediate = isImmediate;
    }

    @Override
    @NotNull
    public Class<I> getInteractionClass() {
        return this.myRequestClass;
    }

    @Override
    @NotNull
    public CompletableFuture<I> getInteraction() {
        return this.myFutureRequest;
    }

    @Override
    @Nullable
    public Runnable getRejectedHandler() {
        return this.myRejectedHandler;
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return this.myWriteAccessedProperties;
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getReadProperties() {
        return this.myReadAccessedProperties;
    }

    @Override
    public boolean isRearrangeable() {
        return this.myIsRearrangeable;
    }

    @Override
    public boolean isImmediate() {
        return this.myIsImmediate;
    }

    public String toString() {
        return this.myRequestClass.getSimpleName() + (this.myReadAccessedProperties != null ? "\nReads: " + ClangInteractionPromiseImpl.toStringProperties(this.myReadAccessedProperties) : "") + (this.myWriteAccessedProperties != null ? "\nWrites: " + ClangInteractionPromiseImpl.toStringProperties(this.myWriteAccessedProperties) : "");
    }

    @NotNull
    private static String toStringProperties(@NotNull List<Pair<String, ClangProperty>> properties) {
        StringBuilder sb = new StringBuilder();
        HashMap propertiesByFile = new HashMap();
        properties.forEach(urlAndProperty -> propertiesByFile.computeIfAbsent(urlAndProperty.first, k -> new ArrayList()).add(urlAndProperty.second));
        propertiesByFile.keySet().stream().sorted().forEach(url -> sb.append((String)url).append(propertiesByFile.get(url)).append(" "));
        return sb.toString();
    }

    public static final class Builder<I extends ClangInteraction> {
        @NotNull
        private final Class<I> myRequestClass;
        @NotNull
        private final CompletableFuture<I> myFutureRequest;
        @Nullable
        private Runnable myRejectedHandler;
        @Nullable
        private List<Pair<String, ClangProperty>> myReadAccessedProperties;
        @Nullable
        private List<Pair<String, ClangProperty>> myWriteAccessedProperties;
        private boolean myIsRearrangeable = true;
        private boolean myIsImmediate = true;

        public Builder(@NotNull Class<I> requestClass, @NotNull CompletableFuture<I> futureRequest) {
            this.myRequestClass = requestClass;
            this.myFutureRequest = futureRequest;
        }

        public Builder(@NotNull I request) {
            this.myRequestClass = request.getClass();
            this.myFutureRequest = CompletableFuture.completedFuture(request);
        }

        @NotNull
        public Builder<I> addRejectedHandler(@NotNull Runnable rejectedHandler) {
            assert (this.myRejectedHandler == null);
            this.myRejectedHandler = rejectedHandler;
            return this;
        }

        @NotNull
        public Builder<I> addReadAccessedProperties(@NotNull String url, ClangProperty ... properties) {
            if (this.myReadAccessedProperties == null) {
                this.myReadAccessedProperties = new ArrayList<Pair<String, ClangProperty>>();
            }
            for (ClangProperty property : properties) {
                this.myReadAccessedProperties.add((Pair<String, ClangProperty>)Pair.create((Object)url, (Object)((Object)property)));
            }
            return this;
        }

        @NotNull
        public Builder<I> setReadAccessedProperties(@Nullable List<Pair<String, ClangProperty>> readAccessedProperties) {
            this.myReadAccessedProperties = readAccessedProperties;
            return this;
        }

        @NotNull
        public Builder<I> addWriteAccessedProperties(@NotNull String url, ClangProperty ... properties) {
            if (this.myWriteAccessedProperties == null) {
                this.myWriteAccessedProperties = new ArrayList<Pair<String, ClangProperty>>();
            }
            for (ClangProperty property : properties) {
                this.myWriteAccessedProperties.add((Pair<String, ClangProperty>)Pair.create((Object)url, (Object)((Object)property)));
            }
            return this;
        }

        @NotNull
        public Builder<I> setWriteAccessedProperties(@Nullable List<Pair<String, ClangProperty>> writeAccessedProperties) {
            this.myWriteAccessedProperties = writeAccessedProperties;
            return this;
        }

        @NotNull
        public Builder<I> setRearrangeable(boolean rearrangeable) {
            this.myIsRearrangeable = rearrangeable;
            return this;
        }

        @NotNull
        public Builder<I> setImmediate(boolean isImmediate) {
            this.myIsImmediate = isImmediate;
            return this;
        }

        @NotNull
        public ClangInteractionPromise<I> create() {
            return new ClangInteractionPromiseImpl<I>(this.myRequestClass, this.myFutureRequest, this.myRejectedHandler, this.myReadAccessedProperties, this.myWriteAccessedProperties, this.myIsRearrangeable, this.myIsImmediate);
        }
    }
}

