/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdBatchAction;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.c"})
public final class ClangdBatchAction
extends AnAction {
    private static final Logger LOG;
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Collection<VirtualFile> files = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project3);
        long startTime = System.nanoTime();
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getIfStarted(project3);
        int nThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        boolean bl = false;
        Set filesWithErrors = new LinkedHashSet();
        boolean bl2 = false;
        Set filesWithCrashes = new LinkedHashSet();
        AtomicInteger processedCount = new AtomicInteger(0);
        Task.Backgroundable task2 = new Task.Backgroundable(files, executorService, clangdService, filesWithCrashes, processedCount, filesWithErrors, startTime, project3, project3, ClangdBundle.message("language.cpp.clangd.batch.action.title", new Object[0]), true){
            final /* synthetic */ Collection $files;
            final /* synthetic */ ExecutorService $executorService;
            final /* synthetic */ ClangLanguageService $clangdService;
            final /* synthetic */ Set $filesWithCrashes;
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ Set $filesWithErrors;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Project $project;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                for (VirtualFile file2 : this.$files) {
                    if (!OCLanguageUtils.isSupported(file2)) continue;
                    this.$executorService.submit(new Runnable(this, indicator, file2){
                        final /* synthetic */ actionPerformed.task.1 this$0;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ VirtualFile $file;

                        public final void run() {
                            boolean $i$f$runReadAction = false;
                            ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                                final /* synthetic */ actionPerformed.task.run.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final T compute() {
                                    boolean bl = false;
                                    this.this$0.$indicator.setText(this.this$0.$file.getUrl());
                                    SimpleOpenRequestId requestId = new SimpleOpenRequestId(ClangdBatchAction.class, "opened [" + this.this$0.$file.getName() + "]");
                                    this.this$0.this$0.$clangdService.notifyDocumentOpened(this.this$0.$file, requestId);
                                    try {
                                        long time = System.nanoTime();
                                        List diagnostics2 = (List)ClangLanguageServiceUtilsKt.computeWithParsedKt(this.this$0.this$0.$clangdService, this.this$0.$file, actionPerformed.task.run.1.diagnostics.1.INSTANCE);
                                        if (diagnostics2 == null) {
                                            if (!this.this$0.$indicator.isCanceled()) {
                                                ClangdBatchAction.access$getLOG$cp().error(this.this$0.$file.getUrl() + ": clangd crashed");
                                                this.this$0.this$0.$filesWithCrashes.add(this.this$0.$file);
                                            }
                                        } else {
                                            int n;
                                            Iterable $this$count$iv = diagnostics2;
                                            boolean $i$f$count = false;
                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                n = 0;
                                            } else {
                                                int count$iv = 0;
                                                for (T element$iv : $this$count$iv) {
                                                    ClangDiagnostic it = (ClangDiagnostic)element$iv;
                                                    boolean bl2 = false;
                                                    if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)HighlightSeverity.ERROR)) continue;
                                                    int n2 = ++count$iv;
                                                    boolean bl3 = false;
                                                    if (n2 >= 0) continue;
                                                    CollectionsKt.throwCountOverflow();
                                                }
                                                n = count$iv;
                                            }
                                            int numErrors = n;
                                            long durationMS = (System.nanoTime() - time) / (long)1000000;
                                            long fileLength = this.this$0.$file.getLength();
                                            if (numErrors > 0) {
                                                this.this$0.this$0.$filesWithErrors.add(this.this$0.$file);
                                            }
                                            ClangdBatchAction.access$getLOG$cp().info(this.this$0.$file.getUrl() + ", " + "wait time: " + durationMS + "ms, " + "length:" + fileLength / (long)1024 + "kb, " + "performance: " + fileLength / durationMS + " kb/s, " + "numErrors = " + numErrors);
                                        }
                                    }
                                    catch (Throwable ex) {
                                        ClangdBatchAction.access$getLOG$cp().error(this.this$0.$file.getUrl() + ": clangd crashed");
                                        this.this$0.this$0.$filesWithCrashes.add(this.this$0.$file);
                                    }
                                    finally {
                                        this.this$0.this$0.$clangdService.notifyDocumentClosed(this.this$0.$file, requestId);
                                        int processed = this.this$0.this$0.$processedCount.incrementAndGet();
                                        this.this$0.$indicator.setFraction(1.0 * (double)processed / (double)this.this$0.this$0.$files.size());
                                    }
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$indicator = progressIndicator;
                            this.$file = virtualFile;
                        }
                    });
                }
                this.$executorService.shutdown();
                try {
                    while (true) {
                        this.$executorService.awaitTermination(1L, TimeUnit.SECONDS);
                        ProgressManager.checkCanceled();
                    }
                }
                catch (Throwable throwable) {
                    this.$executorService.shutdownNow();
                    long totalDurationMS = (System.nanoTime() - this.$startTime) / (long)1000000;
                    CharSequence charSequence = "\n";
                    CharSequence charSequence2 = null;
                    int n = 0;
                    CharSequence charSequence3 = null;
                    CharSequence charSequence4 = null;
                    Function1 function1 = actionPerformed.task.run.result.1.INSTANCE;
                    StringBuilder stringBuilder = new StringBuilder().append("total duration: ").append(totalDurationMS).append("ms, avg: ").append(totalDurationMS / (long)this.$files.size()).append("ms/file\n").append("Errors:\n").append(CollectionsKt.joinToString$default((Iterable)this.$filesWithErrors, (CharSequence)charSequence, charSequence4, charSequence3, (int)n, charSequence2, (Function1)function1, (int)30, null)).append("\n").append("Crashes:\n");
                    charSequence = "\n";
                    charSequence2 = null;
                    n = 0;
                    charSequence3 = null;
                    charSequence4 = null;
                    function1 = actionPerformed.task.run.result.2.INSTANCE;
                    String result2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)this.$filesWithCrashes, (CharSequence)charSequence, charSequence4, charSequence3, (int)n, charSequence2, (Function1)function1, (int)30, null)).append("\n").toString();
                    ClangdBatchAction.access$getLOG$cp().warn(result2);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, result2){
                        final /* synthetic */ actionPerformed.task.1 this$0;
                        final /* synthetic */ String $result$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$result$inlined = string;
                        }

                        public final void run() {
                            boolean bl = false;
                            LightVirtualFile infoFile = new LightVirtualFile("Clangd Batch Result", (FileType)PlainTextFileType.INSTANCE, (CharSequence)this.$result$inlined);
                            FileEditorManager.getInstance((Project)this.this$0.$project).openFile((VirtualFile)infoFile, true);
                        }
                    }, ModalityState.defaultModalityState());
                    throw throwable;
                }
            }

            public void onCancel() {
                super.onCancel();
                this.$executorService.shutdownNow();
            }
            {
                this.$files = $captured_local_variable$0;
                this.$executorService = $captured_local_variable$1;
                this.$clangdService = $captured_local_variable$2;
                this.$filesWithCrashes = $captured_local_variable$3;
                this.$processedCount = $captured_local_variable$4;
                this.$filesWithErrors = $captured_local_variable$5;
                this.$startTime = $captured_local_variable$6;
                this.$project = $captured_local_variable$7;
                super($super_call_param$8, $super_call_param$9, $super_call_param$10);
            }
        };
        task2.queue();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)ClangdBatchAction.class.getName());
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

