/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangCrashReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdNativeStacktraceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdRequestsPlanner;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory.ClangMemoryUsageWatchDogImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCompletionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpASTRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpTokensRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatConfigurationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatRangeRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoDefinitionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndentRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangParseCommandLineRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPreprocessRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSaveRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdLanguageService
implements ClangLanguageService,
PendingParseListener {
    private static final Logger LOG = Logger.getInstance((String)ClangdLanguageService.class.getName());
    private static final WorkspaceFile.Key<Map<OpenRequestId, Integer>> OPEN_REQUESTS = new WorkspaceFile.Key<Map>("OpenRequests", () -> new HashMap());
    private static final Key<UsagesInfo> USAGES_MAP = new Key("UsagesMap");
    private static final Key<Object> CANCELED_FLAG = new Key("CanceledFlag");
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangLocalWorkspace myWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ClangdRequestsPlanner myRequestsPlanner;
    @NotNull
    private final ClangMemoryUsageWatchDog myMemoryUsageWatchDog;
    @NotNull
    private final Set<UserDataHolder> myDebugUsagesSet = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    @NotNull
    private final Cache<GotoDefinitionKey, ClangGotoDefinitionRequest> myGotoDefinitionCache = CacheBuilder.newBuilder().maximumSize(4096L).build();

    @NotNull
    public static ClangdLanguageService create(@NotNull ClangDaemonContext context2) {
        ClangServerAccessor accessor = context2.getServerAccessorProvider().createServerAccessor(context2);
        if (context2.shouldStartServerImmediately()) {
            accessor.post(ClangInteraction.createSimple("Misc", (Consumer<? super ClangServer>)((Consumer)server -> {}), true));
        }
        return new ClangdLanguageService(context2, accessor);
    }

    private ClangdLanguageService(@NotNull ClangDaemonContext context2, @NotNull ClangServerAccessor serverAccessor) {
        this.myContext = context2;
        this.myProject = context2.getProject();
        this.myWorkspace = context2.getLocalWorkspace();
        this.myIdeFacade = context2.getIdeFacade();
        this.myRequestsPlanner = new ClangdRequestsPlanner(context2.getDescriptor(), serverAccessor);
        this.myWorkspace.addPendingParseListener(this);
        this.myMemoryUsageWatchDog = new ClangMemoryUsageWatchDogImpl(context2, this);
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        this.myWorkspace.modify(oldest.getUrl(), wf -> this.sendCancelParse((LocalWorkspaceFile)wf, oldest));
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.myContext.getMessageBus();
    }

    @Override
    public boolean isActive() {
        return !this.myContext.isStopped();
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myContext.getTelemetry();
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        return this.myMemoryUsageWatchDog;
    }

    @Override
    public <E extends Throwable> void gotoDefinition(@NotNull VirtualFile file2, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        ClangResultImpl result2 = this.computeWithParsedInternal("gotoDefinition", file2, (modifier, response) -> this.sendGotoDefinition((ClangParseResponse)response, file2, offset));
        ClangdLanguageService.applyConsumer(consumer, result2);
    }

    @Override
    public <E extends Throwable> void dumpAST(@NotNull VirtualFile file2, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        ClangResultImpl result2 = this.computeWithParsedInternal("dumpAST", file2, (modifier, response) -> this.sendDumpAST((ClangParseResponse)response, file2, offset));
        ClangdLanguageService.applyConsumer(consumer, result2);
    }

    @Override
    public <E extends Throwable> void dumpTokens(@NotNull VirtualFile file2, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        ClangResultImpl result2 = this.computeWithParsedInternal("dumpTokens", file2, (modifier, response) -> this.sendDumpTokens((ClangParseResponse)response, file2, offset));
        ClangdLanguageService.applyConsumer(consumer, result2);
    }

    @Override
    public <E extends Throwable> void complete(@NotNull VirtualFile file2, int offset, @NotNull CompletionTriggerKind kind, @NotNull ClangResultConsumer<Either<List<CLionCompletionItem>, CLionCompletionList>, E> consumer) throws E {
        ClangResultImpl result2 = this.computeWithParsedInternal("complete", file2, (wf, response) -> this.sendRequestComplete(file2, offset, kind));
        ClangdLanguageService.applyConsumer(consumer, result2);
    }

    @Override
    @NotNull
    public CompletableFuture<ClionFileStats> requestTimingStats(@NotNull VirtualFile file2) {
        CompletableFuture<ClionFileStats> result2 = new CompletableFuture<ClionFileStats>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("RequestTimingsStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionRequestTimingsStat(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file2.getUrl()))).whenComplete((res, ex) -> result2.complete((ClionFileStats)res)))).onSkipped(() -> result2.complete(null)).onRejected(() -> result2.complete(null)).requiresRecover().create());
        return result2;
    }

    @Override
    @NotNull
    public CompletableFuture<String> preprocess(@NotNull VirtualFile file2) {
        return this.myWorkspace.applyWithRead(file2.getUrl(), wf -> {
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(wf.getUrl()));
            ClangPreprocessRequest request = new ClangPreprocessRequest(file2.getUrl(), identifier);
            this.myRequestsPlanner.send(ClangPreprocessRequest.createPromise(this.myContext, request));
            return request.getResponse();
        });
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile file2) {
        return this.withOpenedFile(file2, wf -> this.sendRequestClangFormatConfiguration(file2));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file2, @NotNull TextRange range, @Nullable String style) {
        return this.myWorkspace.applyWithRead(file2.getUrl(), wf -> this.sendFormatRangeRequest(file2, range, style));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> indentLine(@NotNull VirtualFile file2, int lineStartOffset, @Nullable String style) {
        return this.myWorkspace.applyWithRead(file2.getUrl(), wf -> this.isAcceptable(file2) ? this.sendIndentRequest(file2, lineStartOffset, style) : CompletableFuture.completedFuture(null));
    }

    @Override
    @Nullable
    public ClangParseResponse getParsed(@NotNull VirtualFile file2) {
        String url = file2.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return null;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        return this.myWorkspace.applyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            return this.getOrParse(file2, workspaceFile, macrosWorkspaceFile, null);
        });
    }

    @Override
    public <E extends Throwable> void runWithParsed(@NotNull VirtualFile file2, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        this.computeWithParsed(file2, response -> {
            consumer.consume(response);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithParsed(@NotNull VirtualFile file2, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        Ref response = Ref.create();
        Ref usageID = Ref.create();
        try {
            ReadAction.run(() -> {
                String url = file2.getUrl();
                if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                    return;
                }
                String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
                ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
                try {
                    this.myWorkspace.modify(Arrays.asList(url, macrosUrl), files -> {
                        LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                        assert (workspaceFile != null) : "requested file must not be null!";
                        LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                        assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                        if (!workspaceFile.isOpened() && ClangDebugLevel.isWarnOrMore()) {
                            CidrLogService.logOnce(Level.WARNING, "Trying to parse closed file: " + workspaceFile.getUrl(), new Exception());
                        }
                        response.set((Object)this.getOrParse(file2, workspaceFile, macrosWorkspaceFile, deferrer));
                        usageID.set((Object)this.trackParseUsage(workspaceFile, (ClangParseResponse)response.get()));
                    });
                }
                finally {
                    deferrer.runDeferred();
                }
            });
            T t = consumer.apply((ClangParseResponse)response.get());
            return t;
        }
        finally {
            if (!response.isNull() && !usageID.isNull()) {
                this.freeParseUsage((ClangParseResponse)response.get(), (Integer)usageID.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithOpenedAndParsed(@NotNull VirtualFile file2, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "computeWithOpenedAndParsed for " + file2.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file2, openRequestId);
            T t = this.computeWithParsed(file2, consumer);
            return t;
        }
        finally {
            this.notifyDocumentClosed(file2, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void runWithOpenedAndParsed(@NotNull VirtualFile file2, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "runWithOpenedAndParsed for " + file2.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file2, openRequestId);
            this.runWithParsed(file2, consumer);
        }
        finally {
            this.notifyDocumentClosed(file2, openRequestId);
        }
    }

    @NotNull
    private <T> ClangResultImpl<T> computeWithParsedInternal(@NotNull String title, @NotNull VirtualFile file2, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTBasedRequest<?, T>> consumer) {
        return (ClangResultImpl)ReadAction.compute(() -> {
            String url = file2.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
            try {
                ClangResultImpl clangResultImpl = this.myWorkspace.apply(Arrays.asList(url, macrosUrl), files -> {
                    LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                    assert (workspaceFile != null) : "requested file must not be null!";
                    LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                    assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                    ClangParseResponse response = this.getOrParse(file2, workspaceFile, macrosWorkspaceFile, deferrer);
                    if (response != null) {
                        int parseUsageID = this.trackParseUsage(workspaceFile, response);
                        try {
                            ClangASTBasedRequest request = (ClangASTBasedRequest)consumer.apply(workspaceFile, response);
                            if (request != null) {
                                int reqUsageID = this.trackRequestUsage(workspaceFile, request);
                                return new ClangResultImpl(title, request.getResponse(), () -> {
                                    this.freeRequestUsage(request, reqUsageID);
                                    this.freeParseUsage(response, parseUsageID);
                                });
                            }
                        }
                        catch (Throwable thr) {
                            this.freeParseUsage(response, parseUsageID);
                        }
                    }
                    return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
                });
                return clangResultImpl;
            }
            finally {
                deferrer.runDeferred();
            }
        });
    }

    private static <T, E extends Throwable> void applyConsumer(@NotNull ClangResultConsumer<T, E> consumer, @NotNull ClangResultImpl<T> res) throws E {
        try {
            consumer.consume(res);
        }
        finally {
            res.release();
        }
    }

    private int trackParseUsage(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (response == null) {
            return -1;
        }
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
        int ID2 = ++usages.nextID;
        usages.id2Stack.put(ID2, this.debugTrackUsage((UserDataHolder)response));
        return ID2;
    }

    private void freeParseUsage(@NotNull ClangParseResponse response, int usageID) {
        this.myWorkspace.modify(response.getUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)response);
                this.cancelParse((LocalWorkspaceFile)wf, response);
            }
        });
    }

    private int trackRequestUsage(@NotNull LocalWorkspaceFile wf, @NotNull ClangASTBasedRequest<?, ?> request) {
        assert (wf.getUrl().contentEquals(request.getAstFileUrl()));
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent(request, USAGES_MAP, () -> new UsagesInfo());
        int ID2 = ++usages.nextID;
        usages.id2Stack.put(ID2, this.debugTrackUsage((UserDataHolder)request));
        return ID2;
    }

    private void freeRequestUsage(@NotNull ClangASTBasedRequest<?, ?> request, int usageID) {
        this.myWorkspace.modify(request.getAstFileUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)request, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)request);
                this.cancelRequest(request);
            }
        });
    }

    @Nullable
    private Exception debugTrackUsage(@NotNull UserDataHolder usedObject) {
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            this.myDebugUsagesSet.add(usedObject);
            return new Exception();
        }
        return null;
    }

    private void debugFreeUsage(@NotNull UserDataHolder usedObject) {
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            assert (usages != null && usages.id2Stack.isEmpty());
            this.myDebugUsagesSet.remove(usedObject);
        }
    }

    private static boolean isCanceled(@NotNull UserDataHolder something) {
        return something.getUserData(CANCELED_FLAG) != null;
    }

    private static void setCanceled(@NotNull UserDataHolder something) {
        something.putUserData(CANCELED_FLAG, (Object)true);
    }

    private void cancelParseGently(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (response != null) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            if (usages.id2Stack.isEmpty()) {
                this.cancelParse(wf, response);
            }
        }
    }

    private void cancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (response.isCancellable() && wf.getVersion() > response.getVersion() && !ClangParseResponse.areAnswersCompleted(response)) {
            this.sendCancelParse(wf, response);
        }
    }

    private void cancelRequest(@NotNull ClangAbstractRequest<?, ?> request) {
        if (!ClangdLanguageService.isCanceled(request) && !request.getResponse().isDone()) {
            this.myRequestsPlanner.sendImmediately(request.cancel());
            ClangdLanguageService.setCanceled(request);
        }
    }

    private void sendCancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (!ClangdLanguageService.isCanceled((UserDataHolder)response)) {
            this.myRequestsPlanner.send(ClangCancelParseNotification.createPromise(this.myContext, response));
            ClangdLanguageService.setCanceled((UserDataHolder)response);
            ClangParseResponse.completeAnswersExceptionally(response, new CancellationException());
        }
    }

    @NotNull
    private static <T> T computeIfAbsent(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull Producer<T> producer) {
        Object data = holder.getUserData(key);
        if (data == null) {
            data = producer.produce();
            assert (data != null);
            holder.putUserData(key, data);
        }
        return (T)data;
    }

    @Override
    @Nullable
    public ClangLocalWorkspace getLocalWorkspace() {
        return this.myWorkspace;
    }

    @Override
    @NotNull
    public CompletableFuture<ClangCrashReport> generateCrashReport(@NotNull List<String> urls) {
        CompletableFuture<ClangCrashReport> result2 = new CompletableFuture<ClangCrashReport>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashReport").action((server, ws) -> {
            ArrayList<CompletionStage> crashReportFutures = new ArrayList<CompletionStage>();
            for (String url : urls) {
                ClionReparseTextDocumentParams cc = ws.getReparseParams(url);
                if (cc != null) {
                    crashReportFutures.add(server.clionPreprocessFile(cc.getCompilationCommand()).thenApply(res -> {
                        if (res == null) {
                            return null;
                        }
                        String clangTidyConfig = "";
                        String clionClangTidyConfig = "";
                        if (cc.getClangTidyOptions() != null) {
                            clangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getConfig());
                            clionClangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getClionConfig());
                        }
                        boolean namehintsEnabled = cc.getClangNamehintOptions() != null && cc.getClangNamehintOptions().isEnableNamehints();
                        UnusedIncludesInspectionMode uiMode = cc.getUnusedIncludesInspectionMode() != null ? cc.getUnusedIncludesInspectionMode() : UnusedIncludesInspectionMode.Off;
                        return new ClangCrashReport.CrashedFile(url, cc.getCompilationCommand().getCommandLine(), clangTidyConfig, clionClangTidyConfig, namehintsEnabled, cc.getEnableDFA(), uiMode, res.getDiags(), res.getPpOutput());
                    }));
                    continue;
                }
                LOG.warn("Failed to get compilation command for previously parsed file " + url);
            }
            CompletableFuture.allOf(crashReportFutures.toArray(new CompletableFuture[0])).whenComplete((res, ex) -> {
                if (ex != null) {
                    LOG.warn("Failed to generate crash reports!", ex);
                    result2.complete(null);
                    return;
                }
                try {
                    ArrayList<ClangCrashReport.CrashedFile> crashReports = new ArrayList<ClangCrashReport.CrashedFile>();
                    for (CompletableFuture reportFuture : crashReportFutures) {
                        assert (reportFuture.isDone());
                        ClangCrashReport.CrashedFile file2 = (ClangCrashReport.CrashedFile)reportFuture.get();
                        if (file2 == null) continue;
                        crashReports.add(file2);
                    }
                    result2.complete(new ClangCrashReport(crashReports));
                }
                catch (InterruptedException | ExecutionException ee) {
                    LOG.warn((Throwable)ee);
                    result2.complete(null);
                }
            });
        }).requiresRecover().onSkipped(() -> result2.complete(null)).onRejected(() -> result2.complete(null)).create());
        return result2;
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangUtils.warnClangd(LOG, "Stopping " + this.getClass().getSimpleName() + "\n" + this.myContext.getLocalWorkspace().printStats("  ") + this.myContext.getCrashHandler().printStats("  Blacklist: "));
        Disposer.dispose((Disposable)this.myContext);
        return this.myRequestsPlanner.stop();
    }

    @Override
    public int getVersion(@NotNull VirtualFile file2) {
        return this.myWorkspace.apply(file2.getUrl(), wf -> wf.getVersion());
    }

    @Override
    public boolean notifyDocumentOpened(@NotNull VirtualFile file2, @NotNull OpenRequestId openRequestId) {
        return this.myWorkspace.applyWithRead(file2.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file2)) {
                return false;
            }
            ClangdLanguageService.addOpenRequest(wf, openRequestId);
            if (!wf.isOpened()) {
                int nextVersion = wf.nextOpen();
                this.myRequestsPlanner.send(ClangOpenNotification.createPromise(this.myContext, file2, nextVersion));
            }
            return true;
        });
    }

    private static void addOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests = wf.getOrDefault(OPEN_REQUESTS);
        if (id.ignoreSame()) {
            openRequests.putIfAbsent(id, 1);
        } else {
            openRequests.merge(id, 1, Integer::sum);
        }
    }

    @Override
    public void notifyDocumentClosed(@NotNull VirtualFile file2, @NotNull OpenRequestId openRequestId) {
        String url = file2.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            if (!this.isAcceptable(file2)) {
                return;
            }
            if (!workspaceFile.isOpened()) {
                return;
            }
            if (ClangdLanguageService.removeOpenRequest(workspaceFile, openRequestId)) {
                boolean isSaved = !this.myIdeFacade.isModified(file2);
                String content = StringUtil.notNullize((String)this.myIdeFacade.getText(file2));
                int nextVersion = workspaceFile.nextClose();
                this.myRequestsPlanner.send(ClangCloseNotification.createPromise(this.myContext, workspaceFile.getUrl(), nextVersion, content, isSaved));
                if (macrosWorkspaceFile.getVersion() >= 0) {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, macrosWorkspaceFile.getUrl(), macrosWorkspaceFile.nextDelete()));
                }
            }
        });
    }

    private static boolean removeOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests = wf.get(OPEN_REQUESTS);
        if (openRequests.containsKey(id)) {
            openRequests.merge(id, -1, (oldV, newV) -> oldV + newV > 0 ? Integer.valueOf(oldV + newV) : null);
            return openRequests.isEmpty();
        }
        return false;
    }

    @Override
    public void notifyDocumentChanged(@NotNull VirtualFile file2, @NotNull DocumentEvent event) {
        this.myWorkspace.modifyWithRead(file2.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file2)) {
                return;
            }
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = this.prepareChangeParams(wf.getUrl(), nextVersion, event, file2);
            boolean isSaved = !this.myIdeFacade.isModified(file2);
            this.myRequestsPlanner.send(ClangChangeNotification.createPromise(this.myContext, wf.getUrl(), nextVersion, params, isSaved));
        });
    }

    @NotNull
    private DidChangeTextDocumentParams prepareChangeParams(@NotNull String url, int version, @NotNull DocumentEvent event, @NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
        ServerCapabilities serverCapabilities = this.myRequestsPlanner.getServerAccessor().getCapabilities();
        if (serverCapabilities != null) {
            syncKind = serverCapabilities.getTextDocumentSync().isLeft() ? (TextDocumentSyncKind)serverCapabilities.getTextDocumentSync().getLeft() : ((TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight()).getChange();
        }
        Document document2 = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
        switch (syncKind) {
            case Incremental: {
                changeEvent.setText(this.myIdeFacade.getText(file2, document2));
                break;
            }
            case None: 
            case Full: {
                changeEvent.setText(document2.getText());
            }
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(this.myContext.getUrlConverter().toUri(url));
        docId.setVersion(Integer.valueOf(version));
        return new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReparseRequired(@NotNull VirtualFile file2) {
        ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
        try {
            String url = file2.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
                LocalWorkspaceFile wf = (LocalWorkspaceFile)files.get(url);
                assert (wf != null) : "requested file must not be null!";
                LocalWorkspaceFile macrosWf = (LocalWorkspaceFile)files.get(macrosUrl);
                assert (macrosWf != null) : "requested macros file must not be null!";
                this.notifyReparseRequiredImpl(file2, wf, macrosWf, deferrer);
            });
        }
        finally {
            deferrer.runDeferred();
        }
    }

    @Nullable
    private ClangParseResponse notifyReparseRequiredImpl(@NotNull VirtualFile file2, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @NotNull ClangHeavyRequestBuilder deferrer) {
        if (this.myContext.getProject().isDisposed()) {
            ClangUtils.warnClangd(LOG, "Will not reparse file " + file2.getName() + " because project is already disposed.");
            return null;
        }
        if (!this.isAcceptable(file2)) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file2.getName() + " is not acceptable.");
            return null;
        }
        if (!workspaceFile.isOpened()) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file2.getName() + " is not opened locally.");
            return null;
        }
        ClangParseResponse prevResponse = workspaceFile.getLastParseResponse();
        ClangParseResponse response = workspaceFile.nextParse(file2, true);
        response.putUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER, this.myIdeFacade.getPsiModificationCounter(this.myProject));
        this.cancelParseGently(workspaceFile, prevResponse);
        String macrosUrl = macrosWorkspaceFile.getUrl();
        int macrosVersion = macrosWorkspaceFile.nextChange();
        this.myRequestsPlanner.send(ClangReparseNotification.createPromise(deferrer, this.myContext, file2, response, macrosUrl, macrosVersion));
        return response;
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file2) {
        this.myWorkspace.modifyWithRead(file2.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file2)) {
                return;
            }
            this.myRequestsPlanner.send(ClangSaveRequest.createPromise(this.myContext, wf.getUrl()));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<? extends ClangCommandLineArgument>> parseCommandLine(@NotNull List<String> switches, @Nullable EnumSet<ClangOptionsFlags> flagsToInclude, @Nullable EnumSet<ClangOptionsFlags> flagsToExclude) {
        ClangCommandLine commandLine = new ClangCommandLine(switches, ClangdLanguageService.flagsEnumSetToBitField(flagsToInclude), ClangdLanguageService.flagsEnumSetToBitField(flagsToExclude));
        ClangParseCommandLineRequest request = new ClangParseCommandLineRequest(commandLine);
        this.myRequestsPlanner.send(ClangParseCommandLineRequest.Companion.createPromise(request));
        return request.getResponse();
    }

    private static int flagsEnumSetToBitField(@Nullable EnumSet<ClangOptionsFlags> flags) {
        if (flags == null) {
            return 0;
        }
        int bitField = 0;
        for (ClangOptionsFlags flag : flags) {
            bitField |= flag.getValue();
        }
        return bitField;
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (newUrl.contentEquals(newFile.getUrl()));
        if (oldUrl.contentEquals(newUrl)) {
            return;
        }
        String oldMacrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, oldUrl);
        this.myWorkspace.modifyWithRead(Arrays.asList(oldUrl, newUrl, oldMacrosUrl), mapOfFiles -> {
            LocalWorkspaceFile oldWf = (LocalWorkspaceFile)mapOfFiles.get(oldUrl);
            LocalWorkspaceFile oldMacrosWf = (LocalWorkspaceFile)mapOfFiles.get(oldMacrosUrl);
            LocalWorkspaceFile newWf = (LocalWorkspaceFile)mapOfFiles.get(newUrl);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            boolean oldIsAcceptable = oldWf.getVersion() > 0;
            boolean oldIsOpened = oldWf.isOpened();
            boolean newIsAcceptable = this.isAcceptable(newFile);
            if (oldIsAcceptable && newIsAcceptable) {
                if (oldIsOpened) {
                    Map<OpenRequestId, Integer> newOpenRequests = newWf.getOrDefault(OPEN_REQUESTS);
                    Map<OpenRequestId, Integer> oldOpenRequests = oldWf.getOrDefault(OPEN_REQUESTS);
                    oldOpenRequests.forEach((id, counter) -> newOpenRequests.merge((OpenRequestId)id, (Integer)counter, Integer::sum));
                    oldOpenRequests.clear();
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangOpenNotification.createPromise(this.myContext, newFile, newWf.nextOpen()));
                } else {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.sendContent(newWf, newFile);
                }
            } else if (oldIsAcceptable) {
                Map<OpenRequestId, Integer> oldEditors = oldWf.getOrDefault(OPEN_REQUESTS);
                oldEditors.clear();
                this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                if (oldIsOpened) {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                }
            } else if (newIsAcceptable) {
                List<OpenRequestId> openRequests = this.myIdeFacade.getOpenRequests(this.myProject, newFile);
                for (OpenRequestId openRequest : openRequests) {
                    this.notifyDocumentOpened(newFile, openRequest);
                }
                if (!newWf.isOpened() && this.myIdeFacade.isModified(newFile)) {
                    this.sendContent(newWf, newFile);
                }
            }
        });
    }

    @Nullable
    public Endpoint remoteEndpoint() {
        return this.myRequestsPlanner.getServerAccessor().getRemoteEndpoint();
    }

    @Nullable
    public ServerConnection serverConnection() {
        return this.myRequestsPlanner.getServerAccessor().getServerConnection();
    }

    @Override
    public CompletableFuture<Integer> shutDownServer() {
        return this.myRequestsPlanner.getServerAccessor().shutDown();
    }

    @Override
    public boolean isFileBanned(@NotNull String url) {
        return !ClangRequestsHelper.isAllowedByGuard(this.myContext, url);
    }

    @Override
    public void debugDumpCompilationDatabase() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpCompilationDatabase").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpCompilationDatabase())).create());
    }

    @Override
    public void debugDumpUnsavedFiles() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpUnsavedFiles").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpUnsavedFiles())).create());
    }

    @Override
    public String debugDumpUsages(@NotNull String url) {
        if (!Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            return "Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n";
        }
        BiConsumer<StringBuilder, UserDataHolder> usagesDumper = (sb, usedObject) -> {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            sb.append("usage counter = ").append(usages != null ? usages.id2Stack.size() : 0).append("\n");
            if (usages != null && !usages.id2Stack.isEmpty()) {
                usages.id2Stack.values().forEach(ex -> {
                    sb.append("=== Usage:");
                    if (ex != null) {
                        StackTraceElement[] stackTrace = ex.getStackTrace();
                        for (int i2 = 0; i2 < Math.min(stackTrace.length, 20); ++i2) {
                            StackTraceElement trace = stackTrace[i2];
                            sb.append("  ").append(trace.toString()).append("\n");
                        }
                    } else {
                        sb.append(" stack trace is not available. Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n");
                    }
                });
            }
        };
        return this.myWorkspace.apply(url, wf -> {
            StringBuilder sb = new StringBuilder();
            Set<UserDataHolder> set = this.myDebugUsagesSet;
            synchronized (set) {
                for (UserDataHolder holder : this.myDebugUsagesSet) {
                    if (holder instanceof ClangParseResponse) {
                        ClangParseResponse response = (ClangParseResponse)holder;
                        sb.append("Parse ").append(response.getVersion()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)response) ? "canceled" : "not canceled").append(", ").append(response.isCancellable() ? "cancellable" : "not cancellable").append(", ").append(ClangParseResponse.areAnswersCompleted(response) ? "completed" : "not completed").append(", ");
                        usagesDumper.accept(sb, (UserDataHolder)response);
                        continue;
                    }
                    if (!(holder instanceof ClangASTBasedRequest)) continue;
                    ClangASTBasedRequest request = (ClangASTBasedRequest)holder;
                    sb.append(request.getClass().getSimpleName()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)request) ? "canceled" : "not canceled").append(", ").append(request.getResponse().isDone() ? "completed" : "not completed").append(", ");
                    usagesDumper.accept(sb, (UserDataHolder)request);
                }
            }
            return sb.toString();
        });
    }

    @Override
    @NotNull
    public CompletableFuture<ClangMemoryUsageInfo> debugDumpMemoryStat() {
        CompletableFuture<ClangMemoryUsageInfo> answer = new CompletableFuture<ClangMemoryUsageInfo>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpMemoryStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpMemoryStat().whenComplete((info, ex) -> {
            if (ex != null) {
                answer.completeExceptionally((Throwable)ex);
                return;
            }
            ClangMemoryUsageInfo memoryUsageInfo = new ClangMemoryUsageInfo(info.getWorkingSet(), info.getDrafts(), info.getUnsaved(), ContainerUtil.map(info.getPerFile(), p -> new ClangMemoryUsageInfo.PerFile(p.getPath(), p.getKb())));
            answer.complete(memoryUsageInfo);
            this.myIdeFacade.sendMessageLater(() -> {
                if (this.myContext.canPublishMessage()) {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMemoryUsageInfoReceived(memoryUsageInfo);
                }
            });
        }))).onSkipped(() -> answer.complete(null)).onRejected(() -> answer.complete(null)).create());
        return answer;
    }

    @Override
    public void debugCrashServer() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashServer").action((Consumer<? super ClangServer>)((Consumer)server -> {
            server.shutdown();
            server.exit();
        })).create());
    }

    @Override
    public void waitUntilTasksFinished() {
        if (this.isActive()) {
            this.myRequestsPlanner.waitUntilTasksFinished();
        }
    }

    @Override
    public int getServerPid() {
        ServerConnection connection = this.serverConnection();
        if (!(connection instanceof ProcessServerConnectionProvider.ProcessServerConnection)) {
            return -1;
        }
        Process serverProcess = ((ProcessServerConnectionProvider.ProcessServerConnection)connection).getProcess();
        return OSProcessUtil.getProcessID((Process)serverProcess);
    }

    @Override
    @NotNull
    public String getNativeStacktrace() {
        int pid = this.getServerPid();
        if (pid != -1) {
            for (ClangdNativeStacktraceProvider nativeStacktraceProvider : ClangdNativeStacktraceProvider.EP_NAME.getExtensionList()) {
                try {
                    String stacktrace = nativeStacktraceProvider.getNativeStacktrace(pid);
                    if (stacktrace == null) continue;
                    return stacktrace;
                }
                catch (ExecutionException ex) {
                    return ExceptionUtil.getThrowableText((Throwable)ex);
                }
            }
        }
        return "unavailable";
    }

    @NotNull
    private <T> CompletableFuture<T> withOpenedFile(@NotNull VirtualFile file2, @NotNull Function<LocalWorkspaceFile, CompletableFuture<T>> consumer) {
        return this.myWorkspace.applyWithRead(file2.getUrl(), wf -> {
            if (!wf.isOpened()) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)consumer.apply((LocalWorkspaceFile)wf);
        });
    }

    @Nullable
    private ClangParseResponse getOrParse(@NotNull VirtualFile file2, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @Nullable ClangHeavyRequestBuilder deferrer) {
        if (!workspaceFile.isOpened()) {
            return null;
        }
        ClangParseResponse reparsedFile = workspaceFile.getLastParseResponse();
        if (reparsedFile != null) {
            if (reparsedFile.getVersion() < workspaceFile.getVersion()) {
                reparsedFile = null;
            } else if (ClangdLanguageService.isCanceled((UserDataHolder)reparsedFile)) {
                reparsedFile = null;
            } else if (ClangParseResponse.isInFailedState(reparsedFile)) {
                reparsedFile = null;
            } else {
                Long lastReparsedAtCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER);
                Long currentCounter = this.myIdeFacade.getPsiModificationCounter(this.myProject);
                if (currentCounter != null && lastReparsedAtCounter != null && currentCounter > lastReparsedAtCounter) {
                    reparsedFile = null;
                }
            }
        }
        if (reparsedFile == null && deferrer != null) {
            reparsedFile = this.notifyReparseRequiredImpl(file2, workspaceFile, macrosWorkspaceFile, deferrer);
        }
        return reparsedFile;
    }

    @Nullable
    private ClangGotoDefinitionRequest sendGotoDefinition(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file2, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoDefinitionRequest cachedAnswer = (ClangGotoDefinitionRequest)this.myGotoDefinitionCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair paramsAndRange = this.findLine(file2, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file2.getUrl()));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        });
        if (paramsAndRange == null) {
            return null;
        }
        ClangGotoDefinitionRequest gotoRequest = new ClangGotoDefinitionRequest(this.myContext, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(ClangGotoDefinitionRequest.createPromise(this.myContext, gotoRequest));
        TextRange range = (TextRange)paramsAndRange.second;
        if (range != null) {
            for (int cacheOffset = range.getStartOffset(); cacheOffset < range.getEndOffset(); ++cacheOffset) {
                this.myGotoDefinitionCache.put((Object)new GotoDefinitionKey(reparse, cacheOffset), (Object)gotoRequest);
            }
        } else {
            this.myGotoDefinitionCache.put((Object)requestCacheKey, (Object)gotoRequest);
        }
        return gotoRequest;
    }

    @Nullable
    private ClangDumpASTRequest sendDumpAST(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file2, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file2, offset);
        if (params == null) {
            return null;
        }
        ClangDumpASTRequest dumpASTRequest = new ClangDumpASTRequest(reparse.getUrl(), params);
        this.myRequestsPlanner.send(ClangDumpASTRequest.create(this.myContext, dumpASTRequest));
        return dumpASTRequest;
    }

    @NotNull
    private CompletableFuture<String> sendRequestClangFormatConfiguration(@NotNull VirtualFile file2) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file2, 0);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        ClangFormatConfigurationRequest formatConfigurationRequest = new ClangFormatConfigurationRequest(file2.getUrl(), params);
        this.myRequestsPlanner.send(ClangFormatConfigurationRequest.createPromise(formatConfigurationRequest));
        return formatConfigurationRequest.getResponse();
    }

    @Nullable
    private ClangDumpTokensRequest sendDumpTokens(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file2, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file2, offset);
        if (params == null) {
            return null;
        }
        ClangDumpTokensRequest request = new ClangDumpTokensRequest(reparse.getUrl(), params);
        this.myRequestsPlanner.send(ClangDumpTokensRequest.createPromise(this.myContext, request));
        return request;
    }

    @NotNull
    private static FormattingOptions buildFormattingOptions(@Nullable String style) {
        FormattingOptions options2 = new FormattingOptions(4, true);
        if (style != null) {
            options2.putString("style", "#yaml\n" + style);
        }
        return options2;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendFormatRangeRequest(@NotNull VirtualFile file2, @NotNull TextRange range, @Nullable String style) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file2);
        if (document2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(ClangdLanguageService.vfs2fileUriTransform(this.myContext.getUrlConverter()::toUri, file2.getUrl()));
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams(new Range(ClangLanguageServiceUtils.offset2LspPos(document2, range.getStartOffset()), ClangLanguageServiceUtils.offset2LspPos(document2, range.getEndOffset())));
        params.setTextDocument(identifier);
        FormattingOptions options2 = ClangdLanguageService.buildFormattingOptions(style);
        options2.putString("code", document2.getText());
        params.setOptions(options2);
        ClangFormatRangeRequest request = new ClangFormatRangeRequest(file2.getUrl(), params);
        this.myRequestsPlanner.send(ClangFormatRangeRequest.createPromise(request));
        return request.getResponse();
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendIndentRequest(@NotNull VirtualFile file2, int lineStartOffset, @Nullable String style) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file2);
        if (document2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(ClangdLanguageService.vfs2fileUriTransform(this.myContext.getUrlConverter()::toUri, file2.getUrl()));
        DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(ClangLanguageServiceUtils.offset2LspPos(document2, lineStartOffset), "\n");
        params.setTextDocument(identifier);
        FormattingOptions options2 = ClangdLanguageService.buildFormattingOptions(style);
        options2.putString("code", document2.getText());
        params.setOptions(options2);
        ClangIndentRequest request = new ClangIndentRequest(file2.getUrl(), params);
        this.myRequestsPlanner.send(ClangIndentRequest.createPromise(request));
        return request.getResponse();
    }

    @Nullable
    private ClangCompletionRequest sendRequestComplete(@NotNull VirtualFile file2, int offset, @NotNull CompletionTriggerKind kind) {
        CompletionParams params = this.toCompletionParams(file2, offset);
        if (params == null) {
            return null;
        }
        CompletionContext context2 = new CompletionContext();
        context2.setTriggerKind(kind);
        params.setContext(context2);
        ClangCompletionRequest request = new ClangCompletionRequest(file2.getUrl(), params);
        this.myRequestsPlanner.send(ClangCompletionRequest.createPromise(this.myContext, request));
        return request;
    }

    @NotNull
    public static String vfs2fileUriTransform(@NotNull Function<? super String, String> baseToUri, @NotNull String urlOrPath) {
        if (urlOrPath.startsWith("mock://")) {
            if (urlOrPath.startsWith("mock:///")) {
                return urlOrPath.replace("mock:///", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
            }
            return urlOrPath.replace("mock://", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
        }
        return baseToUri.apply(urlOrPath);
    }

    @NotNull
    @Contract(pure=true)
    private static String getMockUriRootWithProtocolAndTailBackslash() {
        return SystemInfo.isWindows ? "file:///X:/cidr_memory_mapped_mock/" : "file:///cidr_memory_mapped_mock/";
    }

    @Nullable
    private Pair<TextDocumentIdentifier, Position> textDocumentPositionParams(@NotNull VirtualFile file2, int offset) {
        return this.findLine(file2, offset, (text, lineColumn) -> Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file2.getUrl())), (Object)new Position(lineColumn.line, lineColumn.column)));
    }

    private <R> R findLine(@NotNull VirtualFile file2, int offset, @NotNull BiFunction<CharSequence, LineColumn, R> lineConsumer) {
        assert (offset >= 0) : "Why offset < 0?";
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file2);
        if (document2 == null) {
            return null;
        }
        if (file2 instanceof OCFragmentVirtualFile) {
            String fragmentText = this.myIdeFacade.getText(file2, document2);
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)fragmentText, (int)offset);
            if (lineColumn == null) {
                return null;
            }
            return lineConsumer.apply(fragmentText, lineColumn);
        }
        if (offset > document2.getTextLength()) {
            return null;
        }
        int line = document2.getLineNumber(offset);
        int column = offset - document2.getLineStartOffset(line);
        return lineConsumer.apply(document2.getCharsSequence(), LineColumn.of((int)line, (int)column));
    }

    @Nullable
    private TextDocumentPositionParams toTextDocumentPositionParams(@NotNull VirtualFile file2, int offset) {
        Pair<TextDocumentIdentifier, Position> params = this.textDocumentPositionParams(file2, offset);
        if (params == null) {
            return null;
        }
        return new TextDocumentPositionParams((TextDocumentIdentifier)params.first, (Position)params.second);
    }

    @Nullable
    private CompletionParams toCompletionParams(@NotNull VirtualFile file2, int offset) {
        Pair<TextDocumentIdentifier, Position> params = this.textDocumentPositionParams(file2, offset);
        if (params == null) {
            return null;
        }
        return new CompletionParams((TextDocumentIdentifier)params.first, (Position)params.second);
    }

    private boolean isAcceptable(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!this.myContext.getUrlConverter().isAcceptable(file2.getUrl())) {
            return false;
        }
        return OCLanguageUtils.isSupported(file2.getFileType());
    }

    private void sendContent(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile virtFile) {
        String fileText = this.myIdeFacade.getText(virtFile);
        if (fileText != null) {
            int nextVersion = wf.nextChange();
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(fileText);
            VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
            id.setUri(this.myContext.getUrlConverter().toUri(wf.getUrl()));
            id.setVersion(Integer.valueOf(nextVersion));
            this.myRequestsPlanner.send(ClangChangeNotification.createPromise(this.myContext, wf.getUrl(), nextVersion, new DidChangeTextDocumentParams(id, Collections.singletonList(changeEvent)), false));
        }
    }

    private static class UsagesInfo {
        @NotNull
        final Map<Integer, Exception> id2Stack = new HashMap<Integer, Exception>(12);
        int nextID = 0;

        private UsagesInfo() {
        }
    }

    private static final class GotoDefinitionKey {
        @NotNull
        private final String myUrl;
        private final int myFileVersion;
        private final int myOffset;

        private GotoDefinitionKey(@NotNull ClangParseResponse file2, int offset) {
            this.myUrl = file2.getUrl();
            this.myFileVersion = file2.getVersion();
            this.myOffset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GotoDefinitionKey key = (GotoDefinitionKey)o;
            return Objects.equals(this.myUrl, key.myUrl) && this.myOffset == key.myOffset && this.myFileVersion == key.myFileVersion;
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myFileVersion, this.myOffset);
        }
    }
}

