/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilterImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ObfuscatorImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDaemonContextImpl
implements ClangDaemonContext {
    private static final Logger LOG = Logger.getInstance((String)ClangDaemonContextImpl.class.getName());
    private final boolean myIsCustomClangdUsed;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final ClangdSettings mySettings;
    @NotNull
    private final MessageBus myMessageBus;
    private final boolean myOwnMessageBus;
    @NotNull
    private final ClangLocalWorkspace myLocalWorkspace;
    @NotNull
    private final ClangRemoteWorkspace myRemoteWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ServerConnectionProvider myServerConnectionProvider;
    @NotNull
    private final ClangClientServerProvider myClientServerProvider;
    @NotNull
    private final ClangServerAccessorProvider myServerAccessorProvider;
    @NotNull
    private final Supplier<Obfuscator> myObfuscatorProvider;
    @NotNull
    private final ClangCrashHandler myGuard;
    @NotNull
    private final ClangTelemetry myTelemetry;
    @NotNull
    private final ClangUrlConverter myUrlConverter;
    @NotNull
    private final Charset myProtocolCharset;
    @NotNull
    private final ClangMessagesFilter myMessagesFilter;
    private volatile boolean isStopped = false;

    public ClangDaemonContextImpl(boolean isCustomClangd, @NotNull String descriptor, @NotNull Project project2, @NotNull ClangdSettings settings, @NotNull ServerConnectionProvider serverConnectionProvider, @NotNull ClangClientServerProvider clientServerProvider, @NotNull ClangServerAccessorProvider serverAccessorProvider, @NotNull Supplier<Obfuscator> obfuscatorProvider, @NotNull ClangUrlConverter converter, @NotNull ClangIdeFacade facade, @Nullable MessageBus messageBus) {
        this.myDescriptor = descriptor;
        this.myIsCustomClangdUsed = isCustomClangd;
        this.myProject = project2;
        this.mySettings = settings;
        this.myServerConnectionProvider = serverConnectionProvider;
        this.myClientServerProvider = clientServerProvider;
        this.myServerAccessorProvider = serverAccessorProvider;
        this.myObfuscatorProvider = obfuscatorProvider;
        this.myUrlConverter = converter;
        this.myIdeFacade = facade;
        this.myMessageBus = messageBus != null ? messageBus : ClangDaemonContextImpl.createDefaultMessageBus(this);
        this.myOwnMessageBus = messageBus == null;
        this.myLocalWorkspace = new ClangLocalWorkspaceImpl(converter);
        this.myRemoteWorkspace = new ClangRemoteWorkspaceImpl();
        this.myGuard = new ClangCrashHandler(this);
        this.myTelemetry = new ClangTelemetry(this);
        this.myProtocolCharset = StandardCharsets.UTF_8;
        this.myMessagesFilter = new ClangMessagesFilterImpl(this);
    }

    @Override
    public boolean isCustomClangdUsed() {
        return this.myIsCustomClangdUsed;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ClangdSettings getSettings() {
        return this.mySettings;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        return this.myLocalWorkspace;
    }

    @Override
    @NotNull
    public ClangRemoteWorkspace getRemoteWorkspace() {
        return this.myRemoteWorkspace;
    }

    @Override
    @NotNull
    public ClangIdeFacade getIdeFacade() {
        return this.myIdeFacade;
    }

    @Override
    @NotNull
    public ServerConnectionProvider getConnectionProvider() {
        return this.myServerConnectionProvider;
    }

    @Override
    @NotNull
    public ClangClientServerProvider getClientServerProvider() {
        return this.myClientServerProvider;
    }

    @Override
    @NotNull
    public ClangServerAccessorProvider getServerAccessorProvider() {
        return this.myServerAccessorProvider;
    }

    @Override
    @NotNull
    public ClangCrashHandler getCrashHandler() {
        return this.myGuard;
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myTelemetry;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        return this.myUrlConverter;
    }

    @Override
    @NotNull
    public Charset getProtocolCharset() {
        return this.myProtocolCharset;
    }

    @Override
    @NotNull
    public ClangMessagesFilter getMessagesFilter() {
        return this.myMessagesFilter;
    }

    @Override
    @NotNull
    public Obfuscator createObfuscator() {
        return this.myObfuscatorProvider.get();
    }

    @Override
    public boolean shouldStartServerImmediately() {
        return this.myProject.getUserData(START_SERVER_IMMEDIATELY) != null;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public boolean canPublishMessage() {
        return !this.isStopped && !this.myMessageBus.isDisposed();
    }

    public void dispose() {
        this.isStopped = true;
        this.myIdeFacade.stop();
        if (this.myOwnMessageBus) {
            Disposer.dispose((Disposable)this.myMessageBus);
        }
    }

    @NotNull
    private static MessageBus createDefaultMessageBus(final @NotNull ClangDaemonContext context2) {
        return MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor) {
                throw new UnsupportedOperationException("Not supported.");
            }

            public boolean isDisposed() {
                return context2.isStopped();
            }
        });
    }

    public static class Builder {
        @NotNull
        private final String myDescriptor;
        @NotNull
        private final Project myProject;
        @Nullable
        private ClangdSettings mySettings;
        @Nullable
        private ClangIdeFacade myFacade;
        @Nullable
        private ClangUrlConverter myConverter;
        @Nullable
        private File myClangdPath;
        @Nullable
        private MessageBus myMessageBus;
        private boolean myIsCustomClangdPath = false;

        public Builder(@NotNull String descriptor, @NotNull Project project2) {
            this.myDescriptor = descriptor;
            this.myProject = project2;
            this.mySettings = ClangdSettings.getInstance(project2);
        }

        @NotNull
        public Builder setSettings(@NotNull ClangdSettings settings) {
            this.mySettings = settings;
            return this;
        }

        @NotNull
        public Builder setIdeFacade(@NotNull ClangIdeFacade facade) {
            this.myFacade = facade;
            return this;
        }

        @NotNull
        public Builder setUrlConverter(@NotNull ClangUrlConverter converter) {
            this.myConverter = converter;
            return this;
        }

        @NotNull
        public Builder setClangdPath(@NotNull File clangdPath) {
            this.myClangdPath = clangdPath;
            this.myIsCustomClangdPath = true;
            return this;
        }

        @NotNull
        public Builder setMessageBus(@NotNull MessageBus messageBus) {
            this.myMessageBus = messageBus;
            return this;
        }

        @NotNull
        public ClangDaemonContextImpl create() {
            File clangdPath = this.getClangdPath();
            LOG.info("Using clangd from: " + clangdPath);
            ProcessServerConnectionProvider connectionProvider = new ProcessServerConnectionProvider(this.myProject, clangdPath.getAbsolutePath());
            ClangClientServerProviderImpl clientServerProvider = new ClangClientServerProviderImpl();
            ClangServerAccessorProviderImpl serverAccessorProvider = new ClangServerAccessorProviderImpl();
            Supplier<Obfuscator> obfuscatorProvider = () -> new ObfuscatorImpl();
            return new ClangDaemonContextImpl(this.myIsCustomClangdPath, this.myDescriptor, this.myProject, this.getSettings(), connectionProvider, clientServerProvider, serverAccessorProvider, obfuscatorProvider, this.getUrlConverter(), this.getIdeFacade(), this.getMessageBus());
        }

        @NotNull
        private ClangIdeFacade getIdeFacade() {
            if (this.myFacade != null) {
                return this.myFacade;
            }
            ClangIdeFacade facade = (ClangIdeFacade)this.myProject.getUserData(ClangDaemonContext.IDE_FACADE_KEY);
            if (facade == null) {
                facade = new ClangIdeFacadeImpl(this.myDescriptor);
            }
            return facade;
        }

        @NotNull
        private ClangdSettings getSettings() {
            if (this.mySettings != null) {
                return this.mySettings;
            }
            return ClangdSettings.getInstance(this.myProject);
        }

        @NotNull
        private ClangUrlConverter getUrlConverter() {
            if (this.myConverter != null) {
                return this.myConverter;
            }
            ClangUrlConverter urlConverter = (ClangUrlConverter)this.myProject.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            return urlConverter != null ? urlConverter : new ClangUrlConverter();
        }

        @NotNull
        private File getClangdPath() {
            if (this.myClangdPath != null) {
                return this.myClangdPath;
            }
            Pair<File, Boolean> pathAndIsCustom = ClangUtils.getClangdPath();
            this.myIsCustomClangdPath = (Boolean)pathAndIsCustom.second;
            return (File)pathAndIsCustom.first;
        }

        @Nullable
        private MessageBus getMessageBus() {
            return this.myMessageBus;
        }
    }
}

