/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class CLionCompletionItem
extends CompletionItem {
    private int clionFlags;
    private String fromFile;
    private Position fromFilePosition;

    public int getCLionFlags() {
        return this.clionFlags;
    }

    public void setCLionFlags(int flags) {
        this.clionFlags = flags;
    }

    public String getFromFile() {
        return this.fromFile;
    }

    public void setFromFile(String file2) {
        this.fromFile = file2;
    }

    public Position getFromFilePosition() {
        return this.fromFilePosition;
    }

    public void setFromFilePosition(Position pos) {
        this.fromFilePosition = pos;
    }

    public PsiElement toPsiElement(Project project2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.fromFile == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)this.fromFile));
        if (virtualFile == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document document2 = PsiDocumentManager.getInstance((Project)psiManager.getProject()).getDocument(psiFile);
        if (document2 == null) {
            return null;
        }
        if (document2.getLineCount() <= this.fromFilePosition.getLine()) {
            return null;
        }
        return ClangResolveUtils.findAppropriateElement(psiFile, document2.getLineStartOffset(this.fromFilePosition.getLine()) + this.fromFilePosition.getCharacter());
    }
}

