/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangErrorsAnnotatorSlowPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorSlowPassFactory.class.getName());
    private final int myPassId;
    private final int myClangErrorsPassId;

    public ClangErrorsAnnotatorSlowPassFactory(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar, int clangErrorsPassId) {
        if (clangErrorsPassId != -1) {
            this.myPassId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{clangErrorsPassId}, null, false, -1);
            this.myClangErrorsPassId = clangErrorsPassId;
        } else {
            this.myPassId = -1;
            this.myClangErrorsPassId = -1;
            LOG.error("Failed to register post clang errors pass because main clang errors pass is missing!");
        }
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (!OCLanguageUtils.isSupported(file2)) {
            return null;
        }
        TextRange dirtyRange = FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId);
        if (dirtyRange == null) {
            return null;
        }
        return new ClangErrorsAnnotatorSlowPass(file2, editor.getDocument(), dirtyRange, this.myClangErrorsPassId);
    }

    public void dispose() {
    }
}

