/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangResolveUtils {
    public static final Key<Object> CLANG_CAN_OPEN_FILE = Key.create((String)"ClangCanOpenFileOnResolve");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileIfOpenedForResolve");
    private static final long CLANG_RESPONSE_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : Long.MAX_VALUE;
    private static final ThreadLocal<Integer> ourResolveProhibited = ThreadLocal.withInitial(() -> 0);
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ClangResolveUtils.class.getName());
    private static final Key<CachedValue<Map<Integer, List<Resolved>>>> TEST_CLANG_RESOLVE_CACHE = Key.create((String)"TEST_CLANG_RESOLVE_CACHE");

    public static void prohibitClangResolve() {
        assert (ourResolveProhibited.get() >= 0) : "Unbalanced prohibitClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() + 1);
    }

    public static void allowClangResolve() {
        assert (ourResolveProhibited.get() > 0) : "Unbalanced allowClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() - 1);
    }

    @Nullable
    public static List<OCSymbol> findTargetSymbolsViaClang(@NotNull PsiReference ref) {
        List<Resolved> clangSymbols = ClangResolveUtils.findSymbolsViaClang(ref);
        return clangSymbols != null ? ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static OCSymbol findTargetSymbolViaClang(@NotNull PsiReference ref) {
        List<Resolved> clangSymbols = ClangResolveUtils.findSymbolsViaClang(ref);
        return clangSymbols != null ? ClangResolveUtils.chooseBestSymbol(clangSymbols, ref) : null;
    }

    public static <T> T findCombined(@NotNull PsiReference ref, @NotNull Function<PsiReference, T> clangResolver, @NotNull Function<PsiReference, T> clionResolver) {
        T clangResult;
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isWriteAccessAllowed() && ClangResolveUtils.canResolveViaClang(ref)) {
            ClangParseResponse parsedFile;
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(ref.getElement().getProject());
            VirtualFile file2 = ClangResolveUtils.getRefFile(ref);
            if (!(file2 == null || (parsedFile = service.getParsed(file2)) != null && ClangParseResponse.didAnswersCome(parsedFile))) {
                return ClangResolveUtils.findInParallel(ref, clangResolver, clionResolver);
            }
        }
        if ((clangResult = clangResolver.apply(ref)) != null) {
            return clangResult;
        }
        return clionResolver.apply(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T findInParallel(@NotNull PsiReference ref, @NotNull Function<PsiReference, T> clangResolver, @NotNull Function<PsiReference, T> clionResolver) {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Finding in parallel: " + ref.getCanonicalText());
            }
            CompletableFuture<Object> clangResolvedFuture = ClangResolveUtils.offEDT(() -> clangResolver.apply(ref), (ProgressIndicator)indicator);
            CompletableFuture<Object> clionResolveFuture = ClangResolveUtils.offEDT(() -> clionResolver.apply(ref), (ProgressIndicator)indicator);
            try {
                ClangUtils.waitCancelAware(clangResolvedFuture, 15L, "clionDefinition answer");
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            try {
                ClangUtils.waitCancelAware(CompletableFuture.anyOf(clangResolvedFuture, clionResolveFuture), Long.MAX_VALUE, "clionDefinition or clion resolve");
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            Object clangResult = ClangUtils.getIfCompletedNormally(clangResolvedFuture);
            if (clangResult != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Parellel: resolved via clangd: " + clangResult);
                }
                Object object = clangResult;
                return (T)object;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Parellel: resolving via CLion...");
            }
            Object object = ClangUtils.waitCancelAware(clionResolveFuture, Long.MAX_VALUE, "clion resolve");
            return (T)object;
        }
        finally {
            indicator.cancel();
        }
    }

    @Nullable
    private static List<Resolved> findSymbolsViaClang(@NotNull PsiReference ref) {
        if (!ClangResolveUtils.canResolveViaClang(ref)) {
            return null;
        }
        try {
            return ClangResolveUtils.tryFindSymbolsViaClang(ref);
        }
        catch (TimeoutException ex) {
            LOG.warn(ClangResolveUtils.toMessageWithRef(ex, ref));
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ClangResolveUtils.toMessageWithRef(ex, ref), ex);
        }
        catch (RuntimeException ex) {
            if (ex instanceof ControlFlowException) {
                throw ex;
            }
            LOG.error(ClangResolveUtils.toMessageWithRef(ex, ref), (Throwable)ex);
        }
        return null;
    }

    private static Predicate<OCSymbol> getSymbolsFilter(@NotNull PsiReference ref) {
        if (ref instanceof OCReferenceElement) {
            return sym -> sym != null && !(sym instanceof OCFunctionSymbol);
        }
        if (ref instanceof OCOperatorReference) {
            return sym -> sym instanceof OCFunctionSymbol && ((OCFunctionSymbol)sym).isCppOperator();
        }
        return sym -> true;
    }

    @Nullable
    private static OCSymbol chooseBestSymbol(@NotNull List<Resolved> clangSymbols, @NotNull PsiReference ref) {
        Optional<OCSymbol> firstOperatorOrNone;
        if (ref instanceof OCReferenceElement) {
            Optional<OCSymbol> firstSymOrNone = ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).findFirst();
            if (firstSymOrNone.isPresent()) {
                OCClassSymbol definitionSymbolSymbol;
                OCInterfaceSymbol interfaceSymbol;
                OCSymbol firstSymbol = firstSymOrNone.get();
                if (firstSymbol instanceof OCStructSymbol) {
                    OCSymbol ctor = ClangResolveUtils.runClionOverloadResolutionForStruct((OCReferenceElement)ref, (OCStructSymbol)firstSymbol);
                    if (ctor != null) {
                        return ctor;
                    }
                } else if (firstSymbol instanceof OCInterfaceSymbol && (interfaceSymbol = (OCInterfaceSymbol)firstSymbol).isPredeclaration() && (definitionSymbolSymbol = interfaceSymbol.getDefinitionSymbol(((OCReferenceElement)ref).getProject())) != null) {
                    return definitionSymbolSymbol;
                }
                return firstSymbol;
            }
        } else if (ref instanceof OCOperatorReference && (firstOperatorOrNone = ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).findFirst()).isPresent()) {
            return firstOperatorOrNone.get();
        }
        return ClangResolveUtils.toSymbolStream(clangSymbols).filter(sym -> sym != null).findFirst().orElse(null);
    }

    @NotNull
    private static Stream<OCSymbol> toSymbolStream(@NotNull List<Resolved> clangSymbols) {
        return clangSymbols.stream().filter(resolved -> resolved.element instanceof OCSymbolDeclarator).map(resolved -> ((OCSymbolDeclarator)resolved.element).getSymbol());
    }

    public static void assertClangResolvesSameSymbol(@NotNull Project project2, @Nullable OCSymbol clangSymbol, @NotNull Supplier<OCSymbol> clionResolver) {
    }

    public static void assertClangResolvesSameElement(@Nullable PsiElement clangElement, @NotNull Supplier<PsiElement> clionResolver) {
    }

    private static boolean canResolveViaClang(@NotNull PsiReference ref) {
        Project project2 = ref.getElement().getProject();
        if (PlatformUtils.isAppCode()) {
            return false;
        }
        int resolveProhibitedValue = ourResolveProhibited.get();
        if (resolveProhibitedValue > 0) {
            LOG.error("Clang resolving is prohibited!");
            return false;
        }
        assert (resolveProhibitedValue == 0) : "Unexpected resolve prohibited value";
        if (!ClangUtils.isClangdOn(project2)) {
            return false;
        }
        if (!ClangUtils.isNavigationViaClangd(project2)) {
            return false;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        return !OCElementUtil.isPartOfMacroSubstitution(ref.getElement());
    }

    @Nullable
    private static List<Resolved> tryFindSymbolsViaClang(@NotNull PsiReference ref) throws ExecutionException, TimeoutException {
        List<Resolved> result3;
        ClangLocalWorkspace workspace;
        CachedValueProvider provider2;
        CachedValuesManager manager2;
        PsiElement refElement = ref.getElement();
        PsiFile file2 = refElement.getContainingFile();
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = ClangResolveUtils.getRefFile(ref);
        if (virtualFile == null) {
            return null;
        }
        String requestFileUrl = virtualFile.getUrl();
        Project project2 = ref.getElement().getProject();
        int offset = ref.getRangeInElement().getStartOffset() + refElement.getTextOffset();
        Map cache = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (cache = (Map)(manager2 = CachedValuesManager.getManager((Project)project2)).getCachedValue((UserDataHolder)file2, TEST_CLANG_RESOLVE_CACHE, provider2 = () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).containsKey(offset)) {
            return (List)cache.get(offset);
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(refElement.getProject());
        SimpleOpenRequestId openRequestId = null;
        if (CLANG_CAN_OPEN_FILE.get((UserDataHolder)refElement.getProject()) != null && (workspace = service.getLocalWorkspace()) != null && !workspace.apply(virtualFile.getUrl(), wf -> wf.isOpened()).booleanValue()) {
            openRequestId = new SimpleOpenRequestId(ClangResolveUtils.class, "Opened [" + virtualFile.getPath() + "]");
            service.notifyDocumentOpened(virtualFile, openRequestId);
        }
        Ref clangSymsRef = Ref.create();
        try {
            service.gotoDefinition(virtualFile, offset, result2 -> clangSymsRef.set(result2.waitForResult(CLANG_RESPONSE_TIMEOUT_MS)));
        }
        catch (ExecutionException | TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrow((Throwable)ex);
        }
        List clangSyms = (List)clangSymsRef.get();
        if (openRequestId != null && CLANG_DONT_CLOSE_FILE.get((UserDataHolder)project2) == null) {
            service.notifyDocumentClosed(virtualFile, openRequestId);
        }
        List<Resolved> list = result3 = !ContainerUtil.isEmpty((Collection)clangSyms) ? clangSyms.stream().filter(ClangResolveUtils::isTrusted).map(sym -> ClangResolveUtils.toResolved(project2, sym, requestFileUrl)).collect(Collectors.toList()) : Collections.emptyList();
        if (cache != null) {
            cache.put(offset, result3);
        }
        return result3;
    }

    @Nullable
    private static VirtualFile getRefFile(@NotNull PsiReference ref) {
        PsiElement refElement = ref.getElement();
        PsiFile file2 = refElement.getContainingFile();
        if (file2 == null) {
            return null;
        }
        return file2.getViewProvider().getVirtualFile();
    }

    private static boolean isTrusted(@NotNull ClangSym sym) {
        return !sym.isMacro;
    }

    @NotNull
    private static Resolved toResolved(@NotNull Project project2, @NotNull ClangSym sym, @NotNull String requestFileUrl) {
        SourceLocation sourceLocation = sym.location;
        int protocolSepIndex = sourceLocation.url.indexOf("://");
        String path = sourceLocation.url.substring(protocolSepIndex + "://".length());
        VirtualFile targetVirtualFile = ClangResolveUtils.findBestFile(project2, path, sourceLocation.position.getLine());
        if (targetVirtualFile == null) {
            return new Resolved(sym, null);
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(targetVirtualFile);
        if (document2 == null) {
            return new Resolved(sym, null);
        }
        PsiFile targetPsiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (targetPsiFile == null) {
            return new Resolved(sym, null);
        }
        if (sourceLocation.position.getLine() >= document2.getLineCount()) {
            StringBuilder message = new StringBuilder("Requested line ").append(sourceLocation.position.getLine()).append(" of ").append(document2.getLineCount()).append(" in ").append(targetVirtualFile.getUrl()).append(" when looking for resolved ").append(sym);
            message.append("; ");
            message.append("request file was ").append(requestFileUrl);
            throw new IndexOutOfBoundsException(message.toString());
        }
        int offset = sourceLocation.position.getOffset(document2);
        return new Resolved(sym, ClangResolveUtils.findAppropriateElement(targetPsiFile, offset));
    }

    @Nullable
    public static PsiElement findAppropriateElement(@NotNull PsiFile file2, int offset) {
        PsiElement clangElement = file2.findElementAt(offset);
        if (clangElement == null) {
            return null;
        }
        if (clangElement instanceof OCSymbolDeclarator) {
            return clangElement;
        }
        if (clangElement.getParent() instanceof OCSymbolDeclarator) {
            return clangElement.getParent();
        }
        return clangElement;
    }

    @Nullable
    private static OCSymbol runClionOverloadResolutionForStruct(@NotNull OCReferenceElement referenceElement, @NotNull OCStructSymbol clangSymbol) {
        Ref argumentsRef;
        Ref argsRef;
        OCStructType type = new OCStructType(clangSymbol);
        if (type.isEnum() || type.isEnumClass()) {
            return null;
        }
        OCResolveContext context2 = OCResolveContext.forPsi(referenceElement);
        if (!OCReferenceElementImpl.findArgumentsFromContext(referenceElement, context2, (Ref<List<OCExpression>>)(argsRef = Ref.create()), (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
            return null;
        }
        return OCReferenceElementImpl.resolveToConstructors(referenceElement, Collections.singleton(clangSymbol), type, (OCArgumentsList)argumentsRef.get(), context2);
    }

    @NotNull
    private static String toMessageWithRef(@NotNull Throwable original, @NotNull PsiReference ref) {
        try {
            PsiElement element = ref.getElement();
            PsiFile file2 = element.getContainingFile();
            return "When resolving " + OCElementUtil.getElementDebugName(element) + " at " + file2.getName() + ":" + (element.getTextOffset() + ref.getRangeInElement().getStartOffset()) + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            return original.getMessage();
        }
    }

    @NotNull
    private static <T> CompletableFuture<T> offEDT(@NotNull Supplier<T> task2, @NotNull ProgressIndicator indicator) {
        CompletableFuture result2 = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> ClangResolveUtils.lambda$null$14(result2, (Supplier)task2), indicator));
        return result2;
    }

    @Nullable
    public static VirtualFile findBestFile(@NotNull Project project2, @NotNull String path, int requestedLine) {
        Document document2;
        VirtualFile file2;
        long targetStamp = 0L;
        VirtualFile targetVirtualFile = null;
        for (VirtualFile file3 : LocalFileSystem.getInstance().findCachedFilesForPath(path)) {
            Document document3;
            if (!OCSearchScope.isInProjectSourcesOrLibraries(project2, file3) || (document3 = FileDocumentManager.getInstance().getDocument(file3)) == null || requestedLine >= document3.getLineCount()) continue;
            if (targetVirtualFile == null) {
                targetVirtualFile = file3;
                targetStamp = document3.getModificationStamp();
                continue;
            }
            long curStamp = document3.getModificationStamp();
            if (curStamp <= targetStamp) continue;
            targetVirtualFile = file3;
            targetStamp = curStamp;
        }
        if (targetVirtualFile == null && (file2 = VfsUtil.findFile((Path)new File(path).toPath(), (boolean)false)) != null && (document2 = FileDocumentManager.getInstance().getDocument(file2)) != null && requestedLine < document2.getLineCount()) {
            targetVirtualFile = file2;
        }
        return targetVirtualFile;
    }

    private static /* synthetic */ void lambda$null$14(CompletableFuture result2, Supplier task2) {
        ReadAction.run(() -> ClangResolveUtils.lambda$null$13(result2, (Supplier)task2));
    }

    private static /* synthetic */ void lambda$null$13(CompletableFuture result2, Supplier task2) throws RuntimeException {
        try {
            ProgressManager.checkCanceled();
            result2.complete(task2.get());
        }
        catch (Throwable thr) {
            result2.completeExceptionally(thr);
        }
    }

    public static class Resolved {
        @NotNull
        final ClangSym sym;
        @Nullable
        final PsiElement element;

        private Resolved(@NotNull ClangSym sym, @Nullable PsiElement element) {
            this.sym = sym;
            this.element = element;
        }

        public String toString() {
            return "Resolved[" + this.sym.name + ", " + (this.element != null ? Integer.valueOf(this.element.getTextOffset()) : "<invalid>") + "]";
        }
    }
}

