/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.strings.OCStringsFileType;
import icons.CidrLangIcons;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class OCNewStringsFileAction
extends OCNewFileActionBase {
    private static final String STRINGS_TEMPLATE_NAME = "Strings File.strings";
    private static final String CONTENTS_PROPERTY = "CONTENTS";
    private String myTableName;
    private String myContent;

    public OCNewStringsFileAction(String tableName, String content) {
        super((FileType)OCStringsFileType.INSTANCE, OCBundle.message("create.strings.title", new Object[0]), OCBundle.message("create.strings.description", new Object[0]), CidrLangIcons.CodeAssistantGlobal);
        this.myTableName = tableName;
        this.myContent = content;
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        return this.myTableName;
    }

    @Override
    protected String getFileTemplate(String fileName) {
        return STRINGS_TEMPLATE_NAME;
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        properties.setProperty(CONTENTS_PROPERTY, this.myContent);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + '.' + OCStringsFileType.INSTANCE.getDefaultExtension(), null);
    }

    @NotNull
    protected OCNewFileActionBase.CreateFileDialogBase createDialog(@NotNull String defaultName) {
        return new CreateStringsFileDialog(defaultName);
    }

    protected boolean isNameFieldEnabled() {
        return true;
    }

    protected class CreateStringsFileDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateStringsFileDialog(String defaultName) {
            super(OCBundle.message("create.strings.dialog.title", new Object[0]), defaultName, null);
        }

        @Override
        protected boolean isNameFieldEnabled() {
            return OCNewStringsFileAction.this.isNameFieldEnabled();
        }
    }
}

