/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewHeaderFileAction
extends OCNewFileWithSelectedExtensionAction<MyCreateFileDialog> {
    public OCNewHeaderFileAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.header.title", new Object[0]), OCBundle.message("create.cpp.header.title", new Object[0]), CidrLangIcons.FileTypes.H);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        Pair<String, OCCodeStyleSettings.FileExtensionPair> nameAndExtension = this.determineNameAndExtension(selectedName, true);
        return new OCNewFileActionBase.NewFileNames(null, (String)nameAndExtension.first + "." + ((OCCodeStyleSettings.FileExtensionPair)nameAndExtension.second).myHeaderExt);
    }

    @Override
    @Nullable
    protected String getFileTemplate(String fileName) {
        return OCNewHeaderFileAction.headerTemplate();
    }

    @NotNull
    public static String headerTemplate() {
        return "C Header File.h";
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (StringUtil.isEmpty((String)FileUtilRt.getNameWithoutExtension((String)selectedName))) {
            return false;
        }
        String headerName = this.getNewFileNames(selectedName).getHeaderName();
        return headerName != null && super.isValidName(headerName) && !FileUtilRt.getExtension((String)headerName).isEmpty() && OCFileImpl.isHeaderFile(headerName);
    }

    @Override
    @NotNull
    protected MyCreateFileDialog createDialog(@NotNull String defaultName) {
        return new MyCreateFileDialog(defaultName);
    }

    protected class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        MyCreateFileDialog(String defaultName) {
            super(defaultName);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            return "." + pair.myHeaderExt;
        }
    }
}

