/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.light.OCLightFileType;
import com.jetbrains.cidr.lang.light.OCSlowLanguage;
import com.jetbrains.cidr.lang.light.psi.OCLightFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageUtils {
    private OCLanguageUtils() {
    }

    private static boolean isLightPsiOn() {
        return false;
    }

    private static boolean assertLightPsiOn(@Nullable Object message) {
        return OCLog.LOG.assertTrue(OCLanguageUtils.isLightPsiOn(), message);
    }

    @NotNull
    public static Language getConfigLanguage() {
        return OCLanguage.getInstance();
    }

    @NotNull
    public static Language getLightLanguage() {
        return OCLanguage.getInstance();
    }

    @NotNull
    public static Language getSlowLanguage() {
        return OCLanguageUtils.isLightPsiOn() ? OCSlowLanguage.getInstance() : OCLanguage.getInstance();
    }

    @NotNull
    public static FileType getBaseFileType() {
        return OCLanguageUtils.isLightPsiOn() ? OCLightFileType.INSTANCE : OCFileType.INSTANCE;
    }

    public static boolean isSupported(@Nullable Language language) {
        return language == OCLanguageUtils.getSlowLanguage() || language == OCLanguageUtils.getLightLanguage();
    }

    @Contract(value="null -> false")
    public static boolean isSupported(@Nullable PsiFile file2) {
        return file2 instanceof OCFile || file2 instanceof OCLightFile && OCLanguageUtils.assertLightPsiOn(file2);
    }

    public static boolean isSupported(@NotNull VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        return fileTypeManager.isFileOfType(virtualFile, (FileType)OCFileType.INSTANCE) || fileTypeManager.isFileOfType(virtualFile, (FileType)OCLightFileType.INSTANCE) && OCLanguageUtils.assertLightPsiOn(virtualFile);
    }

    public static boolean isSupported(@NotNull FileType fileType) {
        return fileType == OCFileType.INSTANCE || fileType == OCLightFileType.INSTANCE && OCLanguageUtils.assertLightPsiOn(fileType);
    }

    @Contract(value="null -> null")
    public static OCPsiFile asOCPsiFile(@Nullable PsiFile file2) {
        if (file2 instanceof OCPsiFile) {
            return (OCPsiFile)file2;
        }
        return null;
    }

    @Contract(value="_, null -> null")
    public static OCPsiFile asOCPsiFile(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return OCLanguageUtils.asOCPsiFile(PsiManager.getInstance((Project)project2).findFile(file2));
    }

    @Contract(value="null -> null")
    public static OCFile asOCFile(@Nullable PsiFile file2) {
        OCPsiFile opf = OCLanguageUtils.asOCPsiFile(file2);
        return opf == null ? null : opf.getOCFile();
    }

    @Contract(value="_, null -> null")
    public static OCFile asOCFile(@NotNull Project project2, @Nullable VirtualFile file2) {
        return OCLanguageUtils.asOCFile(OCLanguageUtils.asOCPsiFile(project2, file2));
    }

    @Contract(value="!null -> !null; null -> null")
    public static PsiFile tryGetOCFile(@Nullable PsiFile file2) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file2);
        return ocFile == null ? file2 : ocFile;
    }
}

