/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CidrBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<XBreakpointProperties>> {
    public CidrBreakpointHandler(CidrDebugProcess process2) {
        this(process2, (Class<? extends XLineBreakpointType<XBreakpointProperties>>)CidrLineBreakpointType.class);
    }

    public CidrBreakpointHandler(CidrDebugProcess process2, @NotNull Class<? extends XLineBreakpointType<XBreakpointProperties>> type) {
        super(process2, type);
    }

    @Override
    protected Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver driver, XLineBreakpoint<XBreakpointProperties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        LLBreakpoint result2;
        String condition = this.convertCondition((XBreakpoint<? extends XBreakpointProperties>)breakpoint);
        try {
            result2 = driver.addBreakpoint(VfsUtilCore.urlToPath((String)breakpoint.getFileUrl()), breakpoint.getLine(), condition);
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return Collections.emptyList();
        }
        this.updateBreakpointPresentation(breakpoint, result2);
        return Collections.singletonList(result2);
    }

    public void handleBreakpointAdded(@NotNull LLBreakpoint newBreakpoint) {
    }

    public void handleBreakpointRemoved(@NotNull XLineBreakpoint<XBreakpointProperties> uiBreakpoint) {
    }

    public void handleBreakpointUpdated(@NotNull XLineBreakpoint<XBreakpointProperties> uiBreakpoint, @NotNull LLBreakpoint newBreakpoint) {
        this.unregisterCodepointsMapping(uiBreakpoint);
        this.registerCodepointsMapping(uiBreakpoint, Collections.singletonList(newBreakpoint));
        this.updateBreakpointPresentation(uiBreakpoint, newBreakpoint);
    }

    private void updateBreakpointPresentation(@NotNull XLineBreakpoint<XBreakpointProperties> uiBreakpoint, @NotNull LLBreakpoint breakpoint) {
        if (!breakpoint.isPending()) {
            this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }
}

