/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtobufMessageFactory {
    private ProtobufMessageFactory() {
    }

    public static Protocol.CompositeRequest getChildrenCount(int id, int max) {
        return Protocol.CompositeRequest.newBuilder().setGetChildrenCount(Protocol.GetChildrenCount_Req.newBuilder().setId(id).setMaximum(max)).build();
    }

    public static GeneratedMessage kill() {
        return Protocol.CompositeRequest.newBuilder().setKill(Protocol.Kill_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest detach() {
        return Protocol.CompositeRequest.newBuilder().setDetach(Protocol.Detach_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest attach(int pid) {
        return Protocol.CompositeRequest.newBuilder().setAttach(ProtobufMessageFactory.newAttachBuilder(pid)).build();
    }

    public static Protocol.CompositeRequest remoteAttach(int pid, @NotNull String fdPassingServiceUnixSocket) {
        Protocol.Attach_Req.Builder builder2 = ProtobufMessageFactory.newAttachBuilder(pid).setFdPassingServiceUnixSocket(fdPassingServiceUnixSocket);
        return Protocol.CompositeRequest.newBuilder().setAttach(builder2).build();
    }

    private static Protocol.Attach_Req.Builder newAttachBuilder(int pid) {
        return Protocol.Attach_Req.newBuilder().setPid(pid);
    }

    public static GeneratedMessage attachByName(String name, boolean wait) {
        return Protocol.CompositeRequest.newBuilder().setAttachByName(Protocol.AttachByName_Req.newBuilder().setName(name).setToWait(wait)).build();
    }

    public static Protocol.CompositeRequest remoteLaunch(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, @NotNull String socket) {
        Protocol.RemoteLaunch_Req.Builder launchBuilder = ProtobufMessageFactory.createRemoteLaunchBuilder(localPath, targetCommandLine, socket);
        Protocol.CompositeRequest.Builder result2 = Protocol.CompositeRequest.newBuilder();
        result2.setRemoteLaunch(launchBuilder);
        return result2.build();
    }

    @NotNull
    public static Protocol.CompositeRequest createRemoteTarget(@NotNull String exePath, @Nullable String arch, @NotNull String platform, @Nullable String platformSdkRoot, @NotNull String remoteExePath) {
        Protocol.CreateTarget_Req.Builder builder2 = Protocol.CreateTarget_Req.newBuilder().setExePath(exePath).setPlatform(platform).setRemoteExePath(remoteExePath);
        if (arch != null) {
            builder2.setArch(arch);
        }
        if (platformSdkRoot != null) {
            builder2.setPlatformSdkRoot(platformSdkRoot);
        }
        return Protocol.CompositeRequest.newBuilder().setCreateTarget(builder2.build()).build();
    }

    @NotNull
    public static Protocol.CompositeRequest createRemoteTarget(@NotNull String exePath, @NotNull String platform, @NotNull String remoteExePath) {
        return ProtobufMessageFactory.createRemoteTarget(exePath, null, platform, null, remoteExePath);
    }

    public static Protocol.CompositeRequest suspend() {
        Protocol.Suspend_Req.Builder builder2 = Protocol.Suspend_Req.newBuilder();
        return Protocol.CompositeRequest.newBuilder().setSuspend(builder2).build();
    }

    public static Protocol.CompositeRequest removeBreakpoint(int id) {
        Protocol.RemoveBreakpoint_Req.Builder builder2 = Protocol.RemoveBreakpoint_Req.newBuilder().setId(id);
        return Protocol.CompositeRequest.newBuilder().setRemoveBreakpoint(builder2).build();
    }

    public static Protocol.CompositeRequest removeWatchpoint(int id) {
        Protocol.RemoveWatchpoint_Req.Builder builder2 = Protocol.RemoveWatchpoint_Req.newBuilder().setId(id);
        return Protocol.CompositeRequest.newBuilder().setRemoveWatchpoint(builder2).build();
    }

    public static Protocol.CompositeRequest addBreakpoint(String path, int line, @Nullable String condition) {
        Protocol.AddBreakpoint_Req.Builder builder2 = Protocol.AddBreakpoint_Req.newBuilder().setFile(path).setLine(line);
        if (condition != null) {
            builder2.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder2).build();
    }

    public static Protocol.CompositeRequest addBreakpoint(long addressULong, @Nullable String condition) {
        Protocol.AddBreakpoint_Req.Builder builder2 = Protocol.AddBreakpoint_Req.newBuilder().setAddress(addressULong);
        if (condition != null) {
            builder2.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder2).build();
    }

    @NotNull
    public static Protocol.CompositeRequest addBreakpoint(@NotNull String pattern, boolean regExpPattern, @Nullable String module2, @Nullable String condition, long threadId) {
        Protocol.AddBreakpoint_Req.Builder builder2 = Protocol.AddBreakpoint_Req.newBuilder().setSymbolPattern(pattern);
        builder2.setRegexp(regExpPattern);
        builder2.setThreadId((int)threadId);
        if (module2 != null) {
            builder2.setModuleName(module2);
        }
        if (condition != null) {
            builder2.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder2).build();
    }

    public static Protocol.CompositeRequest getThreads() {
        return Protocol.CompositeRequest.newBuilder().setGetThreads(Protocol.GetThreads_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) {
        return Protocol.CompositeRequest.newBuilder().setGetFrames(Protocol.GetFrames_Req.newBuilder().setThreadId((int)threadId).setFromIndex(from).setCount(count).setUntilValidLineEntry(untilFirstLineWithCode)).build();
    }

    public static Protocol.CompositeRequest exit() {
        return Protocol.CompositeRequest.newBuilder().setExit(Protocol.Exit_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest launch(GeneralCommandLine targetCommandLine, boolean useExternalConsole, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        Protocol.CompositeRequest.Builder result2 = Protocol.CompositeRequest.newBuilder();
        Protocol.Launch_Req.Builder launchBuilder = ProtobufMessageFactory.createLaunchBuilder(targetCommandLine.getExePath(), targetCommandLine, useExternalConsole, stdinPath, stdoutPath, stderrPath);
        result2.setLaunch(launchBuilder);
        return result2.build();
    }

    private static Model.CommandLine.Builder createCommandLineBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine) {
        Model.CommandLine.Builder cl = Model.CommandLine.newBuilder();
        cl.setExePath(localPath);
        File workDirectory = targetCommandLine.getWorkDirectory();
        if (workDirectory == null) {
            workDirectory = new File(localPath).getParentFile();
        }
        cl.setWorkingDir(workDirectory.getAbsolutePath());
        Map envParams = targetCommandLine.getEffectiveEnvironment();
        for (String env : envParams.keySet()) {
            cl.addEnv(Model.EnvParam.newBuilder().setName(env).setValue((String)envParams.get(env)));
        }
        for (String param : targetCommandLine.getParametersList().getArray()) {
            cl.addParam(param);
        }
        return cl;
    }

    private static Protocol.Launch_Req.Builder createLaunchBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, boolean useExternalConsole, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        Model.CommandLine.Builder cl = ProtobufMessageFactory.createCommandLineBuilder(localPath, targetCommandLine);
        if (stdinPath != null) {
            cl.setStdinPath(stdinPath);
        }
        if (stdoutPath != null) {
            cl.setStdoutPath(stdoutPath);
        }
        if (stderrPath != null) {
            cl.setStderrPath(stderrPath);
        }
        return Protocol.Launch_Req.newBuilder().setCommandLine(cl).setUseExternalConsole(useExternalConsole);
    }

    private static Protocol.RemoteLaunch_Req.Builder createRemoteLaunchBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, @NotNull String socket) {
        Model.CommandLine.Builder cl = ProtobufMessageFactory.createCommandLineBuilder(localPath, targetCommandLine);
        return Protocol.RemoteLaunch_Req.newBuilder().setCommandLine(cl).setFdPassingServiceUnixSocket(socket);
    }

    public static Protocol.CompositeRequest createTarget(String exePath, String arch) {
        Protocol.CreateTarget_Req.Builder builder2 = Protocol.CreateTarget_Req.newBuilder().setArch(arch).setExePath(exePath);
        return Protocol.CompositeRequest.newBuilder().setCreateTarget(builder2.build()).build();
    }

    public static Protocol.CompositeRequest connectPlatform(String platform, String url) {
        Protocol.ConnectPlatform_Req.Builder builder2 = Protocol.ConnectPlatform_Req.newBuilder().setPlatform(platform).setUrl(url);
        return Protocol.CompositeRequest.newBuilder().setConnectPlatform(builder2.build()).build();
    }

    public static Protocol.CompositeRequest connectProcess(String url, String plugin) {
        Protocol.ConnectProcess_Req.Builder builder2 = Protocol.ConnectProcess_Req.newBuilder().setUrl(url);
        if (plugin != null) {
            builder2.setPlugin(plugin);
        }
        return Protocol.CompositeRequest.newBuilder().setConnectProcess(builder2.build()).build();
    }

    public static Protocol.CompositeRequest executeShellCommand(String command, String workingDir, int timeoutSecs) {
        Protocol.ExecuteShellCommand_Req.Builder builder2 = Protocol.ExecuteShellCommand_Req.newBuilder().setCommand(command).setTimeoutSecs(timeoutSecs);
        if (workingDir != null) {
            builder2.setWorkingDir(workingDir);
        }
        return Protocol.CompositeRequest.newBuilder().setExecuteShellCommand(builder2.build()).build();
    }

    public static Protocol.CompositeRequest resume() {
        return Protocol.CompositeRequest.newBuilder().setContinue(Protocol.Continue_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest stepInto(long threadId) {
        return Protocol.CompositeRequest.newBuilder().setStepInto(Protocol.StepInto_Req.newBuilder().setThreadId((int)threadId)).build();
    }

    public static Protocol.CompositeRequest stepOut(long threadId) {
        return Protocol.CompositeRequest.newBuilder().setStepOut(Protocol.StepOut_Req.newBuilder().setThreadId((int)threadId)).build();
    }

    public static Protocol.CompositeRequest stepOver(long threadId) {
        return Protocol.CompositeRequest.newBuilder().setStepOver(Protocol.StepOver_Req.newBuilder().setThreadId((int)threadId)).build();
    }

    @NotNull
    public static Protocol.CompositeRequest stepScripted(long threadId, @NotNull String className) {
        return Protocol.CompositeRequest.newBuilder().setStepScripted(Protocol.StepScripted_Req.newBuilder().setStepClassName(className).setThreadId((int)threadId)).build();
    }

    public static Protocol.CompositeRequest evaluateExpression(long threadId, int frameIndex, String expression, @Nullable Model.Language language) {
        Protocol.EvaluateExpression_Req.Builder expressionMsg = Protocol.EvaluateExpression_Req.newBuilder().setExpression(expression).setThreadId((int)threadId).setFrameIndex(frameIndex);
        if (language != null) {
            expressionMsg.setLanguage(language);
        }
        return Protocol.CompositeRequest.newBuilder().setEvaluateExpression(expressionMsg).build();
    }

    public static Protocol.CompositeRequest handleConsoleCommand(long threadId, int frameIndex, String command) {
        return Protocol.CompositeRequest.newBuilder().setHandleConsoleCommand(Protocol.HandleConsoleCommand_Req.newBuilder().setCommand(command).setThreadId((int)threadId).setFrameIndex(frameIndex)).build();
    }

    public static Protocol.CompositeRequest dispatchInput(String input, Model.DispatchTarget target) {
        return Protocol.CompositeRequest.newBuilder().setDispatchInput(Protocol.DispatchInput_Req.newBuilder().setInput(input).setTarget(target)).build();
    }

    public static Protocol.CompositeRequest handleCompletion(String command, int pos) {
        return Protocol.CompositeRequest.newBuilder().setHandleCompletion(Protocol.HandleCompletion_Req.newBuilder().setCommand(command).setPos(pos)).build();
    }

    public static Protocol.CompositeRequest handleSignal(String signalName, boolean stop, boolean pass, boolean notify) {
        return Protocol.CompositeRequest.newBuilder().setHandleSignal(Protocol.HandleSignal_Req.newBuilder().setSignal(signalName).setStop(stop).setPass(pass).setNotify(notify)).build();
    }

    public static Protocol.CompositeRequest getValueChildren(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetValueChildren(Protocol.GetValueChildren_Req.newBuilder().setId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest getValueData(int id, int maxDescriptionLength) {
        return Protocol.CompositeRequest.newBuilder().setGetValueData(Protocol.GetValueData_Req.newBuilder().setId(id).setMaxDescriptionLength(maxDescriptionLength)).build();
    }

    public static Protocol.CompositeRequest getValueDescription(int id, int maxLength) {
        return Protocol.CompositeRequest.newBuilder().setGetValueDescription(Protocol.GetValueDescription_Req.newBuilder().setId(id).setMaxLength(maxLength)).build();
    }

    public static Protocol.CompositeRequest arraySlice(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetArraySlice(Protocol.GetArraySlice_Req.newBuilder().setValueId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest addWatchpoint(int id, @Nullable String condition, boolean read, boolean write2, boolean resolveLocation) {
        Protocol.AddWatchpoint_Req.Builder builder2 = Protocol.AddWatchpoint_Req.newBuilder().setRead(read ? 1 : 0).setWrite(write2 ? 1 : 0).setToResolveLocation(resolveLocation ? 1 : 0).setValueId(id);
        if (condition != null) {
            builder2.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddWatchpoint(builder2).build();
    }

    public static Protocol.CompositeRequest getVars(long threadID, int frameIndex, boolean statics, boolean globals) {
        return Protocol.CompositeRequest.newBuilder().setGetVars(Protocol.GetVars_Req.newBuilder().setThreadId((int)threadID).setFrameIndex(frameIndex).setStatics(statics).setGlobals(globals)).build();
    }

    public static Protocol.CompositeRequest setValuesFilteringEnabled(boolean enabled) {
        return Protocol.CompositeRequest.newBuilder().setValuesFilteringPolicy(Protocol.ValuesFilteringPolicy_Req.newBuilder().setFilterEnabled(enabled ? 1 : 0)).build();
    }

    public static Protocol.CompositeRequest getValueAddress(int id) {
        return Protocol.CompositeRequest.newBuilder().setGetValueAddress(Protocol.GetValueAddress_Req.newBuilder().setId(id)).build();
    }

    public static Protocol.CompositeRequest disassemble(long start, long end) {
        return Protocol.CompositeRequest.newBuilder().setDisassemble(Protocol.Disassemble_Req.newBuilder().setStart(start).setEnd(end).build()).build();
    }

    public static Protocol.CompositeRequest dumpSections() {
        return Protocol.CompositeRequest.newBuilder().setDumpSections(Protocol.DumpSections_Req.newBuilder().build()).build();
    }

    public static Protocol.CompositeRequest dumpMemory(long start, long end) {
        return Protocol.CompositeRequest.newBuilder().setDumpMemory(Protocol.DumpMemory_Req.newBuilder().setStart(start).setEnd(end).build()).build();
    }

    public static Protocol.CompositeRequest contextInfo(long address) {
        return Protocol.CompositeRequest.newBuilder().setContextInfo(Protocol.ContextInfo_Req.newBuilder().setAddr(address).build()).build();
    }
}

