/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBEvaluationContext
extends EvaluationContext {
    private final DebuggerDriver myDriver;

    public LLDBEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, long threadId, int frameIndex, @NotNull UserDataHolderEx cacheHolder) {
        super(driver, expirable, threadId, frameIndex, cacheHolder);
        this.myDriver = driver;
    }

    @Override
    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        return LLDBEvaluationContext.cast(expr, "long");
    }

    @Override
    @NotNull
    public String convertToRValue(@NotNull LLValueData lValueData, @NotNull Pair<LLValue, String> rValuePair) throws DebuggerCommandException, ExecutionException {
        LLValueData rValueData = this.getData((LLValue)((Object)rValuePair.first));
        if (rValueData.isNullPointer()) {
            return "((id)0)";
        }
        return lValueData.isPointer() && ((LLValue)((Object)rValuePair.first)).getType().equals("int") && rValueData.intValue() == 0L ? "0" : (String)rValuePair.getSecond();
    }

    public long getValueAddress(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return ((LLDBDriver)this.myDriver).getValueAddress(value);
    }
}

