/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GDBDriverConfiguration
extends DebuggerDriverConfiguration {
    @Override
    @NotNull
    public String getDriverName() {
        return "GDB";
    }

    @Override
    public boolean isAttachSupported() {
        return !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        return new GDBDriver(handler, this, architectureType);
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(this.getGDBExecutablePath());
        GDBDriverConfiguration.setupCommonParameters(result2);
        result2.addParameters(new String[]{"--interpreter=mi2"});
        result2.putUserData(GDBDriver.PRETTY_PRINTERS_PATH, (Object)FileUtil.toSystemIndependentName((String)CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().getAbsolutePath()));
        result2.putUserData(GDBDriver.ENABLE_STL_PRETTY_PRINTERS, (Object)CidrDebuggerSettings.getInstance().STL_RENDERERS_ENABLED);
        return result2;
    }

    @NotNull
    protected String getGDBExecutablePath() {
        return CidrDebuggerPathManager.getBundledGDBBinary().getAbsolutePath();
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, long threadId, int frameIndex, @NotNull UserDataHolderEx cacheHolder) {
        return new EvaluationContext(driver, expirable, threadId, frameIndex, cacheHolder){

            @Override
            @NotNull
            public String convertToRValue(@NotNull LLValueData rValue, @NotNull Pair<LLValue, String> valuePair) {
                return 1.cast((String)valuePair.getSecond(), ((LLValue)((Object)valuePair.getFirst())).getType());
            }
        };
    }
}

