/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class LLThread {
    private final long myId;
    @Nullable
    private final String myState;
    @Nullable
    private final String myWorkQueue;
    @Nullable
    private final String myName;

    public LLThread(long id) {
        this(id, null, null, null);
    }

    public LLThread(long id, @Nullable String state, @Nullable String workQueue) {
        this(id, state, workQueue, null);
    }

    public LLThread(long id, @Nullable String state, @Nullable String workQueue, @Nullable String name) {
        this.myId = id;
        this.myState = StringUtil.nullize((String)state);
        this.myWorkQueue = StringUtil.nullize((String)workQueue);
        this.myName = StringUtil.nullize((String)name);
    }

    public long getId() {
        return this.myId;
    }

    @Nullable
    public String getState() {
        return this.myState;
    }

    @Nullable
    public String getWorkQueue() {
        return this.myWorkQueue;
    }

    public String getDisplayName() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("Thread-").append(this.myId);
        if (this.myWorkQueue != null) {
            builder2.append("-<").append(this.myWorkQueue).append(">");
        }
        if (this.myName != null) {
            builder2.append("-[").append(this.myName).append("]");
        }
        return builder2.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLThread thread = (LLThread)o;
        if (this.myId != thread.myId) {
            return false;
        }
        if (!Objects.equals(this.myState, thread.myState)) {
            return false;
        }
        return Objects.equals(this.myWorkQueue, thread.myWorkQueue);
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.myId);
        result2 = 31 * result2 + (this.myState != null ? this.myState.hashCode() : 0);
        result2 = 31 * result2 + (this.myWorkQueue != null ? this.myWorkQueue.hashCode() : 0);
        return result2;
    }
}

