/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriver {
    public static final Key<String> DEBUGSERVER_SOCKET = Key.create((String)"DEBUGSERVER_SOCKET");
    public static final Key<Integer> DEBUGSERVER_ID = Key.create((String)"DEBUGSERVER_ID");
    public static final Key<Boolean> USE_EXTERNAL_CONSOLE_KEY = Key.create((String)"USE_EXTERNAL_CONSOLE");
    public static final int LOAD_TIMEOUT_MS = 90000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int CLOSE_TIMEOUT_MS = 300;
    public static final int DESTROY_TIMEOUT_MS = 1500;
    public static final int MAX_DESCRIPTION = 1000;
    public static final int MAX_DISASSEMBLE_FUNCTION_SIZE = 65536;
    public static final int MAX_CHILD_COUNT = Integer.MAX_VALUE;
    protected final Handler myHandler;
    private volatile TargetState myState = TargetState.NOT_READY;
    protected final QueueProcessor<Runnable> myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
    @Nullable
    private ProcessOutputReaders myReaders;
    private CidrEventSpan myStateSpan;
    protected boolean myToRedirect;

    public DebuggerDriver(@NotNull Handler handler) {
        this.myHandler = Handler.createQueuedHandler(handler, this.myHandlerProcessor);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    public boolean supportsDisasm() {
        return true;
    }

    @NotNull
    public abstract Language getConsoleLanguage();

    @NotNull
    public abstract BaseProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    public TargetState getState() {
        return this.myState;
    }

    @NotNull
    public abstract HostMachine getHostMachine();

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForLaunch(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(int var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(@NotNull String var1, boolean var2) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    public void stepOver() throws ExecutionException {
        this.stepOver(null);
    }

    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo) throws ExecutionException {
        this.stepInto(forceStepIntoFramesWithNoDebugInfo, null);
    }

    public abstract void stepOver(@Nullable Boolean var1) throws ExecutionException;

    public abstract void stepInto(boolean var1, @Nullable Boolean var2) throws ExecutionException;

    public abstract void stepOut() throws ExecutionException;

    public abstract void runTo(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void runTo(@NotNull Address var1) throws ExecutionException;

    protected abstract boolean doExit() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(long var1, int var3, LLValue var4, String var5, LLWatchpoint.Lifetime var6, LLWatchpoint.AccessType var7) throws ExecutionException, DebuggerCommandException;

    public abstract void removeWatchpoint(List<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public LLBreakpoint addBreakpoint(String path, int line) throws ExecutionException, DebuggerCommandException {
        return this.addBreakpoint(path, line, null);
    }

    @NotNull
    public abstract LLBreakpoint addBreakpoint(String var1, int var2, @Nullable String var3) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern) throws ExecutionException, DebuggerCommandException {
        return this.addSymbolicBreakpoint(symbolPattern, null, null);
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern, @Nullable String module2, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(symbolPattern);
        symBreakpoint.setModule(module2);
        symBreakpoint.setCondition(condition);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @Nullable
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DebuggerCommandException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public ResultList<LLFrame> getFrames(long threadId, int from, int count) throws ExecutionException, DebuggerCommandException {
        return this.getFrames(threadId, from, count, false);
    }

    @NotNull
    public abstract ResultList<LLFrame> getFrames(long var1, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLValue> getVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract LLValueData getData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract String getDescription(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        return this.getChildrenCount(var, Integer.MAX_VALUE);
    }

    @Nullable
    public abstract Integer getChildrenCount(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<LLValue> getVariableChildren(LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public final LLValue evaluate(long threadId, int frameIndex, @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        return this.evaluate(threadId, frameIndex, expression, null);
    }

    @NotNull
    public abstract LLValue evaluate(long var1, int var3, @NotNull String var4, @Nullable DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

    public int getPointerSize() throws ExecutionException, DebuggerCommandException {
        LLValue value = this.evaluate(-1L, -1, "sizeof(void *)");
        return (int)this.getData(value).intValue();
    }

    @NotNull
    public abstract List<LLInstruction> disassembleFunction(@NotNull Address var1, @NotNull AddressRange var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLInstruction> disassemble(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLInstruction disassemble(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        List<LLInstruction> instructions = this.disassemble(AddressUtil.addressToRange(address, 1L));
        return instructions.isEmpty() ? null : instructions.get(0);
    }

    @NotNull
    public abstract List<LLMemoryHunk> dumpMemory(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLSection> getModuleSections(@NotNull LLModule var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    public abstract void executeConsoleCommand(String var1) throws ExecutionException, DebuggerCommandException;

    public abstract void executeConsoleCommand(long var1, int var3, String var4) throws ExecutionException, DebuggerCommandException;

    public void handleCompletion(String command, int pos, List<String> completions) throws ExecutionException {
    }

    @NotNull
    public abstract ResultList<String> completeConsoleCommand(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void handleSignal(String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    protected void setState(TargetState state) {
        this.myState = state;
        if (state == TargetState.RUNNING) {
            this.traceState(new CidrEventSpan("debug", "driver running", null, "<DebuggerDriver>"));
        } else {
            this.traceState(null);
        }
        if (state == TargetState.FINISHED) {
            this.closeOutputReaders();
        }
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandler.handleRunning();
    }

    protected void handleModulesLoaded(@NotNull List<LLModule> modules2) {
        this.myHandler.handleModulesLoaded(modules2);
    }

    protected void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        this.myHandler.handleBreakpointAdded(breakpoint);
    }

    protected void handleBreakpointRemoved(@NotNull LLBreakpoint breakpoint) {
        this.myHandler.handleBreakpointRemoved(breakpoint);
    }

    protected void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        this.myHandler.handleBreakpointUpdated(breakpoint);
    }

    protected void handleInterrupted(@NotNull StopPlace stopPlace) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleInterrupted(stopPlace);
    }

    protected void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleSignal(stopPlace, signal, meaning);
    }

    protected void handleException(@NotNull StopPlace stopPlace, @NotNull String description2) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleException(stopPlace, description2);
    }

    protected void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleBreakpoint(stopPlace, breakpointNumber);
    }

    protected void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpoint(stopPlace, watchpointNumber);
    }

    protected void handleWatchpointScope(int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpointScope(watchpointNumber);
    }

    protected void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        DebuggerDriver.logOutputSummary("Target", text, type);
        this.myHandler.handleTargetOutput(text, type);
    }

    protected void handleAttached(int pid) {
        this.myHandler.handleAttached(pid);
    }

    protected void handleConnected(@NotNull String connection) {
        this.myHandler.handleConnected(connection);
    }

    protected void handleDisconnected() {
        this.myHandler.handleDisconnected();
    }

    @Deprecated
    protected void handleGDBOutput(@NotNull String text) {
    }

    protected void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        this.handleGDBOutput(text);
        DebuggerDriver.logOutputSummary("Debugger", text, type);
        this.myHandler.handleDebuggerOutput(text, type);
    }

    private static void logOutputSummary(@NotNull String description2, @NotNull String text, @NotNull Key type) {
        if (CidrDebuggerLog.LOG.isTraceEnabled()) {
            int maxLength = 80;
            int length = text.length();
            String shortText = DebuggerDriver.stringify(StringUtil.shortenTextWithEllipsis((String)text, (int)80, (int)0));
            if (length > 80) {
                shortText = shortText + " (" + length + " chars)";
            }
            CidrDebuggerLog.LOG.trace(description2 + " [" + type + "]: " + shortText);
        }
    }

    protected void handlePrompt() {
        this.handlePrompt(false);
    }

    protected void handlePrompt(boolean inMultiLineCommand) {
        this.handlePrompt(inMultiLineCommand ? 1 : 0);
    }

    protected void handlePrompt(int promptLevel) {
        this.handlePrompt(promptLevel == 0 ? "(" + this.getPromptText() + ") " : StringUtil.repeat((String)"> ", (int)promptLevel));
    }

    protected abstract String getPromptText();

    protected void handlePrompt(@NotNull String prompt) {
        this.myHandler.handlePrompt(prompt);
    }

    protected void handleTargetFinished(int code, @Nullable String description2) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetFinished(code, description2);
    }

    protected void handleTargetTerminated() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetTerminated();
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleDetached();
    }

    protected void handleExited(int code) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleExited(code);
    }

    public void waitHandlerProcessed() {
        this.myHandlerProcessor.waitFor();
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public abstract void checkErrors() throws ExecutionException;

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    @NotNull
    protected ProcessOutputReaders initReaders(@NotNull HostMachine host, @NotNull GeneralCommandLine targetCommandLine, boolean usePty) throws ExecutionException {
        this.myReaders = new ProcessOutputReaders(host, targetCommandLine, usePty){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull Key type) {
                DebuggerDriver.this.handleTargetOutput(text, type);
            }
        };
        return this.myReaders;
    }

    protected void closeOutputReaders() {
        ProcessOutputReaders readers = this.myReaders;
        if (readers != null) {
            try {
                if (!readers.waitFor(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Closing inferior output readers took too long");
                }
            }
            finally {
                readers.close();
                this.myReaders = null;
            }
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name) {
        return "SIGTERM".equals(name) || "SIGKILL".equals(name);
    }

    public abstract void addSymbolsFile(File var1, File var2) throws ExecutionException;

    @NotNull
    protected static String format(@NotNull @PrintFormat String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static int escapedByte(String s, int idx, ByteArrayOutputStream bs) {
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    protected static String stringify(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length() + 2).append('\"');
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
        return buffer.append('\"').toString();
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i2 = idx - 1;
                    bs.reset();
                    while ((i2 = DebuggerDriver.escapedByte(s, i2, bs)) != -1) {
                        idx = i2;
                    }
                    if (bs.size() > 0) {
                        buffer.append(new String(bs.toByteArray(), StandardCharsets.UTF_8));
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    @Contract(value="_, !null -> !null")
    public static Address parseAddress(@NotNull String str, Address defaultValue) {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Address parseAddress(@NotNull String str) throws ExecutionException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public static Address parseAddressSafe(@NotNull String str) throws DebuggerCommandException {
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(e);
        }
    }

    protected static int getTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout", (int)30000);
    }

    protected static int getLoadTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.load", (int)90000);
    }

    protected static int getEvaluationTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.evaluate", (int)30000);
    }

    protected BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull DebuggerDriverConfiguration config) throws ExecutionException {
        BaseProcessHandler handler = config.createDebugProcessHandler(commandLine);
        final Process process2 = handler.getProcess();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (process2.isAlive() && willBeDestroyed) {
                    try {
                        if (!DebuggerDriver.this.doExit()) {
                            return;
                        }
                    }
                    catch (ExecutionException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                        return;
                    }
                    try {
                        process2.waitFor(1500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (process2.isAlive() && OSProcessHandler.processCanBeKilledByOS((Process)process2)) {
                    OSProcessUtil.killProcess((Process)process2);
                }
            }
        });
        return handler;
    }

    private void traceState(@Nullable CidrEventSpan eventSpan) {
        if (this.myStateSpan != null) {
            this.myStateSpan.close();
        }
        this.myStateSpan = eventSpan;
    }

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        private String myPattern;
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private long myThreadId = 0L;

        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(String pattern) {
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module2) {
            this.myModule = module2;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition) {
            this.myCondition = condition;
        }

        public long getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(long threadId) {
            this.myThreadId = threadId;
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift"),
        RUST("Rust"),
        FORTRAN("Fortran"),
        ADA("Ada"),
        COBOL("Cobol"),
        PASCAL("Pascal"),
        MODULA("Modula"),
        D("D"),
        OPENCL("OpenCL"),
        GO("Go"),
        HASKELL("Haskell"),
        OCAML("OCaml");

        private final String myName;

        private StandardDebuggerLanguage(String name) {
            this.myName = name;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static class ResultList<T> {
        @NotNull
        public final List<T> list;
        public final boolean hasMore;

        public ResultList(@NotNull List<T> list, boolean hasMore) {
            this.list = list;
            this.hasMore = hasMore;
        }

        @NotNull
        public static <T> ResultList<T> create(@NotNull List<T> list, boolean hasMore) {
            return new ResultList<T>(list, hasMore);
        }

        @NotNull
        public static <T> ResultList<T> empty() {
            return ResultList.create(Collections.emptyList(), false);
        }
    }

    public static class StopPlace {
        @NotNull
        public final LLThread thread;
        @NotNull
        public final LLFrame frame;

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame) {
            this.thread = thread;
            this.frame = frame;
        }

        public String toString() {
            return this.thread + ": " + this.frame;
        }
    }

    public static class PathMapping {
        @NotNull
        public final String from;
        @NotNull
        public final String to;

        public PathMapping(@NotNull String from, @NotNull String to) {
            this.from = from;
            this.to = to;
        }
    }

    public abstract class Inferior {
        private final int myId;
        private final AtomicBoolean myIsRunning = new AtomicBoolean();

        public Inferior(int id) {
            this.myId = id;
        }

        public int getId() {
            return this.myId;
        }

        @NotNull
        public DebuggerDriver getDriver() {
            return DebuggerDriver.this;
        }

        public long start() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(false, true)) {
                throw new ExecutionException("started already");
            }
            return this.startImpl();
        }

        public void detach() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return;
            }
            this.detachImpl();
        }

        public boolean destroy() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return false;
            }
            return this.destroyImpl();
        }

        protected abstract long startImpl() throws ExecutionException;

        protected abstract void detachImpl() throws ExecutionException;

        protected abstract boolean destroyImpl() throws ExecutionException;
    }

    public static interface Handler
    extends EventListener {
        default public void handleRunning() {
        }

        default public void handleModulesLoaded(@NotNull List<LLModule> modules2) {
        }

        default public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        }

        default public void handleBreakpointRemoved(@NotNull LLBreakpoint breakpoint) {
        }

        default public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        }

        default public void handleInterrupted(@NotNull StopPlace stopPlace) {
        }

        default public void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        }

        default public void handleException(@NotNull StopPlace stopPlace, @NotNull String description2) {
        }

        default public void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        }

        default public void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        }

        default public void handleWatchpointScope(int watchpointNumber) {
        }

        default public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        }

        default public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
        }

        default public void handlePrompt(@NotNull String prompt) {
        }

        default public void handleTargetFinished(int code, @Nullable String description2) {
        }

        default public void handleTargetTerminated() {
        }

        default public void handleExited(int code) {
        }

        default public void handleAttached(int pid) {
        }

        default public void handleDetached() {
        }

        default public void handleConnected(@NotNull String connection) {
        }

        default public void handleDisconnected() {
        }

        @NotNull
        public static Handler createQueuedHandler(@NotNull Handler handler, @NotNull QueueProcessor<Runnable> queueProcessor) {
            return (Handler)Proxy.newProxyInstance(Handler.class.getClassLoader(), new Class[]{Handler.class}, (proxy, method, args) -> {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)handler, args);
                }
                queueProcessor.add(() -> {
                    try {
                        method.invoke((Object)handler, args);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                });
                return null;
            });
        }
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHED;

    }

    public static class ShellCommandResult {
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }
    }
}

