/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.lang.ContextFreeResolveUtil;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    public OCDebuggerTypesHelper(CidrDebugProcess process2) {
        super(process2);
    }

    @Override
    @Nullable
    protected OCReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context2) {
        return OCElementFactory.referenceElementFromText(var.getName(), context2, false);
    }

    @Override
    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement context2 = this.getContextElement(position);
        if (context2 == null) {
            return null;
        }
        return OCThisSelfSuperSymbol.tryResolveThisSelfSuper(var.getName(), context2, OCResolveContext.forPsi(context2)) != null;
    }

    @Nullable
    protected OCType resolveType(CidrPhysicalValue value, Class ... klass) {
        XSourcePosition pos = value.getSourcePosition();
        if (pos == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProcess.getProject()).findFile(pos.getFile());
        String type = value.getVar().getType();
        return this.doResolveType(pos, type, psiFile, klass);
    }

    @Nullable
    private OCType doResolveType(@NotNull XSourcePosition pos, @NotNull String typeName, PsiFile psiFile, Class ... klass) {
        PsiElement element = this.getContextElement(pos);
        return OCDebuggerTypesHelper.doResolveType(typeName, psiFile, element, klass);
    }

    @Nullable
    private static OCType doResolveType(@NotNull String typeName, PsiFile psiFile, PsiElement context2, Class ... klass) {
        OCResolveContext resolveContext;
        if (context2 == null) {
            return null;
        }
        OCTypeElement exp = OCElementFactory.typeElementFromTextOrNull(typeName, context2, false);
        if (exp == null) {
            return null;
        }
        OCType expType = exp.getType();
        OCType resolved = expType.resolve(resolveContext = OCResolveContext.forPsi(context2));
        if (resolved instanceof OCReferenceType) {
            OCReferenceType referenceType = (OCReferenceType)resolved;
            List<OCSymbol> symbols = referenceType.getReference(psiFile).resolveToSymbols(resolveContext);
            for (OCSymbol symbol : symbols) {
                OCSymbol definitionSymbol = symbol.getDefinitionSymbol(context2.getProject());
                if (definitionSymbol == null || !OCDebuggerTypesHelper.isInstanceOf(definitionSymbol.getResolvedType(resolveContext), klass)) continue;
                return definitionSymbol.getResolvedType(resolveContext);
            }
            for (OCSymbol symbol : symbols) {
                OCType type = symbol.getResolvedType(resolveContext);
                if (!OCDebuggerTypesHelper.isInstanceOf(type, klass)) continue;
                return type;
            }
        } else if (OCDebuggerTypesHelper.isInstanceOf(resolved, klass)) {
            return resolved;
        }
        return null;
    }

    private static boolean isInstanceOf(OCType type, Class[] klass) {
        for (Class each : klass) {
            if (!each.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Integer getSizeOf(@NotNull CidrPhysicalValue value) {
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            XSourcePosition pos;
            if (this.myProcess.getProject().isDisposed()) {
                return null;
            }
            OCType type = this.resolveType(value, OCType.class);
            if (type != null && (pos = value.getSourcePosition()) != null) {
                Project project2 = this.myProcess.getProject();
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(pos.getFile());
                return type.getSizeInBytes(psiFile, null, project2);
            }
            return null;
        }));
    }

    @Override
    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        OCDeclaratorSymbol field;
        OCType type = this.resolveType(value.getParent(), OCPointerType.class, OCStructType.class, OCReferenceType.class, OCObjectType.class);
        if (type == null) {
            return null;
        }
        OCType terminalType = type.getTerminalType();
        if (terminalType instanceof OCObjectType) {
            OCInstanceVariableSymbol var = ((OCObjectType)terminalType).findMember(value.getVar().getName(), OCInstanceVariableSymbol.class);
            if (var != null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(var.getContainingFile(), var.getOffset());
            }
        } else if (terminalType instanceof OCStructType && (field = ((OCStructType)terminalType).findField(value.getVar().getName())) != null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(field.getContainingFile(), field.getOffset());
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition sourcePosition) {
        return OCDebuggerTypesHelper.getContextElement(sourcePosition, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        OCMemberSymbol symbol = ContextFreeResolveUtil.resolveToProperty(dynamicTypeName, value.getName(), this.myProcess.getProject());
        if (symbol == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(symbol.getContainingFile(), symbol.getOffset());
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project2) {
        PsiElement result2 = OCPsiFile.tryGetElementFromOCFile(CidrDebuggerTypesHelper.getContextElement(sourcePosition, project2));
        if (result2 != null && result2.getParent() instanceof OCForStatement) {
            result2 = ((OCForStatement)result2.getParent()).getInitializer();
        }
        return result2;
    }
}

