/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerUtil {
    @NotNull
    public static String getExceptionMessage(Exception e) {
        return StringUtil.notNullize((String)e.getMessage(), (String)e.getClass().getSimpleName());
    }

    @NotNull
    public static <T> ReadActionResult<T> runInReadActionWithRetries(@NotNull Computable<? extends T> action, @NotNull Expirable expirable) {
        Ref res = Ref.create();
        int MAX_ATTEMPTS = 32;
        for (int attempt = 0; attempt < 32; ++attempt) {
            if (expirable.isExpired()) {
                return ReadActionResult.interrupted();
            }
            if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> res.set(action.compute()))) {
                return ReadActionResult.ok(res.get());
            }
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        CidrDebuggerLog.LOG.warn("Interrupted runInReadActionWithRetries() after 32 attempts");
        return ReadActionResult.interrupted();
    }

    public static class ReadActionResult<T> {
        public final T value;
        public final boolean wasCompleted;

        private ReadActionResult(T value, boolean wasCompleted) {
            this.value = value;
            this.wasCompleted = wasCompleted;
        }

        static <T> ReadActionResult<T> ok(T value) {
            return new ReadActionResult<T>(value, true);
        }

        static <T> ReadActionResult<T> interrupted() {
            return new ReadActionResult<Object>(null, false);
        }
    }
}

