/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class EscapeUtil {
    @NotNull
    public static String escapeGNU(String arg, boolean isShell) {
        if (arg.length() == 0) {
            return "\"\"";
        }
        StringBuilder result2 = new StringBuilder();
        int length = arg.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = arg.charAt(i2);
            if ("\"' \\\t\n\r\f".indexOf(c) != -1 || isShell && "|&;<>()$`".indexOf(c) != -1) {
                result2.append('\\');
            }
            result2.append(c);
        }
        return result2.toString();
    }

    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '?': {
                    buffer.append('?');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'v': {
                    buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                StringBuilder sb = new StringBuilder(count);
                for (int pos = idx + suffixLen; pos < length && count > 0; --count, ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit((char)chl) || radix == 8 && StringUtil.isOctalDigit((char)chl))) break;
                    sb.append(chl);
                }
                if (sb.length() != 0) {
                    try {
                        long code = Long.parseLong(sb.toString(), radix);
                        idx += sb.length() + suffixLen - 1;
                        buffer.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }
}

