/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.testFramework.DisposableRule;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RuleChain;
import com.intellij.testFramework.rules.ProjectModelRule;
import com.intellij.testFramework.rules.ProjectModelRule$disposeOnTearDown$;
import com.intellij.testFramework.rules.TempDirectory;
import com.intellij.util.Consumer;
import com.intellij.util.io.PathKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001a\u0018\u0000 R2\u00020\u0001:\u0001RB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301J,\u00104\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00105\u001a\u00020\u00162\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301J,\u00106\u001a\u00020-2\u0006\u00107\u001a\u0002082\u0006\u0010.\u001a\u00020/2\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301J$\u00109\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301J$\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020301J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020BH\u0016J\u0016\u0010C\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010D\u001a\u00020EJ\u0010\u0010F\u001a\u0002082\b\b\u0002\u0010.\u001a\u00020/J\u0016\u0010F\u001a\u0002082\u0006\u0010.\u001a\u00020/2\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020;2\b\b\u0002\u0010.\u001a\u00020/J\u0010\u0010J\u001a\u0002032\u0006\u0010K\u001a\u00020-H\u0002J\u0018\u0010L\u001a\n M*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u0010N\u001a\u0002032\u0006\u0010K\u001a\u00020O2\u0006\u0010P\u001a\u00020/J\u0016\u0010Q\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010P\u001a\u00020/R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006S"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule;", "Lorg/junit/rules/TestRule;", "forceEnableWorkspaceModel", "", "(Z)V", "baseProjectDir", "Lcom/intellij/testFramework/rules/TempDirectory;", "getBaseProjectDir", "()Lcom/intellij/testFramework/rules/TempDirectory;", "disposableRule", "Lcom/intellij/testFramework/DisposableRule;", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "getModuleManager", "()Lcom/intellij/openapi/module/ModuleManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "projectLibraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "getProjectLibraryTable", "()Lcom/intellij/openapi/roots/libraries/LibraryTable;", "projectResource", "com/intellij/testFramework/rules/ProjectModelRule$projectResource$1", "Lcom/intellij/testFramework/rules/ProjectModelRule$projectResource$1;", "projectRootDir", "Ljava/nio/file/Path;", "getProjectRootDir", "()Ljava/nio/file/Path;", "setProjectRootDir", "(Ljava/nio/file/Path;)V", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "ruleChain", "Lcom/intellij/testFramework/RuleChain;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "addApplicationLevelLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "name", "", "setup", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "", "addLibrary", "libraryTable", "addModuleLevelLibrary", "module", "Lcom/intellij/openapi/module/Module;", "addProjectLevelLibrary", "addSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "createLibraryAndDisposeOnTearDown", "model", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "createModule", "moduleModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "createSdk", "disposeOnTearDown", "library", "generateImlPath", "kotlin.jvm.PlatformType", "renameLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "newName", "renameModule", "Companion", "intellij.platform.testFramework"})
public final class ProjectModelRule
implements TestRule {
    @NotNull
    private final TempDirectory baseProjectDir;
    private final DisposableRule disposableRule;
    @NotNull
    public Project project;
    @NotNull
    public Path projectRootDir;
    private final projectResource.1 projectResource;
    private final RuleChain ruleChain;
    private final boolean forceEnableWorkspaceModel;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TempDirectory getBaseProjectDir() {
        return this.baseProjectDir;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project2;
    }

    public final void setProject(@NotNull Project project2) {
        this.project = project2;
    }

    @NotNull
    public final Path getProjectRootDir() {
        Path path = this.projectRootDir;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        }
        return path;
    }

    public final void setProjectRootDir(@NotNull Path path) {
        this.projectRootDir = path;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description2) {
        return this.ruleChain.apply(base, description2);
    }

    @NotNull
    public final Module createModule(@NotNull String name) {
        Path imlFile = this.generateImlPath(name);
        ModuleManager manager2 = this.getModuleManager();
        boolean $i$f$runWriteActionAndWait = false;
        return (Module)WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable<T, Throwable>(manager2, imlFile){
            final /* synthetic */ ModuleManager $manager$inlined;
            final /* synthetic */ Path $imlFile$inlined;
            {
                this.$manager$inlined = moduleManager;
                this.$imlFile$inlined = path;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$manager$inlined.newModule(PathKt.getSystemIndependentPath((Path)this.$imlFile$inlined), "EMPTY_MODULE");
            }
        });
    }

    public static /* synthetic */ Module createModule$default(ProjectModelRule projectModelRule, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "module";
        }
        return projectModelRule.createModule(string);
    }

    @NotNull
    public final Module createModule(@NotNull String name, @NotNull ModifiableModuleModel moduleModel) {
        return moduleModel.newModule(PathKt.getSystemIndependentPath((Path)this.generateImlPath(name)), "EMPTY_MODULE");
    }

    private final Path generateImlPath(String name) {
        Path path = this.projectRootDir;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        }
        return path.resolve(name + '/' + name + ".iml");
    }

    @NotNull
    public final Sdk createSdk(@NotNull String name) {
        return ProjectJdkTable.getInstance().createSdk(name, this.getSdkType());
    }

    public static /* synthetic */ Sdk createSdk$default(ProjectModelRule projectModelRule, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "sdk";
        }
        return projectModelRule.createSdk(string);
    }

    @NotNull
    public final Sdk addSdk(@NotNull Sdk sdk, @NotNull Function1<? super SdkModificator, Unit> setup) {
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable<T, Throwable>(this, sdk, setup){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Sdk $sdk$inlined;
            final /* synthetic */ Function1 $setup$inlined;
            {
                this.this$0 = projectModelRule;
                this.$sdk$inlined = sdk;
                this.$setup$inlined = function1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                ProjectJdkTable.getInstance().addJdk(this.$sdk$inlined, ProjectModelRule.access$getDisposableRule$p(this.this$0).getDisposable());
                SdkModificator sdkModificator = this.$sdk$inlined.getSdkModificator();
                try {
                    this.$setup$inlined.invoke((Object)sdkModificator);
                }
                finally {
                    sdkModificator.commitChanges();
                }
                return (T)Unit.INSTANCE;
            }
        });
        return sdk;
    }

    public static /* synthetic */ Sdk addSdk$default(ProjectModelRule projectModelRule, Sdk sdk, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = addSdk.1.INSTANCE;
        }
        return projectModelRule.addSdk(sdk, (Function1<? super SdkModificator, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addProjectLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        return this.addLibrary(name, this.getProjectLibraryTable(), setup);
    }

    public static /* synthetic */ LibraryEx addProjectLevelLibrary$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = addProjectLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addProjectLevelLibrary(string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addModuleLevelLibrary(@NotNull Module module2, @NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Ref library = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, (Consumer)((Consumer)new Consumer<ModifiableRootModel>(this, library, name, setup){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Ref $library;
            final /* synthetic */ String $name;
            final /* synthetic */ Function1 $setup;

            public final void consume(ModifiableRootModel model) {
                this.$library.set((Object)this.this$0.addLibrary(this.$name, model.getModuleLibraryTable(), (Function1<? super LibraryEx.ModifiableModelEx, Unit>)this.$setup));
            }
            {
                this.this$0 = projectModelRule;
                this.$library = ref;
                this.$name = string;
                this.$setup = function1;
            }
        }));
        return (LibraryEx)library.get();
    }

    public static /* synthetic */ LibraryEx addModuleLevelLibrary$default(ProjectModelRule projectModelRule, Module module2, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = addModuleLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addModuleLevelLibrary(module2, string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addLibrary(@NotNull String name, @NotNull LibraryTable libraryTable, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
        Library library = model.createLibrary(name);
        if (library == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        LibraryEx library2 = (LibraryEx)library;
        LibraryEx.ModifiableModelEx libraryModel = library2.getModifiableModel();
        setup.invoke((Object)libraryModel);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable<T, Throwable>(libraryModel, model){
            final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel$inlined;
            final /* synthetic */ LibraryTable.ModifiableModel $model$inlined;
            {
                this.$libraryModel$inlined = modifiableModelEx;
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$libraryModel$inlined.commit();
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return library2;
    }

    public static /* synthetic */ LibraryEx addLibrary$default(ProjectModelRule projectModelRule, String string, LibraryTable libraryTable, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = addLibrary.1.INSTANCE;
        }
        return projectModelRule.addLibrary(string, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addApplicationLevelLibrary(@NotNull String name, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        LibraryEx library = this.addLibrary(name, libraryTable, setup);
        this.disposeOnTearDown(library);
        return library;
    }

    public static /* synthetic */ LibraryEx addApplicationLevelLibrary$default(ProjectModelRule projectModelRule, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = addApplicationLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addApplicationLevelLibrary(string, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    private final void disposeOnTearDown(LibraryEx library) {
        DisposableRule this_$iv = this.disposableRule;
        boolean $i$f$register = false;
        Disposer.register((Disposable)this_$iv.getDisposable(), (Disposable)new Disposable(library){
            final /* synthetic */ LibraryEx $library$inlined;
            {
                this.$library$inlined = libraryEx;
            }

            public void dispose() {
                boolean bl = false;
                boolean $i$f$runWriteActionAndWait = false;
                WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, Throwable>(this){
                    final /* synthetic */ disposeOnTearDown$$inlined$register$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        if (!this.this$0.$library$inlined.isDisposed()) {
                            LibraryTable libraryTable = this.this$0.$library$inlined.getTable();
                            String string = this.this$0.$library$inlined.getName();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            if (Intrinsics.areEqual((Object)libraryTable.getLibraryByName(string), (Object)this.this$0.$library$inlined)) {
                                this.this$0.$library$inlined.getTable().removeLibrary((Library)this.this$0.$library$inlined);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                }));
            }
        });
    }

    @NotNull
    public final LibraryEx createLibraryAndDisposeOnTearDown(@NotNull String name, @NotNull LibraryTable.ModifiableModel model) {
        Library library = model.createLibrary(name);
        if (library == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        LibraryEx library2 = (LibraryEx)library;
        this.disposeOnTearDown(library2);
        return library2;
    }

    public final void renameLibrary(@NotNull Library library, @NotNull String newName) {
        Library.ModifiableModel model = library.getModifiableModel();
        model.setName(newName);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable<T, Throwable>(model){
            final /* synthetic */ Library.ModifiableModel $model$inlined;
            {
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void renameModule(@NotNull Module module2, @NotNull String newName) {
        boolean $i$f$runReadAction = false;
        ModifiableModuleModel model = (ModifiableModuleModel)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ ProjectModelRule this$0;
            {
                this.this$0 = projectModelRule;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.this$0.getModuleManager().getModifiableModel();
            }
        });
        model.renameModule(module2, newName);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable<T, Throwable>(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        return (SdkTypeId)SimpleJavaSdkType.getInstance();
    }

    @NotNull
    public final ProjectRootManager getProjectRootManager() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return ProjectRootManager.getInstance((Project)project2);
    }

    @NotNull
    public final ModuleManager getModuleManager() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return ModuleManager.getInstance((Project)project2);
    }

    @NotNull
    public final LibraryTable getProjectLibraryTable() {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return libraryTablesRegistrar.getLibraryTable(project2);
    }

    public ProjectModelRule(boolean forceEnableWorkspaceModel) {
        this.forceEnableWorkspaceModel = forceEnableWorkspaceModel;
        this.baseProjectDir = new TempDirectory();
        this.disposableRule = new DisposableRule();
        this.projectResource = new ExternalResource(this){
            final /* synthetic */ ProjectModelRule this$0;

            protected void before() {
                this.this$0.setProjectRootDir(this.this$0.getBaseProjectDir().getRoot().toPath());
                if (ProjectModelRule.access$getForceEnableWorkspaceModel$p(this.this$0)) {
                    WorkspaceModelInitialTestContent.INSTANCE.withInitialContent((WorkspaceEntityStorage)WorkspaceEntityStorageBuilder.Companion.create(), (Function0)new Function0<Unit>(this){
                        final /* synthetic */ projectResource.1 this$0;

                        public final void invoke() {
                            this.this$0.this$0.setProject(PlatformTestUtil.loadAndOpenProject(this.this$0.this$0.getProjectRootDir()));
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                } else {
                    this.this$0.setProject(PlatformTestUtil.loadAndOpenProject(this.this$0.getProjectRootDir()));
                }
            }

            protected void after() {
                PlatformTestUtil.forceCloseProjectWithoutSaving(this.this$0.getProject());
            }
            {
                this.this$0 = this$0;
            }
        };
        this.ruleChain = new RuleChain((TestRule)this.baseProjectDir, (TestRule)this.projectResource, (TestRule)this.disposableRule);
    }

    public /* synthetic */ ProjectModelRule(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ProjectModelRule() {
        this(false, 1, null);
    }

    public static final /* synthetic */ DisposableRule access$getDisposableRule$p(ProjectModelRule $this) {
        return $this.disposableRule;
    }

    public static final /* synthetic */ boolean access$getForceEnableWorkspaceModel$p(ProjectModelRule $this) {
        return $this.forceEnableWorkspaceModel;
    }

    public static final boolean isWorkspaceModelEnabled() {
        return Companion.isWorkspaceModelEnabled();
    }

    @JvmStatic
    public static final void ignoreTestUnderWorkspaceModel() {
        Companion.ignoreTestUnderWorkspaceModel();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule$Companion;", "", "()V", "isWorkspaceModelEnabled", "", "isWorkspaceModelEnabled$annotations", "()Z", "ignoreTestUnderWorkspaceModel", "", "intellij.platform.testFramework"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void isWorkspaceModelEnabled$annotations() {
        }

        public final boolean isWorkspaceModelEnabled() {
            return Registry.is((String)"ide.new.project.model");
        }

        @JvmStatic
        public final void ignoreTestUnderWorkspaceModel() {
            Assume.assumeFalse((String)"Not applicable to workspace model", (boolean)this.isWorkspaceModelEnabled());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

