/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;
import org.junit.Assert;

public final class ThreadTracker {
    private static final Logger LOG;
    private final Map<String, Thread> before = ThreadTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized();
    private static final Method getThreads;
    private static final Set<String> wellKnownOffenders;

    @NotNull
    public static Map<String, Thread> getThreads() {
        Object[] threads;
        try {
            threads = (Thread[])getThreads.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ContainerUtil.newMapFromValues((Iterator)ContainerUtil.iterate((Object[])threads), Thread::getName);
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        wellKnownOffenders.addAll(Arrays.asList(threadNamePrefixes));
        Disposer.register((Disposable)parentDisposable, () -> wellKnownOffenders.removeAll(Arrays.asList(threadNamePrefixes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() throws AssertionError {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor((long)100L, (TimeUnit)TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
        try {
            if (this.myDefaultProjectInitialized != ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized()) {
                return;
            }
            Map<String, Thread> all = ThreadTracker.getThreads();
            HashMap<String, Thread> after2 = new HashMap<String, Thread>(all);
            after2.keySet().removeAll(this.before.keySet());
            Map stackTraces = ContainerUtil.map2Map(after2.values(), thread -> Pair.create((Object)thread, (Object)thread.getStackTrace()));
            for (Thread thread2 : after2.values()) {
                ThreadGroup group;
                if (thread2 == Thread.currentThread() || (group = thread2.getThreadGroup()) != null && "system".equals(group.getName()) || !thread2.isAlive()) continue;
                long start = System.currentTimeMillis();
                StackTraceElement[] traceBeforeWait = thread2.getStackTrace();
                if (ThreadTracker.shouldIgnore(thread2, traceBeforeWait)) continue;
                int WAIT_SEC = 10;
                StackTraceElement[] stackTrace = traceBeforeWait;
                while (System.currentTimeMillis() < start + (long)(WAIT_SEC * 1000)) {
                    UIUtil.dispatchAllInvocationEvents();
                    stackTrace = thread2.getStackTrace();
                    if (!ThreadTracker.shouldIgnore(thread2, stackTrace)) continue;
                }
                stackTraces.put(thread2, stackTrace);
                if (ThreadTracker.shouldIgnore(thread2, stackTrace)) continue;
                all.keySet().removeAll(after2.keySet());
                Map otherStackTraces = ContainerUtil.map2Map(all.values(), t -> Pair.create((Object)t, (Object)t.getStackTrace()));
                String trace = PerformanceWatcher.printStacktrace((String)"", (Thread)thread2, (StackTraceElement[])stackTrace);
                String traceBefore = PerformanceWatcher.printStacktrace((String)"", (Thread)thread2, (StackTraceElement[])traceBeforeWait);
                String internalDiagnostic = stackTrace.length < 5 ? "stackTrace.length: " + stackTrace.length : "(diagnostic: 0: " + stackTrace[0].getClassName() + " : " + stackTrace[0].getClassName().equals("sun.misc.Unsafe") + " . " + stackTrace[0].getMethodName() + " : " + stackTrace[0].getMethodName().equals("unpark") + " 2: " + stackTrace[2].getClassName() + " : " + stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") + " . " + stackTrace[2].getMethodName() + " : " + stackTrace[2].getMethodName().equals("finishCompletion") + ")";
                Assert.fail((String)("Thread leaked: " + traceBefore + (trace.equals(traceBefore) ? "" : "(its trace after " + WAIT_SEC + " seconds wait:) " + trace) + internalDiagnostic + "\n\nLeaking threads dump:\n" + ThreadTracker.dumpThreadsToString(after2, stackTraces) + "\n----\nAll other threads dump:\n" + ThreadTracker.dumpThreadsToString(all, otherStackTraces)));
            }
        }
        finally {
            this.before.clear();
        }
    }

    @NotNull
    private static CharSequence dumpThreadsToString(@NotNull Map<String, Thread> after2, Map<Thread, StackTraceElement[]> stackTraces) {
        StringBuilder f = new StringBuilder();
        after2.forEach((name, thread) -> {
            f.append("\"").append((String)name).append("\" (").append(thread.isAlive() ? "alive" : "dead").append(") ").append((Object)thread.getState());
            f.append("\n");
            for (StackTraceElement element : (StackTraceElement[])stackTraces.get(thread)) {
                f.append("\tat ").append(element).append("\n");
            }
            f.append("\n");
        });
        return f;
    }

    private static boolean shouldIgnore(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (!thread.isAlive()) {
            return true;
        }
        if (ThreadTracker.isWellKnownOffender(thread.getName())) {
            return true;
        }
        if (stackTrace.length == 0) {
            return true;
        }
        return ThreadTracker.isIdleApplicationPoolThread(stackTrace) || ThreadTracker.isIdleCommonPoolThread(thread, stackTrace) || ThreadTracker.isFutureTaskAboutToFinish(stackTrace) || ThreadTracker.isIdleDefaultCoroutineExecutorThread(thread, stackTrace) || ThreadTracker.isCoroutineSchedulerPoolThread(thread, stackTrace);
    }

    private static boolean isWellKnownOffender(@NotNull String threadName) {
        return ContainerUtil.exists(wellKnownOffenders, threadName::contains);
    }

    private static boolean isIdleApplicationPoolThread(StackTraceElement @NotNull [] stackTrace) {
        boolean insideTPEGetTask = ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("getTask") && element.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
        return insideTPEGetTask;
    }

    private static boolean isIdleCommonPoolThread(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean insideAwaitWork = ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("awaitWork") && element.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        if (insideAwaitWork) {
            return true;
        }
        boolean isWaitingWorkInJdk = stackTrace.length > 2 && stackTrace[0].getClassName().endsWith(".Unsafe") && stackTrace[0].getMethodName().equals("park") && stackTrace[1].getClassName().equals("java.util.concurrent.locks.LockSupport") && stackTrace[1].getMethodName().equals("park") && stackTrace[2].getClassName().equals("java.util.concurrent.ForkJoinPool") && stackTrace[2].getMethodName().equals("runWorker");
        return isWaitingWorkInJdk;
    }

    private static boolean isFutureTaskAboutToFinish(StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace.length < 5) {
            return false;
        }
        return stackTrace[0].getClassName().equals("sun.misc.Unsafe") && stackTrace[0].getMethodName().equals("unpark") && stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") && stackTrace[2].getMethodName().equals("finishCompletion");
    }

    private static boolean isIdleDefaultCoroutineExecutorThread(@NotNull Thread thread, @NotNull @NotNull StackTraceElement @NotNull [] stackTrace) {
        if (stackTrace.length != 4) {
            return false;
        }
        return "kotlinx.coroutines.DefaultExecutor".equals(thread.getName()) && (stackTrace[0].getClassName().equals("sun.misc.Unsafe") || stackTrace[0].getClassName().equals("jdk.internal.misc.Unsafe")) && stackTrace[0].getMethodName().equals("park") && stackTrace[2].getClassName().equals("kotlinx.coroutines.DefaultExecutor") && stackTrace[2].getMethodName().equals("run");
    }

    private static boolean isCoroutineSchedulerPoolThread(@NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (!"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker".equals(thread.getClass().getName())) {
            return false;
        }
        boolean insideCpuWorkerIdle = ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("park") && element.getClassName().equals("kotlinx.coroutines.scheduling.CoroutineScheduler$Worker"));
        return insideCpuWorkerIdle;
    }

    public static void awaitJDIThreadsTermination(int timeout, @NotNull TimeUnit unit) {
        ThreadTracker.awaitThreadTerminationWithParentParentGroup("JDI main", timeout, unit);
    }

    private static void awaitThreadTerminationWithParentParentGroup(@NotNull String grandThreadGroup, int timeout, @NotNull TimeUnit unit) {
        Thread jdiThread;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + unit.toMillis(timeout) && (jdiThread = (Thread)ContainerUtil.find(ThreadTracker.getThreads().values(), thread -> {
            ThreadGroup group = thread.getThreadGroup();
            return group != null && group.getParent() != null && grandThreadGroup.equals(group.getParent().getName());
        })) != null) {
            try {
                long timeLeft = start + unit.toMillis(timeout) - System.currentTimeMillis();
                LOG.debug("Waiting for the " + jdiThread + " for " + timeLeft + "ms");
                jdiThread.join(timeLeft);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        List sorted;
        LOG = Logger.getInstance(ThreadTracker.class);
        getThreads = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(Thread.class, (String)"getThreads", (Class[])new Class[0]));
        wellKnownOffenders = new THashSet();
        List<String> offenders = Arrays.asList("AWT-EventQueue-", "AWT-Shutdown", "AWT-Windows", "Batik CleanerThread", "Cleaner-0", "CompilerThread0", "dockerjava-netty", "External compiler", "Finalizer", "Flushing Daemon", "IDEA Test Case Thread", "Image Fetcher ", "InnocuousThreadGroup", "Java2D Disposer", "JobScheduler FJ pool ", "JPS thread pool", "Keep-Alive-SocketCleaner", "Keep-Alive-Timer", "main", "Monitor Ctrl-Break", "Netty ", "ObjectCleanerThread", "OkHttp ConnectionPool", "Okio Watchdog", "Reference Handler", "RMI GC Daemon", "RMI TCP ", "SeedGenerator Thread", "Signal Dispatcher", "tc-okhttp-stream", "timer-int", "timer-sys", "TimerQueue", "UserActivityMonitor thread", "VM Periodic Task Thread", "VM Thread", "YJPAgent-Telemetry");
        if (!offenders.equals(sorted = offenders.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList()))) {
            String proper = StringUtil.join((Collection)ContainerUtil.map(sorted, s -> '\"' + s + '\"'), (String)",\n").replaceAll("\"Flushing Daemon\"", "FlushingDaemon.NAME");
            throw new AssertionError((Object)("Thread names must be sorted (for ease of maintenance). Something like this will do:\n" + proper));
        }
        wellKnownOffenders.addAll(offenders);
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isDisposed()) {
            ThreadTracker.longRunningThreadCreated((Disposable)application, "Periodic tasks thread", "ApplicationImpl pooled thread ", "I/O pool ");
        }
        try {
            Preferences.userRoot().flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

