/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        super(logger);
    }

    public void warn(String message, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message, t, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message, t, details, this.myLogger);
    }

    public void debug(@NonNls String message) {
        if (this.isDebugEnabled()) {
            super.debug(message);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, null);
        }
    }

    public void debug(@Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t);
        }
    }

    public void debug(@NonNls String message, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(message, t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, t);
        }
    }

    public void info(@NonNls String message) {
        super.info(message);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, null);
    }

    public void info(@NonNls String message, @Nullable Throwable t) {
        super.info(message, t);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, t);
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            super.trace(message);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, message, null);
        }
    }

    public void trace(@Nullable Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(t);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, null, t);
        }
    }

    public boolean isDebugEnabled() {
        if (ApplicationInfoImpl.isInStressTest()) {
            return super.isDebugEnabled();
        }
        return true;
    }
}

