/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.EmptyFileBasedIndex;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.junit.internal.MethodSorter;

public interface TestIndexingModeSupporter {
    public void setIndexingMode(@NotNull IndexingMode var1);

    @NotNull
    public IndexingMode getIndexingMode();

    public static void addTest(@NotNull Class<? extends TestIndexingModeSupporter> aClass, @NotNull IndexingModeTestHandler handler, @NotNull TestSuite parentSuite) {
        if (handler.shouldIgnore(aClass)) {
            return;
        }
        try {
            TestSuite suite = handler.createTestSuite();
            suite.setName(aClass.getSimpleName());
            boolean foundTests = false;
            Constructor<? extends TestIndexingModeSupporter> constructor = aClass.getConstructor(new Class[0]);
            for (Method declaredMethod : MethodSorter.getDeclaredMethods(aClass)) {
                String methodName;
                if (!Modifier.isPublic(declaredMethod.getModifiers()) || !(methodName = declaredMethod.getName()).startsWith("test") || TestFrameworkUtil.isPerformanceTest((String)methodName, (String)aClass.getName()) || handler.shouldIgnore(declaredMethod, aClass)) continue;
                TestIndexingModeSupporter aCase = constructor.newInstance(new Object[0]);
                aCase.setIndexingMode(handler.getIndexingMode());
                if (aCase instanceof TestCase) {
                    TestCase testCase = (TestCase)aCase;
                    testCase.setName(methodName);
                    suite.addTest((Test)testCase);
                } else {
                    parentSuite.addTest(TestSuite.warning((String)(aClass.getName() + "is not a TestSuite")));
                }
                foundTests = true;
            }
            if (foundTests) {
                parentSuite.addTest((Test)suite);
            }
        }
        catch (NoSuchMethodException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to find default constructor for " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to instantiate " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
    }

    public static abstract class IndexingModeTestHandler {
        public final String myTestSuiteName;
        public final String myTestNamePrefix;

        protected IndexingModeTestHandler(@NotNull String testSuiteName, @NotNull String testNamePrefix) {
            this.myTestSuiteName = testSuiteName;
            this.myTestNamePrefix = testNamePrefix;
        }

        public TestSuite createTestSuite() {
            return new NamedTestSuite(this.myTestSuiteName, this.myTestNamePrefix);
        }

        public abstract boolean shouldIgnore(@NotNull Class<? extends TestIndexingModeSupporter> var1);

        public abstract boolean shouldIgnore(@NotNull Method var1, @NotNull Class<? extends TestIndexingModeSupporter> var2);

        @NotNull
        public abstract IndexingMode getIndexingMode();

        private static class NamedTestSuite
        extends TestSuite {
            private final String myPrefix;

            private NamedTestSuite(String name, String prefix) {
                super(name);
                this.myPrefix = prefix;
            }

            public void setName(String name) {
                super.setName(this.myPrefix + name);
            }
        }
    }

    public static enum IndexingMode {
        SMART{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
            }
        }
        ,
        DUMB_FULL_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                IndexingMode.indexEverythingAndBecomeDumb(project2);
            }

            @Override
            public void ensureIndexingStatus(@NotNull Project project2) {
                DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    dumbService.setDumb(false);
                    dumbService.queueTask((DumbModeTask)new UnindexedFilesUpdater(project2));
                    dumbService.setDumb(true);
                });
            }
        }
        ,
        DUMB_RUNTIME_ONLY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                IndexingMode.becomeDumb(project2);
            }
        }
        ,
        DUMB_EMPTY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                ServiceContainerUtil.replaceService((ComponentManager)ApplicationManager.getApplication(), FileBasedIndex.class, new EmptyFileBasedIndex(), testRootDisposable);
                IndexingMode.becomeDumb(project2);
            }
        };


        public abstract void setUpTest(@NotNull Project var1, @NotNull Disposable var2);

        public void ensureIndexingStatus(@NotNull Project project2) {
        }

        private static void becomeDumb(@NotNull Project project2) {
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(true));
        }

        private static void indexEverythingAndBecomeDumb(@NotNull Project project2) {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                dumbService.setDumb(false);
                dumbService.queueTask((DumbModeTask)new UnindexedFilesUpdater(project2));
                dumbService.setDumb(true);
            });
        }
    }
}

