/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.IdeaLogger;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeProjectLifecycleListener;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static SdkLeakTracker myOldSdks;
    private ThreadTracker myThreadTracker;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;

    protected Project getProject() {
        return ourProject;
    }

    protected Module getModule() {
        return ourModule;
    }

    @NotNull
    protected PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)this.getProject());
        }
        return ourPsiManager;
    }

    public static TestApplicationManager getApplication() {
        return TestApplicationManager.getInstanceIfCreated();
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']%n", MockApplication.INSTANCES_CREATED);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']%n", TestProjectManager.Companion.getTotalCreatedProjectCount());
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']%n", totalGcTime);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']%n", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount());
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) {
        ourProjectDescriptor = descriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        Path tempDirectory = TemporaryDirectory.generateTemporaryPath("light_temp.ipr");
        ourProject = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().newProject(tempDirectory, FixtureRuleKt.createTestOpenProjectOptions()));
        HeavyPlatformTestCase.synchronizeTempDirVfs(tempDirectory);
        ourPsiManager = null;
        try {
            ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

                @Override
                public void moduleCreated(@NotNull Module module2) {
                    ourModule = module2;
                }

                @Override
                public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                    ourSourceRoot = sourceRoot;
                }
            });
        }
        catch (Throwable e) {
            try {
                LightPlatformTestCase.closeAndDeleteProject();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new RuntimeException(e);
        }
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            testAppManager.setDataProvider(this);
            LightProjectDescriptor descriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
            this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(() -> this.isStressTest() || ApplicationManager.getApplication() == null || ApplicationManager.getApplication() instanceof MockApplication ? null : CodeStyle.getDefaultSettings());
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return new SimpleLightProjectDescriptor(this.getModuleTypeId(), this.getProjectJDK());
    }

    @NotNull
    public static Pair.NonNull<Project, Module> doSetup(@NotNull LightProjectDescriptor descriptor, LocalInspectionTool @NotNull [] localInspectionTools, @NotNull Disposable parentDisposable) {
        Application app = ApplicationManager.getApplication();
        Ref reusedProject = new Ref((Object)true);
        app.invokeAndWait(() -> {
            IdeaLogger.ourErrorsOccurred = null;
            app.assertIsDispatchThread();
            myOldSdks = new SdkLeakTracker();
            if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
                LightPlatformTestCase.initProject(descriptor);
                reusedProject.set((Object)false);
            }
            descriptor.registerSdk(parentDisposable);
        });
        Project project2 = ourProject;
        try {
            PlatformTestUtil.openProject(project2);
        }
        catch (Throwable e) {
            LightPlatformTestCase.setProject(null);
            throw e;
        }
        Ref result2 = new Ref();
        app.invokeAndWait(() -> {
            if (((Boolean)reusedProject.get()).booleanValue()) {
                WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project2).makeRootsChange(EmptyRunnable.getInstance(), false, true));
            }
            MessageBusConnection connection = project2.getMessageBus().connect(parentDisposable);
            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                    TestCase.fail((String)"Adding modules is not permitted in light tests.");
                }
            });
            LightPlatformTestCase.clearUncommittedDocuments(project2);
            InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, project2, parentDisposable);
            LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed());
            Boolean passed = null;
            try {
                passed = StartupManagerEx.getInstanceEx((Project)project2).startupActivityPassed();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LightPlatformTestCase.assertTrue((String)("open: " + project2.isOpen() + "; disposed:" + project2.isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)project2.isInitialized());
            CodeStyle.setTemporarySettings((Project)project2, (CodeStyleSettings)CodeStyle.createTestSettings());
            FileDocumentManager manager2 = FileDocumentManager.getInstance();
            if (manager2 instanceof FileDocumentManagerImpl) {
                Document[] unsavedDocuments = manager2.getUnsavedDocuments();
                manager2.saveAllDocuments();
                app.runWriteAction(() -> ((FileDocumentManagerImpl)((FileDocumentManagerImpl)manager2)).dropAllUnsavedDocuments());
                LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
            }
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
            result2.set((Object)Pair.createNonNull((Object)project2, (Object)ourModule));
        });
        return (Pair.NonNull)result2.get();
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        InspectionsKt.enableInspectionTool(this.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        InspectionsKt.enableInspectionTool(this.getProject(), tool, this.getTestRootDisposable());
    }

    protected LocalInspectionTool @NotNull [] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        RunAll.runAll(() -> {
            if (ApplicationManager.getApplication() != null) {
                CodeStyle.dropTemporarySettings((Project)project2);
            }
        }, () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            StartMarkAction.checkCleared((Project)project2);
            InplaceRefactoring.checkCleared();
        }, () -> {
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
        }, () -> {
            if (project2 != null) {
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).clearScopesCachesForModules();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> super.tearDown(), () -> WriteAction.runAndWait(() -> {
            if (project2 != null && LegacyBridgeProjectLifecycleListener.Companion.enabled(project2)) {
                ProjectJdkTableImpl jdkTable = (ProjectJdkTableImpl)ProjectJdkTable.getInstance();
                for (Sdk jdk : jdkTable.getAllJdks()) {
                    jdkTable.removeTestJdk(jdk);
                }
            }
        }), () -> myOldSdks.checkForJdkTableLeaks(), () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        });
    }

    static void checkAssertions() throws Exception {
        if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    static void tearDownSourceRoot(@NotNull Project project2) {
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            if (ourSourceRoot != null) {
                try {
                    for (VirtualFile child : ourSourceRoot.getChildren()) {
                        child.delete(LightPlatformTestCase.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clearEncodingManagerDocumentQueue() {
        EncodingManager encodingManager = (EncodingManager)ApplicationManager.getApplication().getServiceIfCreated(EncodingManager.class);
        if (encodingManager instanceof EncodingManagerImpl) {
            ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        RunAll.runAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            EditorFactory editorFactory;
            Application app = ApplicationManager.getApplication();
            EditorFactory editorFactory2 = editorFactory = app == null ? null : (EditorFactory)app.getServiceIfCreated(EditorFactory.class);
            if (editorFactory == null) {
                return;
            }
            RunAll runAll = new RunAll(new ThrowableRunnable[0]);
            for (Editor editor : editorFactory.getAllEditors()) {
                runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError((Editor)editor), () -> editorFactory.releaseEditor(editor));
            }
            runAll.run();
        });
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareImpl(this::startRunAndTear);
    }

    protected void runBareImpl(ThrowableRunnable<?> start) throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        ThrowableRunnable testRunnable = () -> {
            try {
                start.run();
            }
            finally {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    try {
                        Application application = ApplicationManager.getApplication();
                        if (application instanceof ApplicationEx) {
                            HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                        }
                        this.resetAllFields();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }));
            }
        };
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)testRunnable);
        } else {
            testRunnable.run();
        }
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.tearDown()));
        }
    }

    public Object getData(@NotNull String dataId) {
        return this.getProject() == null || this.getProject().isDisposed() ? null : new TestDataProvider(this.getProject()).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected String getModuleTypeId() {
        return "EMPTY_MODULE";
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    @NotNull
    protected PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyle.getSettings((Project)this.getProject());
    }

    @NotNull
    protected CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        return this.getCurrentCodeStyleSettings().getCommonSettings(language);
    }

    @NotNull
    protected <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> settingsClass) {
        return (T)this.getCurrentCodeStyleSettings().getCustomSettings(settingsClass);
    }

    protected void commitDocument(@NotNull Document document2) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document2);
    }

    protected void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    protected Document getDocument(@NotNull PsiFile file2) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    public static synchronized void closeAndDeleteProject() {
        Project project2 = ourProject;
        if (project2 == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!project2.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)project2, (Object)ourModule.getProject());
            Path ioFile = Paths.get(project2.getProjectFilePath(), new String[0]);
            if (Files.exists(ioFile, new LinkOption[0])) {
                Path dir = ioFile.getParent();
                if (dir.getFileName().toString().startsWith("unitTest_")) {
                    PathKt.delete((Path)dir);
                } else {
                    PathKt.delete((Path)ioFile);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().forceCloseProject(project2));
        LightPlatformTestCase.assertTrue((boolean)project2.isDisposed());
        LightPlatformTestCase.setProject(null);
        LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
        ourModule = null;
        if (ourPsiManager != null) {
            LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
            ourPsiManager = null;
        }
    }

    protected static void setProject(Project project2) {
        ourProject = project2;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final String myModuleTypeId;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull String moduleTypeId, @Nullable Sdk sdk) {
            this.myModuleTypeId = moduleTypeId;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public String getModuleTypeId() {
            return this.myModuleTypeId;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleTypeId.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            OrderRootType[] rootTypes;
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            if (!this.mySdk.getName().equals(newSdk.getName())) {
                return false;
            }
            for (OrderRootType rootType : rootTypes = new OrderRootType[]{OrderRootType.CLASSES, AnnotationOrderRootType.getInstance()}) {
                Object[] myUrls = this.mySdk.getRootProvider().getUrls(rootType);
                Object[] newUrls = newSdk.getRootProvider().getUrls(rootType);
                if (ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls))) continue;
                return false;
            }
            return true;
        }
    }
}

