/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    private long modificationTimeStamp;
    private final List<String> variables = new SmartList();
    private final Editor editor;
    private final boolean myCanBeReplace;
    @Nullable
    private final Consumer<? super String> myCurrentVariableCallback;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");
    private final Map<String, Inlay<FilterRenderer>> inlays = new HashMap<String, Inlay<FilterRenderer>>();

    private SubstitutionShortInfoHandler(@NotNull Editor _editor, boolean canBeReplace, @Nullable Consumer<? super String> currentVariableCallback) {
        this.editor = _editor;
        this.myCanBeReplace = canBeReplace;
        this.myCurrentVariableCallback = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        this.handleInputFocusMovement(e.getLogicalPosition(), false);
    }

    private void handleInputFocusMovement(LogicalPosition position, boolean caret) {
        String currentVariableName;
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        Document document2 = this.editor.getDocument();
        int lineCount = document2.getLineCount();
        if (position.line >= lineCount) {
            return;
        }
        int lineStart = document2.getLineStartOffset(position.line);
        int lineEnd = document2.getLineEndOffset(position.line);
        CharSequence patternText = document2.getCharsSequence().subSequence(lineStart, lineEnd);
        TextRange variableRange = TemplateImplUtil.findVariableAtOffset((CharSequence)patternText, (int)position.column);
        if (variableRange == null) {
            if (caret) {
                if (this.myCurrentVariableCallback != null) {
                    this.myCurrentVariableCallback.accept("__context__");
                }
                configuration.setCurrentVariableName("__context__");
            }
            return;
        }
        String variableName = variableRange.subSequence(patternText).toString();
        NamedScriptableDefinition variable = configuration.findVariable(variableName);
        String filterText = StringUtil.escapeXmlEntities((String)SubstitutionShortInfoHandler.getShortParamString(variable, false));
        if (!this.editor.isViewer() && !variableName.equals(configuration.getCurrentVariableName())) {
            filterText = SubstitutionShortInfoHandler.appendLinkText(filterText, variableName);
        }
        boolean replacementVariable = variable instanceof ReplacementVariableDefinition || this.myCanBeReplace && variable == null && configuration instanceof ReplaceConfiguration;
        String string = currentVariableName = replacementVariable ? variableName + "$replacement" : variableName;
        if (caret) {
            if (this.myCurrentVariableCallback != null) {
                this.myCurrentVariableCallback.accept(currentVariableName);
            }
            configuration.setCurrentVariableName(currentVariableName);
        }
        if (!filterText.isEmpty()) {
            LogicalPosition toolTipPosition = new LogicalPosition(position.line, variableRange.getStartOffset() + (variableRange.getEndOffset() - variableRange.getStartOffset() >> 1));
            SubstitutionShortInfoHandler.showTooltip(this.editor, toolTipPosition, filterText);
        }
    }

    @NotNull
    static String appendLinkText(String text, String variableName) {
        String linkColor = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor());
        return text + "<br><a style=\"color:" + linkColor + "\" href=\"#ssr_edit_filters/" + variableName + "\">Edit filters</a>";
    }

    private void checkModelValidity() {
        Document document2 = this.editor.getDocument();
        if (this.modificationTimeStamp != document2.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariableNames((CharSequence)document2.getCharsSequence()));
            this.modificationTimeStamp = document2.getModificationStamp();
            this.updateEditorInlays();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        this.handleInputFocusMovement(e.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        this.handleInputFocusMovement(this.editor.getCaretModel().getLogicalPosition(), true);
        this.updateEditorInlays();
    }

    public List<String> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition, boolean verbose) {
        String script;
        if (namedScriptableDefinition == null) {
            return verbose ? SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]) : "";
        }
        StringBuilder buf = new StringBuilder();
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            MatchVariableConstraint constraint = (MatchVariableConstraint)namedScriptableDefinition;
            String name = constraint.getName();
            if (!"__context__".equals(name)) {
                int maxCount = constraint.getMaxCount();
                int minCount = constraint.getMinCount();
                if (verbose || minCount != 1 || maxCount != 1) {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("min.occurs.tooltip.message", minCount, maxCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxCount)));
                }
            }
            if (constraint.isPartOfSearchResults() && verbose) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (!constraint.getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? 1 : 0, constraint.getRegExp(), constraint.isWholeWordsOnly() ? 1 : 0, constraint.isWithinHierarchy() ? 1 : 0));
            } else if (constraint.isWithinHierarchy()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)constraint.getReferenceConstraint())) {
                String text = StringUtil.unquoteString((String)constraint.getReferenceConstraint());
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("reference.target.tooltip.message", constraint.isInvertReference() ? 1 : 0, text));
            }
            if (!constraint.getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? 1 : 0, constraint.isRegexExprType() ? constraint.getNameOfExprType() : constraint.getExpressionTypes(), constraint.isExprTypeWithinHierarchy() ? 1 : 0));
            }
            if (!constraint.getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? 1 : 0, constraint.isRegexFormalType() ? constraint.getNameOfFormalArgType() : constraint.getExpectedTypes(), constraint.isFormalArgTypeWithinHierarchy() ? 1 : 0));
            }
            if (StringUtil.isNotEmpty((String)constraint.getWithinConstraint())) {
                String text = StringUtil.unquoteString((String)constraint.getWithinConstraint());
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("within.constraints.tooltip.message", constraint.isInvertWithinConstraint() ? 1 : 0, text));
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()).length() > 2) {
            SubstitutionShortInfoHandler.append(buf, SSRBundle.message("script.tooltip.message", new Object[0]));
        }
        if (buf.length() == 0 && verbose) {
            buf.append(SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]));
        }
        return buf.toString();
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    private static void showTooltip(@NotNull Editor editor, LogicalPosition position, @NotNull String text) {
        if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point point = editor.logicalPositionToXY(position);
        point.y += editor.getLineHeight();
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), point, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, point).setAwtTooltip(true).setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, p, text, visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return editor == null ? null : (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor, Disposable disposable) {
        SubstitutionShortInfoHandler.install(editor, null, disposable, false);
    }

    static void install(Editor editor, @Nullable Consumer<? super String> currentVariableCallback, Disposable disposable, boolean replace) {
        SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor, replace, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler, disposable);
        editor.getDocument().addDocumentListener((DocumentListener)handler, disposable);
        editor.getCaretModel().addCaretListener((CaretListener)handler, disposable);
        editor.putUserData(LISTENER_KEY, (Object)handler);
    }

    static void updateEditorInlays(Editor editor) {
        SubstitutionShortInfoHandler handler = SubstitutionShortInfoHandler.retrieve(editor);
        if (handler != null) {
            handler.updateEditorInlays();
        }
    }

    void updateEditorInlays() {
        if (!Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        String text = this.editor.getDocument().getText();
        Template template = TemplateManager.getInstance((Project)this.editor.getProject()).createTemplate("", "", text);
        int segmentsCount = template.getSegmentsCount();
        InlayModel inlayModel = this.editor.getInlayModel();
        HashSet<String> variables = new HashSet<String>(this.inlays.keySet());
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        int variableNameLength = 0;
        for (int i2 = 0; i2 < segmentsCount; ++i2) {
            int offset = template.getSegmentOffset(i2);
            String name = template.getSegmentName(i2);
            variableNameLength += name.length() + 2;
            NamedScriptableDefinition namedScriptableDefinition = configuration.findVariable(name);
            String labelText = SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition, false);
            if (labelText.isEmpty()) continue;
            variables.remove(name);
            Inlay<FilterRenderer> inlay = this.inlays.get(name);
            if (inlay == null) {
                this.inlays.put(name, (Inlay<FilterRenderer>)inlayModel.addInlineElement(offset + variableNameLength, (EditorCustomElementRenderer)new FilterRenderer(labelText)));
                continue;
            }
            FilterRenderer renderer = (FilterRenderer)inlay.getRenderer();
            renderer.setText(labelText);
            inlay.update();
        }
        NamedScriptableDefinition contextVariable = configuration.findVariable("__context__");
        String labelText = SubstitutionShortInfoHandler.getShortParamString(contextVariable, false);
        if (!labelText.isEmpty()) {
            variables.remove("__context__");
            Inlay<FilterRenderer> inlay = this.inlays.get("__context__");
            if (inlay == null) {
                this.inlays.put("__context__", (Inlay<FilterRenderer>)inlayModel.addBlockElement(text.length() + variableNameLength, true, false, 0, (EditorCustomElementRenderer)new FilterRenderer("whole template: " + labelText)));
            } else {
                FilterRenderer filterRenderer = (FilterRenderer)inlay.getRenderer();
                filterRenderer.setText("whole template: " + labelText);
                inlay.update();
            }
        }
        for (String string : variables) {
            Disposer.dispose((Disposable)((Disposable)this.inlays.remove(string)));
        }
    }

    private static class FilterRenderer
    implements EditorCustomElementRenderer {
        private String myText;

        FilterRenderer(String text) {
            this.myText = text;
        }

        public void setText(String text) {
            this.myText = text;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            return FilterRenderer.getFontMetrics(inlay.getEditor()).stringWidth(this.myText) + 12;
        }

        private static Font getFont() {
            return UIManager.getFont("Label.font");
        }

        private static FontMetrics getFontMetrics(Editor editor) {
            return editor.getContentComponent().getFontMetrics(FilterRenderer.getFont());
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Color foregroundColor;
            Editor editor = inlay.getEditor();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
            if (attributes == null) {
                return;
            }
            FontMetrics metrics = FilterRenderer.getFontMetrics(editor);
            Color backgroundColor = attributes.getBackgroundColor();
            if (backgroundColor != null) {
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.55f);
                g.setColor(backgroundColor);
                g.fillRoundRect(r.x + 2, r.y, r.width - 4, r.height, 8, 8);
                config.restore();
            }
            if ((foregroundColor = attributes.getForegroundColor()) != null) {
                g.setColor(foregroundColor);
                g.setFont(FilterRenderer.getFont());
                g.drawString(this.myText, r.x + 6, r.y + metrics.getAscent());
            }
        }
    }
}

