/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.StructuralSearchUtil;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MatchVariableConstraint
extends NamedScriptableDefinition {
    @NotNull
    private String regExp = "";
    private boolean invertRegExp;
    private boolean withinHierarchy;
    private boolean strictlyWithinHierarchy;
    private boolean wholeWordsOnly;
    private int minCount = 1;
    private int maxCount = 1;
    private boolean greedy = true;
    private boolean invertReference;
    @NotNull
    private String referenceConstraint = "";
    private boolean partOfSearchResults;
    @NotNull
    private String nameOfExprType = "";
    @NotNull
    private String expressionTypes = "";
    private boolean invertExprType;
    private boolean exprTypeWithinHierarchy;
    @NotNull
    private String nameOfFormalArgType = "";
    @NotNull
    private String expectedTypes = "";
    private boolean invertFormalType;
    private boolean formalArgTypeWithinHierarchy;
    @NotNull
    private String withinConstraint = "";
    @NotNull
    private String containsConstraint = "";
    private boolean invertContainsConstraint;
    private boolean invertWithinConstraint;
    @NotNull
    private String contextConstraint = "";
    @NonNls
    private static final String REFERENCE_CONDITION = "reference";
    @NonNls
    private static final String NAME_OF_EXPRTYPE = "nameOfExprType";
    @NonNls
    private static final String NAME_OF_FORMALTYPE = "nameOfFormalType";
    @NonNls
    private static final String REGEXP = "regexp";
    @NonNls
    private static final String EXPRTYPE_WITHIN_HIERARCHY = "exprTypeWithinHierarchy";
    @NonNls
    private static final String FORMALTYPE_WITHIN_HIERARCHY = "formalTypeWithinHierarchy";
    @NonNls
    private static final String WITHIN_HIERARCHY = "withinHierarchy";
    @NonNls
    private static final String MAX_OCCURS = "maxCount";
    @NonNls
    private static final String MIN_OCCURS = "minCount";
    @NonNls
    private static final String NEGATE_NAME_CONDITION = "negateName";
    @NonNls
    private static final String NEGATE_EXPRTYPE_CONDITION = "negateExprType";
    @NonNls
    private static final String NEGATE_FORMALTYPE_CONDITION = "negateFormalType";
    @NonNls
    private static final String NEGATE_CONTAINS_CONDITION = "negateContains";
    @NonNls
    private static final String NEGATE_WITHIN_CONDITION = "negateWithin";
    @NonNls
    private static final String NEGATE_REFERENCE_CONDITION = "negateReference";
    @NonNls
    private static final String WITHIN_CONDITION = "within";
    @NonNls
    private static final String CONTAINS_CONDITION = "contains";
    @NonNls
    private static final String TARGET = "target";
    @NonNls
    private static final String CONTEXT = "context";
    @NonNls
    private static final String WHOLE_WORDS_ONLY = "wholeWordsOnly";
    @NonNls
    private static final String TRUE = Boolean.TRUE.toString();

    public MatchVariableConstraint() {
    }

    public MatchVariableConstraint(String name) {
        this.setName(name);
    }

    MatchVariableConstraint(MatchVariableConstraint constraint) {
        super(constraint);
        this.regExp = constraint.regExp;
        this.invertRegExp = constraint.invertRegExp;
        this.withinHierarchy = constraint.withinHierarchy;
        this.strictlyWithinHierarchy = constraint.strictlyWithinHierarchy;
        this.wholeWordsOnly = constraint.wholeWordsOnly;
        this.minCount = constraint.minCount;
        this.maxCount = constraint.maxCount;
        this.greedy = constraint.greedy;
        this.invertReference = constraint.invertReference;
        this.referenceConstraint = constraint.referenceConstraint;
        this.partOfSearchResults = constraint.partOfSearchResults;
        this.nameOfExprType = constraint.nameOfExprType;
        this.expressionTypes = constraint.expressionTypes;
        this.invertExprType = constraint.invertExprType;
        this.exprTypeWithinHierarchy = constraint.exprTypeWithinHierarchy;
        this.nameOfFormalArgType = constraint.nameOfFormalArgType;
        this.expectedTypes = constraint.expectedTypes;
        this.invertFormalType = constraint.invertFormalType;
        this.formalArgTypeWithinHierarchy = constraint.formalArgTypeWithinHierarchy;
        this.withinConstraint = constraint.withinConstraint;
        this.containsConstraint = constraint.containsConstraint;
        this.invertContainsConstraint = constraint.invertContainsConstraint;
        this.invertWithinConstraint = constraint.invertWithinConstraint;
        this.contextConstraint = constraint.contextConstraint;
    }

    @Override
    public MatchVariableConstraint copy() {
        return new MatchVariableConstraint(this);
    }

    @NotNull
    static String convertRegExpTypeToTypeString(@NotNull String regexp) {
        StringBuilder result2 = new StringBuilder();
        int length = regexp.length();
        for (int i2 = 0; i2 < length; ++i2) {
            int c = regexp.codePointAt(i2);
            if (c == 46) {
                if (i2 == length - 1 || !StructuralSearchUtil.isRegExpMetaChar(regexp.codePointAt(i2 + 1))) {
                    result2.append('.');
                    continue;
                }
                return "";
            }
            if (c == 124) {
                result2.append('|');
                continue;
            }
            if (c == 92) {
                if (i2 + 1 < length) {
                    result2.appendCodePoint(regexp.codePointAt(i2 + 1));
                    ++i2;
                    continue;
                }
                result2.append('\\');
                continue;
            }
            if (c == 93) {
                result2.append(']');
                continue;
            }
            if (c == 40 || c == 41) continue;
            if (StructuralSearchUtil.isRegExpMetaChar(c)) {
                return "";
            }
            result2.appendCodePoint(c);
        }
        return result2.toString();
    }

    @NotNull
    static String convertTypeStringToRegExp(@NotNull String typeString) {
        StringBuilder result2 = new StringBuilder();
        for (String type : StringUtil.split((String)typeString, (String)"|")) {
            if (result2.length() > 0) {
                result2.append('|');
            }
            StructuralSearchUtil.shieldRegExpMetaChars(type.trim(), result2);
        }
        return result2.toString();
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    @NotNull
    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(@NotNull String regExp) {
        this.regExp = regExp;
    }

    public boolean isInvertRegExp() {
        return this.invertRegExp;
    }

    public void setInvertRegExp(boolean invertRegExp) {
        this.invertRegExp = invertRegExp;
    }

    public boolean isWithinHierarchy() {
        return this.withinHierarchy;
    }

    public void setWithinHierarchy(boolean withinHierarchy) {
        this.withinHierarchy = withinHierarchy;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean isPartOfSearchResults() {
        return this.partOfSearchResults;
    }

    public void setPartOfSearchResults(boolean partOfSearchResults) {
        this.partOfSearchResults = partOfSearchResults;
    }

    public boolean isInvertReference() {
        return this.invertReference;
    }

    public void setInvertReference(boolean invertReference) {
        this.invertReference = invertReference;
    }

    @NotNull
    public String getReferenceConstraint() {
        return this.referenceConstraint;
    }

    public void setReferenceConstraint(@NotNull String nameOfReferenceVar) {
        this.referenceConstraint = nameOfReferenceVar;
    }

    public boolean isStrictlyWithinHierarchy() {
        return this.strictlyWithinHierarchy;
    }

    public void setStrictlyWithinHierarchy(boolean strictlyWithinHierarchy) {
        this.strictlyWithinHierarchy = strictlyWithinHierarchy;
    }

    @NotNull
    public String getNameOfExprType() {
        return this.nameOfExprType;
    }

    @NotNull
    public String getExpressionTypes() {
        return this.expressionTypes;
    }

    public void setNameOfExprType(@NotNull String nameOfExprType) {
        this.nameOfExprType = nameOfExprType;
        this.expressionTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(nameOfExprType);
    }

    public void setExpressionTypes(@NotNull String expressionTypes) {
        this.expressionTypes = expressionTypes;
        this.nameOfExprType = MatchVariableConstraint.convertTypeStringToRegExp(expressionTypes);
    }

    public boolean isRegexExprType() {
        return StringUtil.isEmpty((String)this.expressionTypes) && !StringUtil.isEmpty((String)this.nameOfExprType);
    }

    public boolean isInvertExprType() {
        return this.invertExprType;
    }

    public void setInvertExprType(boolean invertExprType) {
        this.invertExprType = invertExprType;
    }

    public boolean isExprTypeWithinHierarchy() {
        return this.exprTypeWithinHierarchy;
    }

    public void setExprTypeWithinHierarchy(boolean exprTypeWithinHierarchy) {
        this.exprTypeWithinHierarchy = exprTypeWithinHierarchy;
    }

    public boolean isWholeWordsOnly() {
        return this.wholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.wholeWordsOnly = wholeWordsOnly;
    }

    @NotNull
    public String getNameOfFormalArgType() {
        return this.nameOfFormalArgType;
    }

    @NotNull
    public String getExpectedTypes() {
        return this.expectedTypes;
    }

    public void setNameOfFormalArgType(@NotNull String nameOfFormalArgType) {
        this.nameOfFormalArgType = nameOfFormalArgType;
        this.expectedTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(nameOfFormalArgType);
    }

    public void setExpectedTypes(@NotNull String expectedTypes) {
        this.expectedTypes = expectedTypes;
        this.nameOfFormalArgType = MatchVariableConstraint.convertTypeStringToRegExp(expectedTypes);
    }

    public boolean isRegexFormalType() {
        return StringUtil.isEmpty((String)this.expectedTypes) && !StringUtil.isEmpty((String)this.nameOfFormalArgType);
    }

    public boolean isInvertFormalType() {
        return this.invertFormalType;
    }

    public void setInvertFormalType(boolean invertFormalType) {
        this.invertFormalType = invertFormalType;
    }

    public boolean isFormalArgTypeWithinHierarchy() {
        return this.formalArgTypeWithinHierarchy;
    }

    public void setFormalArgTypeWithinHierarchy(boolean formalArgTypeWithinHierarchy) {
        this.formalArgTypeWithinHierarchy = formalArgTypeWithinHierarchy;
    }

    @NotNull
    public String getContextConstraint() {
        return this.contextConstraint;
    }

    public void setContextConstraint(@NotNull String contextConstraint) {
        this.contextConstraint = contextConstraint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchVariableConstraint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchVariableConstraint matchVariableConstraint = (MatchVariableConstraint)o;
        if (this.exprTypeWithinHierarchy != matchVariableConstraint.exprTypeWithinHierarchy) {
            return false;
        }
        if (this.formalArgTypeWithinHierarchy != matchVariableConstraint.formalArgTypeWithinHierarchy) {
            return false;
        }
        if (this.greedy != matchVariableConstraint.greedy) {
            return false;
        }
        if (this.invertExprType != matchVariableConstraint.invertExprType) {
            return false;
        }
        if (this.invertFormalType != matchVariableConstraint.invertFormalType) {
            return false;
        }
        if (this.invertReference != matchVariableConstraint.invertReference) {
            return false;
        }
        if (this.invertRegExp != matchVariableConstraint.invertRegExp) {
            return false;
        }
        if (this.maxCount != matchVariableConstraint.maxCount) {
            return false;
        }
        if (this.minCount != matchVariableConstraint.minCount) {
            return false;
        }
        if (this.partOfSearchResults != matchVariableConstraint.partOfSearchResults) {
            return false;
        }
        if (this.strictlyWithinHierarchy != matchVariableConstraint.strictlyWithinHierarchy) {
            return false;
        }
        if (this.wholeWordsOnly != matchVariableConstraint.wholeWordsOnly) {
            return false;
        }
        if (this.withinHierarchy != matchVariableConstraint.withinHierarchy) {
            return false;
        }
        if (!this.nameOfExprType.equals(matchVariableConstraint.nameOfExprType)) {
            return false;
        }
        if (!this.expressionTypes.equals(matchVariableConstraint.expressionTypes)) {
            return false;
        }
        if (!this.nameOfFormalArgType.equals(matchVariableConstraint.nameOfFormalArgType)) {
            return false;
        }
        if (!this.expectedTypes.equals(matchVariableConstraint.expectedTypes)) {
            return false;
        }
        if (!this.referenceConstraint.equals(matchVariableConstraint.referenceConstraint)) {
            return false;
        }
        if (!this.regExp.equals(matchVariableConstraint.regExp)) {
            return false;
        }
        if (!this.withinConstraint.equals(matchVariableConstraint.withinConstraint)) {
            return false;
        }
        if (!this.containsConstraint.equals(matchVariableConstraint.containsConstraint)) {
            return false;
        }
        if (this.invertWithinConstraint != matchVariableConstraint.invertWithinConstraint) {
            return false;
        }
        if (this.invertContainsConstraint != matchVariableConstraint.invertContainsConstraint) {
            return false;
        }
        return this.contextConstraint.equals(matchVariableConstraint.contextConstraint);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 29 * result2 + this.regExp.hashCode();
        result2 = 29 * result2 + (this.invertRegExp ? 1 : 0);
        result2 = 29 * result2 + (this.withinHierarchy ? 1 : 0);
        result2 = 29 * result2 + (this.strictlyWithinHierarchy ? 1 : 0);
        result2 = 29 * result2 + (this.wholeWordsOnly ? 1 : 0);
        result2 = 29 * result2 + this.minCount;
        result2 = 29 * result2 + this.maxCount;
        result2 = 29 * result2 + (this.greedy ? 1 : 0);
        result2 = 29 * result2 + (this.invertReference ? 1 : 0);
        result2 = 29 * result2 + this.referenceConstraint.hashCode();
        result2 = 29 * result2 + (this.partOfSearchResults ? 1 : 0);
        result2 = 29 * result2 + this.nameOfExprType.hashCode();
        result2 = 29 * result2 + this.expressionTypes.hashCode();
        result2 = 29 * result2 + (this.invertExprType ? 1 : 0);
        result2 = 29 * result2 + (this.exprTypeWithinHierarchy ? 1 : 0);
        result2 = 29 * result2 + this.nameOfFormalArgType.hashCode();
        result2 = 29 * result2 + this.expectedTypes.hashCode();
        result2 = 29 * result2 + (this.invertFormalType ? 1 : 0);
        result2 = 29 * result2 + (this.formalArgTypeWithinHierarchy ? 1 : 0);
        result2 = 29 * result2 + this.withinConstraint.hashCode();
        result2 = 29 * result2 + this.containsConstraint.hashCode();
        result2 = 29 * result2 + this.contextConstraint.hashCode();
        if (this.invertContainsConstraint) {
            result2 = 29 * result2 + 1;
        }
        if (this.invertWithinConstraint) {
            result2 = 29 * result2 + 1;
        }
        return result2;
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.regExp = StringUtil.notNullize((String)element.getAttributeValue(REGEXP));
        this.withinHierarchy = MatchVariableConstraint.getBooleanValue(element, WITHIN_HIERARCHY, false);
        this.invertRegExp = MatchVariableConstraint.getBooleanValue(element, NEGATE_NAME_CONDITION, false);
        this.wholeWordsOnly = MatchVariableConstraint.getBooleanValue(element, WHOLE_WORDS_ONLY, false);
        this.nameOfExprType = StringUtil.notNullize((String)element.getAttributeValue(NAME_OF_EXPRTYPE));
        this.expressionTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(this.nameOfExprType);
        this.exprTypeWithinHierarchy = MatchVariableConstraint.getBooleanValue(element, EXPRTYPE_WITHIN_HIERARCHY, false);
        this.invertExprType = MatchVariableConstraint.getBooleanValue(element, NEGATE_EXPRTYPE_CONDITION, false);
        this.nameOfFormalArgType = StringUtil.notNullize((String)element.getAttributeValue(NAME_OF_FORMALTYPE));
        this.expectedTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(this.nameOfFormalArgType);
        this.formalArgTypeWithinHierarchy = MatchVariableConstraint.getBooleanValue(element, FORMALTYPE_WITHIN_HIERARCHY, false);
        this.invertFormalType = MatchVariableConstraint.getBooleanValue(element, NEGATE_FORMALTYPE_CONDITION, false);
        this.minCount = MatchVariableConstraint.getIntValue(element, MIN_OCCURS, 1);
        this.maxCount = MatchVariableConstraint.getIntValue(element, MAX_OCCURS, 1);
        this.referenceConstraint = StringUtil.notNullize((String)element.getAttributeValue(REFERENCE_CONDITION));
        this.invertReference = MatchVariableConstraint.getBooleanValue(element, NEGATE_REFERENCE_CONDITION, false);
        this.containsConstraint = StringUtil.notNullize((String)element.getAttributeValue(CONTAINS_CONDITION));
        this.invertContainsConstraint = MatchVariableConstraint.getBooleanValue(element, NEGATE_CONTAINS_CONDITION, false);
        this.withinConstraint = StringUtil.notNullize((String)element.getAttributeValue(WITHIN_CONDITION));
        this.invertWithinConstraint = MatchVariableConstraint.getBooleanValue(element, NEGATE_WITHIN_CONDITION, false);
        this.partOfSearchResults = MatchVariableConstraint.getBooleanValue(element, TARGET, false);
        this.contextConstraint = StringUtil.notNullize((String)element.getAttributeValue(CONTEXT));
    }

    public static boolean getBooleanValue(Element element, String attributeName, boolean defaultValue) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            try {
                return attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntValue(Element element, String attributeName, int defaultValue) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            try {
                return attribute.getIntValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (!this.regExp.isEmpty()) {
            element.setAttribute(REGEXP, this.regExp);
        }
        if (!this.nameOfExprType.isEmpty()) {
            element.setAttribute(NAME_OF_EXPRTYPE, this.nameOfExprType);
        }
        if (!this.referenceConstraint.isEmpty()) {
            element.setAttribute(REFERENCE_CONDITION, this.referenceConstraint);
        }
        if (!this.nameOfFormalArgType.isEmpty()) {
            element.setAttribute(NAME_OF_FORMALTYPE, this.nameOfFormalArgType);
        }
        if (this.withinHierarchy) {
            element.setAttribute(WITHIN_HIERARCHY, TRUE);
        }
        if (this.exprTypeWithinHierarchy) {
            element.setAttribute(EXPRTYPE_WITHIN_HIERARCHY, TRUE);
        }
        if (this.formalArgTypeWithinHierarchy) {
            element.setAttribute(FORMALTYPE_WITHIN_HIERARCHY, TRUE);
        }
        if (this.minCount != 1) {
            element.setAttribute(MIN_OCCURS, String.valueOf(this.minCount));
        }
        if (this.maxCount != 1) {
            element.setAttribute(MAX_OCCURS, String.valueOf(this.maxCount));
        }
        if (this.partOfSearchResults) {
            element.setAttribute(TARGET, TRUE);
        }
        if (this.invertRegExp) {
            element.setAttribute(NEGATE_NAME_CONDITION, TRUE);
        }
        if (this.invertExprType) {
            element.setAttribute(NEGATE_EXPRTYPE_CONDITION, TRUE);
        }
        if (this.invertFormalType) {
            element.setAttribute(NEGATE_FORMALTYPE_CONDITION, TRUE);
        }
        if (this.invertReference) {
            element.setAttribute(NEGATE_REFERENCE_CONDITION, TRUE);
        }
        if (this.wholeWordsOnly) {
            element.setAttribute(WHOLE_WORDS_ONLY, TRUE);
        }
        if (this.invertContainsConstraint) {
            element.setAttribute(NEGATE_CONTAINS_CONDITION, TRUE);
        }
        if (this.invertWithinConstraint) {
            element.setAttribute(NEGATE_WITHIN_CONDITION, TRUE);
        }
        element.setAttribute(WITHIN_CONDITION, this.withinConstraint);
        element.setAttribute(CONTAINS_CONDITION, this.containsConstraint);
        if (!this.contextConstraint.isEmpty()) {
            element.setAttribute(CONTEXT, this.contextConstraint);
        }
    }

    @NotNull
    public String getWithinConstraint() {
        return this.withinConstraint;
    }

    public void setWithinConstraint(@NotNull String withinConstraint) {
        this.withinConstraint = withinConstraint;
    }

    @NotNull
    public String getContainsConstraint() {
        return this.containsConstraint;
    }

    public void setContainsConstraint(@NotNull String containsConstraint) {
        this.containsConstraint = containsConstraint;
    }

    public boolean isInvertContainsConstraint() {
        return this.invertContainsConstraint;
    }

    public void setInvertContainsConstraint(boolean invertContainsConstraint) {
        this.invertContainsConstraint = invertContainsConstraint;
    }

    public boolean isInvertWithinConstraint() {
        return this.invertWithinConstraint;
    }

    public void setInvertWithinConstraint(boolean invertWithinConstraint) {
        this.invertWithinConstraint = invertWithinConstraint;
    }
}

