/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, IntArrayList> {
    static boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.duplicates.online.calculation", (boolean)true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, IntArrayList> NAME = ID.create((String)"DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = file2 -> {
        if (!ourEnabled || !file2.isInLocalFileSystem()) {
            return false;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(file2.getFileType());
        if (duplicatesProfile instanceof LightDuplicateProfile) {
            return ((LightDuplicateProfile)((Object)duplicatesProfile)).acceptsFile(file2);
        }
        return duplicatesProfile != null;
    };
    private final DataExternalizer<IntArrayList> myValueExternalizer = new DataExternalizer<IntArrayList>(){

        public void save(@NotNull DataOutput out, IntArrayList list) throws IOException {
            if (list.size() == 2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(0));
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(1));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-list.size()));
                int prev = 0;
                int len = list.size();
                for (int i2 = 0; i2 < len; i2 += 2) {
                    int value = list.getInt(i2);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)(value - prev));
                    prev = value;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(i2 + 1));
                }
            }
        }

        public IntArrayList read(@NotNull DataInput in) throws IOException {
            int capacityOrValue = DataInputOutputUtil.readINT((DataInput)in);
            if (capacityOrValue >= 0) {
                IntArrayList list = new IntArrayList(2);
                list.add(capacityOrValue);
                list.add(DataInputOutputUtil.readINT((DataInput)in));
                return list;
            }
            IntArrayList list = new IntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value = DataInputOutputUtil.readINT((DataInput)in) + prev;
                list.add(value);
                prev = value;
                list.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return list;
        }
    };
    private final DataIndexer<Integer, IntArrayList, FileContent> myIndexer = new DataIndexer<Integer, IntArrayList, FileContent>(){

        @NotNull
        public Int2ObjectMap<IntArrayList> map(@NotNull FileContent inputData) {
            FileType type = inputData.getFileType();
            DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(type);
            if (profile == null || !profile.acceptsContentForIndexing(inputData)) {
                return Int2ObjectMaps.emptyMap();
            }
            try {
                PsiDependentFileContent fileContent = (PsiDependentFileContent)inputData;
                if (profile instanceof LightDuplicateProfile) {
                    final Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
                    LighterAST ast = fileContent.getLighterAST();
                    ((LightDuplicateProfile)((Object)profile)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            IntArrayList list = (IntArrayList)result2.get(hash);
                            if (list == null) {
                                list = new IntArrayList(2);
                                result2.put(hash, (Object)list);
                            }
                            list.add(nodes[0].getStartOffset());
                            list.add(hash2);
                        }
                    });
                    return result2;
                }
                MyFragmentsCollector collector = new MyFragmentsCollector(profile, ((LanguageFileType)type).getLanguage());
                DuplocateVisitor visitor = profile.createVisitor(collector, true);
                visitor.visitNode((PsiElement)fileContent.getPsiFile());
                return collector.getMap();
            }
            catch (StackOverflowError ae) {
                return Int2ObjectMaps.emptyMap();
            }
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(language);
        return profile != null && (ourEnabledOldProfiles && profile.supportDuplicatesIndex() || profile instanceof LightDuplicateProfile) ? profile : null;
    }

    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 128 + (ourEnabledOldProfiles ? 33 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<Integer, IntArrayList> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<Integer, IntArrayList, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public DataExternalizer<IntArrayList> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value) {
        boolean old = ourEnabled;
        ourEnabled = value;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value;
        return old;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    private static final class MyFragmentsCollector
    implements FragmentsCollector {
        private final Int2ObjectOpenHashMap<IntArrayList> myMap = new Int2ObjectOpenHashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        MyFragmentsCollector(DuplicatesProfile profile, Language language) {
            this.myProfile = profile;
            this.myDuplocatorState = profile.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            IntArrayList list;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list = (IntArrayList)this.myMap.get(hash)) == null) {
                list = new IntArrayList();
                this.myMap.put(hash, (Object)list);
            }
            list.add(frag.getStartOffset());
            list.add(0);
        }

        public Int2ObjectOpenHashMap<IntArrayList> getMap() {
            return this.myMap;
        }
    }
}

